/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegisterFormat;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.dex.smali.model.SmaliRegister;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;

public class SmaliRegisterSet
extends SmaliSet<SmaliRegister>
implements Iterable<SmaliRegister> {
    private final RegisterFormat format;
    private RegistersTable registersTable;
    public static final SmaliRegisterSet NO_REGISTER_SET = new SmaliRegisterSet(RegisterFormat.NONE){

        @Override
        public boolean add(SmaliRegister smali) {
            throw new RuntimeException("NO_REGISTER_SET");
        }

        @Override
        public Iterator<SmaliRegister> iterator() {
            return EmptyIterator.of();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void append(SmaliWriter writer) {
        }

        @Override
        public void parse(SmaliReader reader) {
        }

        @Override
        public String toString() {
            return "";
        }
    };

    public SmaliRegisterSet(RegisterFormat format) {
        this.format = format;
    }

    public SmaliRegisterSet() {
        this(RegisterFormat.READ);
    }

    public RegistersTable getRegistersTable() {
        RegistersTable registersTable = this.registersTable;
        if (registersTable == null) {
            return this.getParentInstance(SmaliMethod.class);
        }
        return registersTable;
    }

    public void setRegistersTable(RegistersTable registersTable) {
        this.registersTable = registersTable;
    }

    public Register getRegister(int i) {
        SmaliRegister smaliRegister = (SmaliRegister)this.get(i);
        if (smaliRegister != null) {
            return smaliRegister.toRegister(this.getRegistersTable());
        }
        return null;
    }

    public RegisterFormat getFormat() {
        return this.format;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        String separator;
        boolean appendOnce = false;
        RegisterFormat format = this.getFormat();
        String string = separator = format.isRange() ? " .. " : ", ";
        if (format.isOut()) {
            writer.append('{');
        }
        for (SmaliRegister register : this) {
            if (appendOnce) {
                writer.append(separator);
            }
            register.append(writer);
            appendOnce = true;
        }
        if (format.isOut()) {
            writer.append('}');
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        RegisterFormat format = this.getFormat();
        if (format.isRange()) {
            this.parseOutRangeRegisters(reader);
        } else if (format.isOut()) {
            this.parseOutRegisters(reader);
        } else {
            this.parseRegisters(reader);
        }
    }

    private void parseRegisters(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        int size = this.getFormat().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                SmaliParseException.expect(reader, ',');
                reader.skipWhitespacesOrComment();
            }
            SmaliRegister register = new SmaliRegister();
            this.add(register);
            register.parse(reader);
            reader.skipWhitespacesOrComment();
        }
    }

    private void parseOutRegisters(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '{');
        reader.skipWhitespacesOrComment();
        boolean parsedOnce = false;
        while (!reader.finished() && reader.get() != 125) {
            if (parsedOnce) {
                SmaliParseException.expect(reader, ',');
                reader.skipWhitespacesOrComment();
            }
            SmaliRegister register = new SmaliRegister();
            this.add(register);
            register.parse(reader);
            reader.skipWhitespacesOrComment();
            parsedOnce = true;
        }
        SmaliParseException.expect(reader, '}');
    }

    private void parseOutRangeRegisters(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '{');
        reader.skipWhitespacesOrComment();
        SmaliRegister register1 = new SmaliRegister();
        this.add(register1);
        register1.parse(reader);
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '.');
        SmaliParseException.expect(reader, '.');
        reader.skipWhitespacesOrComment();
        SmaliRegister register2 = new SmaliRegister();
        this.add(register2);
        register2.parse(reader);
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '}');
    }
}

