/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.ins.InsArrayData;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliInstructionPayload;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import java.io.IOException;

public class SmaliPayloadArray
extends SmaliInstructionPayload<SmaliValueNumber<?>> {
    public SmaliPayloadArray() {
        super(new SmaliInstructionOperand.SmaliDecimalOperand());
    }

    public int[] unsignedInt() {
        SmaliSet entries = this.getEntries();
        int size = entries.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = ((SmaliValueNumber)entries.get(i)).unsignedInt();
        }
        return result;
    }

    public long[] unsignedLong() {
        SmaliSet entries = this.getEntries();
        int size = entries.size();
        long[] result = new long[size];
        for (int i = 0; i < size; ++i) {
            result[i] = ((SmaliValueNumber)entries.get(i)).unsignedLong();
        }
        return result;
    }

    @Override
    public SmaliInstructionOperand.SmaliDecimalOperand getOperand() {
        return (SmaliInstructionOperand.SmaliDecimalOperand)super.getOperand();
    }

    public int getWidth() {
        return this.getOperand().getNumber();
    }

    public void setWidth(int width) {
        this.getOperand().setNumber(width);
    }

    @Override
    public int getCodeUnits() {
        int count = this.getEntries().size();
        int width = this.getWidth();
        int size = 8 + width * count;
        int align = (4 - size % 4) % 4;
        return (size += align) / 2;
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.ARRAY_DATA;
    }

    @Override
    public Opcode<InsArrayData> getOpcode() {
        return Opcode.ARRAY_PAYLOAD;
    }

    @Override
    public SmaliValueNumber<?> newEntry(SmaliReader reader) throws IOException {
        SmaliValue value = SmaliValue.create(reader);
        if (!(value instanceof SmaliValueNumber)) {
            throw new SmaliParseException("Unrecognized array data entry", reader);
        }
        SmaliValueNumber valueNumber = (SmaliValueNumber)value;
        if (valueNumber.getWidth() > this.getWidth()) {
            throw new SmaliParseException("Value out of range", reader);
        }
        return valueNumber;
    }

    @Override
    void parseOperand(Opcode<?> opcode, SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        int position = reader.position();
        SmaliInstructionOperand.SmaliDecimalOperand operand = this.getOperand();
        operand.parse(opcode, reader);
        int number = operand.getNumber();
        if (number < 1 || number > 8) {
            reader.position(position);
            throw new SmaliParseException("Array width out of range (1 .. 8) : '" + number + "'", reader);
        }
    }
}

