/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationSet;
import com.reandroid.dex.smali.model.SmaliDebug;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.dex.smali.model.SmaliRegister;
import com.reandroid.dex.smali.model.SmaliRegisterSet;
import java.io.IOException;

public class SmaliMethodParameter
extends SmaliDebug
implements SmaliRegion {
    private final SmaliRegisterSet registerSet = new SmaliRegisterSet();
    private StringKey name;
    private SmaliAnnotationSet annotationSet;

    public SmaliRegister getSmaliRegister() {
        SmaliRegisterSet registerSet = this.getRegisterSet();
        if (registerSet.isEmpty()) {
            return null;
        }
        return (SmaliRegister)registerSet.get(0);
    }

    SmaliRegisterSet getRegisterSet() {
        return this.registerSet;
    }

    public StringKey getNameKey() {
        return this.name;
    }

    public void setName(StringKey name) {
        this.name = name;
    }

    public String getName() {
        StringKey key = this.getNameKey();
        if (key != null) {
            return key.getString();
        }
        return null;
    }

    public boolean hasAnnotations() {
        SmaliAnnotationSet annotationSet = this.getAnnotationSet();
        return annotationSet != null && !annotationSet.isEmpty();
    }

    public SmaliAnnotationSet getAnnotationSet() {
        return this.annotationSet;
    }

    public void setAnnotationSet(SmaliAnnotationSet annotationSet) {
        this.annotationSet = annotationSet;
        if (annotationSet != null) {
            annotationSet.setParent(this);
        }
    }

    public int getDefinitionIndex() {
        SmaliMethod smaliMethod = this.getParentInstance(SmaliMethod.class);
        if (smaliMethod == null) {
            return -1;
        }
        ProtoKey protoKey = smaliMethod.getProtoKey();
        if (protoKey == null) {
            return -1;
        }
        SmaliRegister smaliRegister = this.getSmaliRegister();
        if (smaliRegister == null) {
            return -1;
        }
        int index = smaliRegister.getNumber();
        if (!smaliMethod.isStatic()) {
            --index;
        }
        return protoKey.getParameterIndex(index);
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.PARAM;
    }

    @Override
    public DebugElementType<?> getDebugElementType() {
        return null;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        SmaliAnnotationSet annotationSet;
        SmaliDirective directive = this.getSmaliDirective();
        directive.append(writer);
        this.getRegisterSet().append(writer);
        StringKey name = this.getNameKey();
        if (name != null) {
            writer.append(", ");
            name.append(writer);
        }
        if ((annotationSet = this.getAnnotationSet()) != null) {
            writer.indentPlus();
            writer.newLine();
            annotationSet.append(writer);
            writer.indentMinus();
            directive.appendEnd(writer);
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        super.parse(reader);
        this.getRegisterSet().parse(reader);
        reader.skipWhitespacesOrComment();
        if (reader.get() == 44) {
            reader.skip(1);
            reader.skipWhitespacesOrComment();
        }
        this.parseName(reader);
        this.parseAnnotationSet(reader);
    }

    private void parseName(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        if (reader.get() == 34) {
            this.setName(StringKey.read(reader));
        }
    }

    private void parseAnnotationSet(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != SmaliDirective.ANNOTATION) {
            return;
        }
        int position = reader.position();
        SmaliAnnotationSet annotationSet = new SmaliAnnotationSet();
        annotationSet.parse(reader);
        reader.skipWhitespacesOrComment();
        if (this.getSmaliDirective().isEnd(reader)) {
            this.setAnnotationSet(annotationSet);
            SmaliDirective.parse(reader);
        } else {
            reader.position(position);
        }
    }
}

