/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.dex.smali.model.SmaliCodeSet;
import com.reandroid.dex.smali.model.SmaliCodeTryItem;
import com.reandroid.dex.smali.model.SmaliDebug;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliMethodParameter;
import com.reandroid.dex.smali.model.SmaliParamSet;
import java.io.IOException;
import java.util.Iterator;

public class SmaliMethod
extends SmaliDef
implements RegistersTable {
    private ProtoKey protoKey;
    private Integer locals;
    private final SmaliParamSet paramSet = new SmaliParamSet();
    private final SmaliCodeSet codeSet = new SmaliCodeSet();

    public SmaliMethod() {
        this.paramSet.setParent(this);
        this.codeSet.setParent(this);
    }

    @Override
    public MethodKey getKey() {
        SmaliClass smaliClass = this.getSmaliClass();
        if (smaliClass != null) {
            return this.getKey(smaliClass.getKey());
        }
        return null;
    }

    public MethodKey getKey(TypeKey declaring) {
        ProtoKey protoKey = this.getProtoKey();
        if (protoKey == null) {
            return null;
        }
        return new MethodKey(declaring, this.getName(), protoKey.getParameterNames(), protoKey.getReturnType());
    }

    public boolean hasInstructions() {
        return this.getInstructions().hasNext();
    }

    public Iterator<SmaliInstruction> getInstructions() {
        return this.getCodeSet().getInstructions();
    }

    public boolean hasDebugs() {
        return this.getDebugs().hasNext();
    }

    public Iterator<SmaliDebug> getDebugs() {
        return this.getCodeSet().getDebugs();
    }

    public Integer getLocals() {
        return this.locals;
    }

    public void setLocals(Integer locals) {
        this.locals = locals;
    }

    public ProtoKey getProtoKey() {
        return this.protoKey;
    }

    public void setProtoKey(ProtoKey protoKey) {
        this.protoKey = protoKey;
    }

    public SmaliParamSet getParamSet() {
        return this.paramSet;
    }

    public Iterator<SmaliMethodParameter> getParameters() {
        return this.getParamSet().iterator();
    }

    public SmaliCodeSet getCodeSet() {
        return this.codeSet;
    }

    public Iterator<SmaliCodeTryItem> getTryItems() {
        return this.getCodeSet().iterator(SmaliCodeTryItem.class);
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.METHOD;
    }

    public boolean isConstructor() {
        return Modifier.contains(this.getAccessFlags(), AccessFlag.CONSTRUCTOR);
    }

    public boolean isDirect() {
        return this.isConstructor() || this.isStatic() || this.isPrivate();
    }

    public boolean isVirtual() {
        return !this.isDirect();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        Modifier.append(writer, this.getAccessFlags());
        writer.append(this.getName());
        this.getProtoKey().append(writer);
        writer.indentPlus();
        Integer locals = this.getLocals();
        if (locals != null) {
            writer.newLine();
            SmaliDirective.LOCALS.append(writer);
            writer.appendInteger(locals);
        }
        this.getParamSet().append(writer);
        if (this.hasAnnotation()) {
            writer.newLine();
            this.getAnnotation().append(writer);
        }
        this.getCodeSet().append(writer);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        SmaliParseException.expect(reader, this.getSmaliDirective());
        this.setAccessFlags(AccessFlag.parse(reader));
        this.parseName(reader);
        this.parseProto(reader);
        reader.skipWhitespacesOrComment();
        while (this.parseNoneCode(reader)) {
            reader.skipWhitespacesOrComment();
        }
        this.getCodeSet().parse(reader);
        SmaliParseException.expect(reader, this.getSmaliDirective(), true);
    }

    private boolean parseNoneCode(SmaliReader reader) throws IOException {
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive == SmaliDirective.LOCALS) {
            this.parseLocals(reader);
            return true;
        }
        if (directive == SmaliDirective.ANNOTATION) {
            this.getOrCreateAnnotation().parse(reader);
            return true;
        }
        if (directive == SmaliDirective.PARAM) {
            this.getParamSet().parse(reader);
            return true;
        }
        return false;
    }

    private void parseLocals(SmaliReader reader) throws IOException {
        SmaliParseException.expect(reader, SmaliDirective.LOCALS);
        reader.skipSpaces();
        this.setLocals(reader.readInteger());
    }

    private void parseName(SmaliReader reader) {
        reader.skipWhitespaces();
        int length = reader.indexOf('(') - reader.position();
        this.setName(reader.readString(length));
    }

    private void parseProto(SmaliReader reader) throws IOException {
        reader.skipWhitespaces();
        this.setProtoKey(ProtoKey.read(reader));
    }

    @Override
    public int getRegistersCount() {
        return this.getLocalRegistersCount() + this.getParameterRegistersCount();
    }

    @Override
    public int getParameterRegistersCount() {
        int count = this.isStatic() ? 0 : 1;
        ProtoKey protoKey = this.getProtoKey();
        if (protoKey != null) {
            count += protoKey.getParameterRegistersCount();
        }
        return count;
    }

    @Override
    public void setRegistersCount(int count) {
    }

    @Override
    public void setParameterRegistersCount(int count) {
    }

    @Override
    public void ensureLocalRegistersCount(int count) {
    }

    @Override
    public int getLocalRegistersCount() {
        Integer locals = this.getLocals();
        if (locals != null) {
            return locals;
        }
        return 0;
    }

    @Override
    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        SmaliClass smaliClass = this.getSmaliClass();
        if (smaliClass != null) {
            builder.append(smaliClass.toDebugString());
            builder.append(", ");
        }
        builder.append("method = ");
        builder.append(this.getName());
        builder.append(this.getProtoKey());
        return builder.toString();
    }
}

