/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliValidateException;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCode;
import com.reandroid.dex.smali.model.SmaliCodeSet;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class SmaliLabel
extends SmaliCode {
    private String labelName;
    private int temporaryAddress = -1;

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public int getIntegerData() throws IOException {
        int address = this.getAddress();
        if (address == -1) {
            throw new SmaliValidateException("Missing target label '" + this.getLabelName() + "'", this);
        }
        return address;
    }

    public int getAddress() {
        int address = this.searchAddress();
        if (address < 0) {
            address = this.temporaryAddress;
        }
        return address;
    }

    private int searchAddress() {
        SmaliCodeSet codeSet = this.getCodeSet();
        if (codeSet == null) {
            return -1;
        }
        if (codeSet != this.getParent()) {
            int i = codeSet.indexOf(this);
            if (i < 0) {
                return -1;
            }
            SmaliLabel label = (SmaliLabel)codeSet.get(i);
            return label.getAddress();
        }
        Iterator iterator = codeSet.iterator(codeSet.indexOf(this) + 1);
        SmaliInstruction next = CollectionUtil.getFirst(InstanceIterator.of(iterator, SmaliInstruction.class));
        if (next != null) {
            return next.getAddress();
        }
        return -1;
    }

    public void setTemporaryAddress(int address) {
        this.temporaryAddress = address;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(':');
        writer.append(this.getLabelName());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespaces();
        SmaliParseException.expect(reader, ':');
        int i1 = reader.indexOfWhiteSpaceOrComment();
        int i2 = reader.indexOfBeforeLineEnd('}');
        int i = i2 >= 0 && i2 < i1 ? i2 : i1;
        int length = i - reader.position();
        this.setLabelName(reader.readString(length));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SmaliLabel)) {
            return false;
        }
        SmaliLabel other = (SmaliLabel)obj;
        return ObjectsUtil.equals(this.getLabelName(), other.getLabelName());
    }

    public int hashCode() {
        return Objects.hash(this.getLabelName());
    }
}

