/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInterface;
import com.reandroid.dex.smali.model.SmaliSet;
import java.io.IOException;

public class SmaliInterfaceSet
extends SmaliSet<SmaliInterface>
implements SmaliRegion,
Iterable<SmaliInterface> {
    public TypeListKey getKey() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        String[] typeNames = new String[size];
        for (int i = 0; i < size; ++i) {
            typeNames[i] = ((SmaliInterface)this.get(i)).getTypeName();
        }
        return new TypeListKey(typeNames);
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.IMPLEMENTS;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.newLine();
        writer.newLine();
        writer.newLine();
        writer.appendComment("interfaces");
        writer.newLine();
        writer.appendAll(this.iterator());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        while (this.parseNext(reader)) {
            reader.skipWhitespaces();
        }
    }

    private boolean parseNext(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != this.getSmaliDirective()) {
            return false;
        }
        SmaliInterface item = new SmaliInterface();
        this.add(item);
        item.parse(reader);
        return true;
    }
}

