/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.OperandType;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliValueInteger;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import java.io.IOException;

public abstract class SmaliInstructionOperand
extends Smali {
    public static final SmaliInstructionOperand NO_OPERAND = new SmaliInstructionOperand(){

        @Override
        public int getIntegerData() {
            return -1;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public long getLongData() {
            return -1L;
        }

        @Override
        public void append(SmaliWriter writer) {
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) {
            reader.skipSpaces();
        }

        @Override
        void setParent(Smali parent) {
        }
    };

    public long getLongData() throws IOException {
        return (long)this.getIntegerData() & 0xFFFFFFFFL;
    }

    public abstract int getIntegerData() throws IOException;

    public abstract OperandType getOperandType();

    @Override
    public abstract void append(SmaliWriter var1) throws IOException;

    @Override
    public final void parse(SmaliReader reader) throws IOException {
        throw new RuntimeException("Must call parse(Opcode, SmaliReader)");
    }

    public abstract void parse(Opcode<?> var1, SmaliReader var2) throws IOException;

    public static class SmaliKeyOperand
    extends SmaliInstructionOperand {
        private Key key;

        public Key getKey() {
            return this.key;
        }

        public void setKey(Key key) {
            this.key = key;
        }

        @Override
        public int getIntegerData() {
            return -1;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public long getLongData() {
            return -1L;
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            Key key = this.getKey();
            if (key != null) {
                key.append(writer);
            }
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) throws IOException {
            Key key;
            SectionType<IdItem> sectionType = opcode.getSectionType();
            if (sectionType == SectionType.STRING_ID) {
                key = StringKey.read(reader);
            } else if (sectionType == SectionType.TYPE_ID) {
                key = TypeKey.read(reader);
            } else if (sectionType == SectionType.FIELD_ID) {
                key = FieldKey.read(reader);
            } else if (sectionType == SectionType.METHOD_ID) {
                key = MethodKey.read(reader);
            } else {
                throw new SmaliParseException("Invalid key", reader);
            }
            this.setKey(key);
        }
    }

    public static class SmaliDecimalOperand
    extends SmaliInstructionOperand {
        private int number;

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        @Override
        public int getIntegerData() {
            return this.getNumber();
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.DECIMAL;
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.appendInteger(this.getNumber());
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) throws IOException {
            reader.skipSpaces();
            this.setNumber(reader.readInteger());
        }
    }

    public static class SmaliHexOperand
    extends SmaliInstructionOperand {
        private SmaliValueNumber<?> valueNumber = new SmaliValueInteger();

        public Number getNumber() {
            return this.valueNumber.getNumber();
        }

        public void setNumber(Number number) {
            this.setNumberValue(SmaliValueNumber.createFor(number));
        }

        public SmaliValueNumber<?> getValueNumber() {
            return this.valueNumber;
        }

        public void setNumberValue(SmaliValueNumber<?> valueNumber) {
            this.valueNumber = valueNumber;
            if (valueNumber != null) {
                valueNumber.setParent(this);
            }
        }

        @Override
        public int getIntegerData() {
            return this.valueNumber.unsignedInt();
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public long getLongData() {
            return this.valueNumber.unsignedLong();
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.appendOptional(this.getValueNumber());
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) throws IOException {
            reader.skipSpaces();
            SmaliValueNumber<?> value = SmaliValueNumber.createNumber(reader);
            this.setNumberValue(value);
            value.parse(reader);
        }
    }

    public static class SmaliLabelOperand
    extends SmaliInstructionOperand {
        private final SmaliLabel label = new SmaliLabel();

        public SmaliLabelOperand() {
            this.label.setParent(this);
        }

        public SmaliLabel getLabel() {
            return this.label;
        }

        @Override
        public int getIntegerData() throws IOException {
            return this.getLabel().getIntegerData();
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.LABEL;
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            this.getLabel().append(writer);
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) throws IOException {
            this.getLabel().parse(reader);
        }
    }
}

