/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.OperandType;
import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegisterFormat;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCode;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliRegisterSet;
import java.io.IOException;

public class SmaliInstruction
extends SmaliCode {
    private Opcode<?> opcode = Opcode.NOP;
    private SmaliRegisterSet registerSet = SmaliRegisterSet.NO_REGISTER_SET;
    private SmaliInstructionOperand operand = SmaliInstructionOperand.NO_OPERAND;
    private int address;

    public Key getKey() {
        SmaliInstructionOperand operand = this.getOperand();
        if (operand instanceof SmaliInstructionOperand.SmaliKeyOperand) {
            return ((SmaliInstructionOperand.SmaliKeyOperand)operand).getKey();
        }
        return null;
    }

    public Number getData() throws IOException {
        SmaliInstructionOperand operand = this.getOperand();
        if (operand instanceof SmaliInstructionOperand.SmaliHexOperand) {
            return ((SmaliInstructionOperand.SmaliHexOperand)operand).getNumber();
        }
        if (operand instanceof SmaliInstructionOperand.SmaliLabelOperand) {
            return operand.getIntegerData() - this.getAddress();
        }
        return null;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public int getCodeUnits() {
        return this.getOpcode().size() / 2;
    }

    public Register getRegister() {
        return this.getRegister(0);
    }

    public Register getRegister(int i) {
        return this.getRegisterSet().getRegister(i);
    }

    public int getRegistersCount() {
        return this.getRegisterSet().size();
    }

    public RegistersTable getRegistersTable() {
        SmaliRegisterSet registerSet = this.getRegisterSet();
        if (registerSet != null) {
            return registerSet.getRegistersTable();
        }
        return null;
    }

    public void setRegistersTable(RegistersTable registersTable) {
        SmaliRegisterSet registerSet = this.getRegisterSet();
        if (registerSet != null) {
            registerSet.setRegistersTable(registersTable);
        }
    }

    public SmaliRegisterSet getRegisterSet() {
        return this.registerSet;
    }

    public void setRegisterSet(SmaliRegisterSet registerSet) {
        this.registerSet = registerSet;
        if (registerSet != null) {
            registerSet.setParent(this);
        }
    }

    public SmaliInstructionOperand getOperand() {
        return this.operand;
    }

    public OperandType getOperandType() {
        return this.getOperand().getOperandType();
    }

    public void setOperand(SmaliInstructionOperand operand) {
        this.operand = operand;
        if (operand != null) {
            operand.setParent(this);
        }
    }

    public boolean hasLabel(SmaliLabel label) {
        SmaliInstructionOperand operand = this.getOperand();
        if (!(operand instanceof SmaliInstructionOperand.SmaliLabelOperand)) {
            return false;
        }
        SmaliInstructionOperand.SmaliLabelOperand smaliLabelOperand = (SmaliInstructionOperand.SmaliLabelOperand)operand;
        return label.equals(smaliLabelOperand.getLabel());
    }

    public Opcode<?> getOpcode() {
        return this.opcode;
    }

    public void initializeOpcode(Opcode<?> opcode) {
        this.opcode = opcode;
        this.initRegisterSet(opcode);
        this.initOperand(opcode);
    }

    private void initRegisterSet(Opcode<?> opcode) {
        RegisterFormat format = opcode.getRegisterFormat();
        SmaliRegisterSet registerSet = format == RegisterFormat.NONE ? SmaliRegisterSet.NO_REGISTER_SET : new SmaliRegisterSet(format);
        this.setRegisterSet(registerSet);
    }

    private void initOperand(Opcode<?> opcode) {
        SmaliInstructionOperand operand;
        OperandType operandType = opcode.getOperandType();
        if (operandType == OperandType.NONE) {
            operand = SmaliInstructionOperand.NO_OPERAND;
        } else if (operandType == OperandType.HEX) {
            operand = new SmaliInstructionOperand.SmaliHexOperand();
        } else if (operandType == OperandType.KEY) {
            operand = new SmaliInstructionOperand.SmaliKeyOperand();
        } else if (operandType == OperandType.LABEL) {
            operand = new SmaliInstructionOperand.SmaliLabelOperand();
        } else if (operandType == OperandType.DECIMAL) {
            operand = new SmaliInstructionOperand.SmaliDecimalOperand();
        } else {
            throw new RuntimeException("Unknown operand type: " + operandType + ", opcode = " + opcode);
        }
        this.setOperand(operand);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        Opcode<?> opcode = this.getOpcode();
        if (opcode == null) {
            return;
        }
        writer.newLine();
        opcode.append(writer);
        SmaliRegisterSet registerSet = this.getRegisterSet();
        if (registerSet != null) {
            registerSet.append(writer);
        }
        if (opcode.getRegisterFormat() != RegisterFormat.NONE && opcode.getOperandType() != OperandType.NONE) {
            writer.append(", ");
        }
        this.getOperand().append(writer);
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        Opcode<?> opcode = this.parseOpcode(reader);
        this.getRegisterSet().parse(reader);
        if (opcode.getRegisterFormat() != RegisterFormat.NONE && opcode.getOperandType() != OperandType.NONE) {
            reader.skipWhitespacesOrComment();
            SmaliParseException.expect(reader, ',');
            reader.skipWhitespacesOrComment();
        }
        this.getOperand().parse(opcode, reader);
    }

    private Opcode<?> parseOpcode(SmaliReader reader) {
        reader.skipWhitespaces();
        Opcode<?> opcode = Opcode.parseSmali(reader, true);
        this.initializeOpcode(opcode);
        reader.skipSpaces();
        return opcode;
    }
}

