/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.dex.smali.model.SmaliDefSet;
import com.reandroid.dex.smali.model.SmaliField;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.util.Iterator;

public class SmaliFieldSet
extends SmaliDefSet<SmaliField> {
    public Iterator<SmaliField> getStaticFields() {
        return FilterIterator.of(this.iterator(), SmaliDef::isStatic);
    }

    public Iterator<SmaliField> getInstanceFields() {
        return FilterIterator.of(this.iterator(), SmaliField::isInstance);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        boolean appendOnce = false;
        Iterator<SmaliField> iterator = this.getStaticFields();
        while (iterator.hasNext()) {
            writer.newLineDouble();
            if (!appendOnce) {
                writer.appendComment("static fields");
                writer.newLine();
            }
            iterator.next().append(writer);
            appendOnce = true;
        }
        appendOnce = false;
        iterator = this.getInstanceFields();
        while (iterator.hasNext()) {
            writer.newLineDouble();
            if (!appendOnce) {
                writer.appendComment("instance fields");
                writer.newLine();
            }
            iterator.next().append(writer);
            appendOnce = true;
        }
    }

    @Override
    public SmaliField createNew() {
        return new SmaliField();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.FIELD;
    }
}

