/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationSet;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.dex.smali.model.SmaliValue;
import java.io.IOException;

public class SmaliField
extends SmaliDef {
    private TypeKey type;
    private SmaliValue value;

    @Override
    public FieldKey getKey() {
        SmaliClass smaliClass = this.getSmaliClass();
        if (smaliClass != null) {
            return this.getKey(smaliClass.getKey());
        }
        return null;
    }

    public FieldKey getKey(TypeKey declaring) {
        TypeKey type = this.getType();
        if (type == null) {
            return null;
        }
        return new FieldKey(declaring.getTypeName(), this.getName(), type.getTypeName());
    }

    public TypeKey getType() {
        return this.type;
    }

    public void setType(TypeKey type) {
        this.type = type;
    }

    public SmaliValue getValue() {
        return this.value;
    }

    public void setValue(SmaliValue value) {
        this.value = value;
        if (value != null) {
            value.setParent(this);
        }
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.FIELD;
    }

    public boolean isInstance() {
        return !this.isStatic();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        SmaliAnnotationSet annotationSet;
        this.getSmaliDirective().append(writer);
        Modifier.append(writer, this.getAccessFlags());
        writer.append(this.getName());
        writer.append(':');
        this.getType().append(writer);
        SmaliValue value = this.getValue();
        if (value != null) {
            writer.append(" = ");
            value.append(writer);
        }
        if ((annotationSet = this.getAnnotation()) != null && !annotationSet.isEmpty()) {
            writer.indentPlus();
            writer.newLine();
            annotationSet.append(writer);
            writer.indentMinus();
            this.getSmaliDirective().appendEnd(writer);
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        SmaliParseException.expect(reader, this.getSmaliDirective());
        this.setAccessFlags(AccessFlag.parse(reader));
        this.parseName(reader);
        this.setType(TypeKey.read(reader));
        this.parseValue(reader);
        this.parseAnnotationSet(reader);
    }

    private void parseName(SmaliReader reader) {
        reader.skipWhitespaces();
        int length = reader.indexOf(':') - reader.position();
        this.setName(reader.readString(length));
        reader.skip(1);
    }

    private void parseValue(SmaliReader reader) throws IOException {
        reader.skipWhitespaces();
        if (reader.get() != 61) {
            return;
        }
        reader.skip(1);
        reader.skipWhitespaces();
        SmaliValue value = SmaliValue.create(reader);
        this.setValue(value);
        value.parse(reader);
    }

    private void parseAnnotationSet(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != SmaliDirective.ANNOTATION) {
            return;
        }
        int position = reader.position();
        SmaliAnnotationSet annotationSet = new SmaliAnnotationSet();
        annotationSet.parse(reader);
        reader.skipWhitespacesOrComment();
        if (this.getSmaliDirective().isEnd(reader)) {
            this.setAnnotation(annotationSet);
            SmaliDirective.parse(reader);
        } else {
            reader.position(position);
        }
    }

    @Override
    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        SmaliClass smaliClass = this.getSmaliClass();
        if (smaliClass != null) {
            builder.append(smaliClass.toDebugString());
            builder.append(", ");
        }
        builder.append("field = ");
        builder.append(this.getName());
        builder.append(':');
        builder.append(this.getType());
        SmaliValue value = this.getValue();
        if (value != null) {
            builder.append(" = ");
            builder.append(value.toDebugString());
        }
        return builder.toString();
    }
}

