/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCode;
import com.reandroid.dex.smali.model.SmaliCodeSet;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.util.Iterator;

public abstract class SmaliDebug
extends SmaliCode
implements SmaliRegion {
    public int getAddress() {
        return this.searchAddress();
    }

    private int searchAddress() {
        SmaliCodeSet codeSet = this.getCodeSet();
        if (codeSet == null) {
            return -1;
        }
        Iterator iterator = codeSet.iterator(codeSet.indexOf(this) + 1);
        SmaliInstruction next = CollectionUtil.getFirst(InstanceIterator.of(iterator, SmaliInstruction.class));
        if (next != null) {
            return next.getAddress();
        }
        return -1;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, this.getSmaliDirective());
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return this.getDebugElementType().getSmaliDirective();
    }

    public abstract DebugElementType<?> getDebugElementType();
}

