/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCode;
import com.reandroid.dex.smali.model.SmaliCodeTryItem;
import com.reandroid.dex.smali.model.SmaliDebug;
import com.reandroid.dex.smali.model.SmaliDebugEndLocal;
import com.reandroid.dex.smali.model.SmaliDebugEpilogue;
import com.reandroid.dex.smali.model.SmaliDebugLocal;
import com.reandroid.dex.smali.model.SmaliDebugPrologue;
import com.reandroid.dex.smali.model.SmaliDebugRestartLocal;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliLineNumber;
import com.reandroid.dex.smali.model.SmaliMethodParameter;
import com.reandroid.dex.smali.model.SmaliPayloadArray;
import com.reandroid.dex.smali.model.SmaliPayloadPackedSwitch;
import com.reandroid.dex.smali.model.SmaliPayloadSparseSwitch;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.util.Iterator;

public class SmaliCodeSet
extends SmaliSet<SmaliCode> {
    public void updateAddresses() {
        int address = 0;
        Iterator<SmaliInstruction> iterator = this.getInstructions();
        while (iterator.hasNext()) {
            SmaliInstruction ins = iterator.next();
            ins.setAddress(address);
            address += ins.getCodeUnits();
        }
    }

    public Iterator<SmaliInstruction> getInstructions() {
        return InstanceIterator.of(this.iterator(), SmaliInstruction.class);
    }

    public Iterator<SmaliDebug> getDebugs() {
        return InstanceIterator.of(this.iterator(), SmaliDebug.class);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.newLine();
        writer.appendAll(this.iterator());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        SmaliCode code;
        while ((code = this.createNext(reader)) != null) {
            this.add(code);
            code.parse(reader);
            reader.skipWhitespacesOrComment();
        }
        this.updateAddresses();
    }

    private SmaliCode createNext(SmaliReader reader) {
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != null) {
            return SmaliCodeSet.createFor(directive);
        }
        reader.skipWhitespaces();
        if (reader.get() == 58) {
            return new SmaliLabel();
        }
        Opcode<?> opcode = Opcode.parseSmali(reader, false);
        if (opcode != null) {
            return new SmaliInstruction();
        }
        return null;
    }

    public static SmaliCode createFor(SmaliDirective directive) {
        if (directive == SmaliDirective.LINE) {
            return new SmaliLineNumber();
        }
        if (directive == SmaliDirective.CATCH || directive == SmaliDirective.CATCH_ALL) {
            return new SmaliCodeTryItem();
        }
        if (directive == SmaliDirective.PARAM) {
            return new SmaliMethodParameter();
        }
        if (directive == SmaliDirective.END_LOCAL) {
            return new SmaliDebugEndLocal();
        }
        if (directive == SmaliDirective.LOCAL) {
            return new SmaliDebugLocal();
        }
        if (directive == SmaliDirective.RESTART_LOCAL) {
            return new SmaliDebugRestartLocal();
        }
        if (directive == SmaliDirective.ARRAY_DATA) {
            return new SmaliPayloadArray();
        }
        if (directive == SmaliDirective.PACKED_SWITCH) {
            return new SmaliPayloadPackedSwitch();
        }
        if (directive == SmaliDirective.SPARSE_SWITCH) {
            return new SmaliPayloadSparseSwitch();
        }
        if (directive == SmaliDirective.PROLOGUE) {
            return new SmaliDebugPrologue();
        }
        if (directive == SmaliDirective.EPILOGUE) {
            return new SmaliDebugEpilogue();
        }
        return null;
    }
}

