/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.dex.smali.model.SmaliField;
import com.reandroid.dex.smali.model.SmaliFieldSet;
import com.reandroid.dex.smali.model.SmaliInterfaceSet;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.dex.smali.model.SmaliMethodSet;
import java.io.IOException;
import java.util.Iterator;

public class SmaliClass
extends SmaliDef {
    private TypeKey superClass;
    private StringKey sourceFile;
    private final SmaliInterfaceSet interfaces = new SmaliInterfaceSet();
    private final SmaliFieldSet fields = new SmaliFieldSet();
    private final SmaliMethodSet methods = new SmaliMethodSet();

    public SmaliClass() {
        this.interfaces.setParent(this);
        this.fields.setParent(this);
        this.methods.setParent(this);
    }

    @Override
    public TypeKey getKey() {
        return TypeKey.create(this.getName());
    }

    public void setKey(TypeKey key) {
        String name = key != null ? key.getTypeName() : null;
        this.setName(name);
    }

    public TypeKey getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(TypeKey typeKey) {
        this.superClass = typeKey;
    }

    public StringKey getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(StringKey sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getSourceFileName() {
        StringKey key = this.getSourceFile();
        if (key != null) {
            return key.getString();
        }
        return null;
    }

    public SmaliInterfaceSet getInterfaces() {
        return this.interfaces;
    }

    public TypeListKey getInterfacesKey() {
        return this.getInterfaces().getKey();
    }

    public boolean hasClassData() {
        return !this.fields.isEmpty() || !this.methods.isEmpty();
    }

    public Iterator<SmaliField> getStaticFields() {
        return this.fields.getStaticFields();
    }

    public Iterator<SmaliField> getInstanceFields() {
        return this.fields.getInstanceFields();
    }

    public Iterator<SmaliMethod> getDirectMethods() {
        return this.methods.getDirectMethods();
    }

    public Iterator<SmaliMethod> getVirtualMethods() {
        return this.methods.getVirtualMethods();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.CLASS;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        Modifier.append(writer, this.getAccessFlags());
        writer.appendOptional(this.getKey());
        writer.newLine();
        SmaliDirective.SUPER.append(writer);
        writer.appendOptional(this.getSuperClass());
        StringKey source = this.getSourceFile();
        if (source != null) {
            writer.newLine();
            SmaliDirective.SOURCE.append(writer);
            source.append(writer);
        }
        this.getInterfaces().append(writer);
        if (this.hasAnnotation()) {
            writer.newLine(2);
            writer.appendComment("annotations");
            writer.appendAllWithDoubleNewLine(this.getAnnotation().iterator());
        }
        this.fields.append(writer);
        this.methods.append(writer);
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, SmaliDirective.CLASS);
        this.setAccessFlags(AccessFlag.parse(reader));
        this.setKey(TypeKey.read(reader));
        while (this.parseNext(reader)) {
            reader.skipWhitespacesOrComment();
        }
        reader.skipWhitespacesOrComment();
    }

    private boolean parseNext(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive == SmaliDirective.CLASS) {
            return false;
        }
        if (directive == SmaliDirective.SUPER) {
            this.parseSuper(reader);
            return true;
        }
        if (directive == SmaliDirective.SOURCE) {
            this.parseSource(reader);
            return true;
        }
        if (directive == SmaliDirective.ANNOTATION) {
            this.getOrCreateAnnotation().parse(reader);
            return true;
        }
        if (directive == SmaliDirective.FIELD) {
            this.fields.parse(reader);
            return true;
        }
        if (directive == SmaliDirective.METHOD) {
            this.methods.parse(reader);
            return true;
        }
        if (directive == SmaliDirective.IMPLEMENTS) {
            this.interfaces.parse(reader);
            return true;
        }
        return false;
    }

    private void parseSuper(SmaliReader reader) throws IOException {
        SmaliParseException.expect(reader, SmaliDirective.SUPER);
        this.setSuperClass(TypeKey.read(reader));
    }

    private void parseSource(SmaliReader reader) throws IOException {
        SmaliParseException.expect(reader, SmaliDirective.SOURCE);
        reader.skipSpaces();
        this.setSourceFile(StringKey.read(reader));
    }

    @Override
    public String toDebugString() {
        return "class = " + this.getKey();
    }
}

