/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationElement;
import com.reandroid.dex.smali.model.SmaliSet;
import java.io.IOException;

public class SmaliAnnotationItem
extends SmaliSet<SmaliAnnotationElement>
implements SmaliRegion {
    private SmaliDirective smaliDirective;
    private AnnotationVisibility visibility;
    private TypeKey type;

    public AnnotationVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(AnnotationVisibility visibility) {
        this.visibility = visibility;
    }

    public TypeKey getType() {
        return this.type;
    }

    public void setType(TypeKey type) {
        this.type = type;
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return this.smaliDirective;
    }

    public void setSmaliDirective(SmaliDirective smaliDirective) {
        this.smaliDirective = smaliDirective;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        writer.appendOptional(this.getVisibility());
        writer.appendOptional(this.getType());
        writer.appendAllWithIndent(this.iterator());
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        int position = reader.position();
        SmaliDirective directive = SmaliDirective.parse(reader);
        if (directive != SmaliDirective.ANNOTATION && directive != SmaliDirective.SUB_ANNOTATION) {
            reader.position(position);
            throw new SmaliParseException("Expecting " + SmaliDirective.ANNOTATION + " || " + SmaliDirective.SUB_ANNOTATION, reader);
        }
        this.setSmaliDirective(directive);
        this.setVisibility(AnnotationVisibility.parse(reader));
        this.setType(TypeKey.read(reader));
        while (this.parseElements(reader)) {
            reader.skipWhitespacesOrComment();
        }
        SmaliParseException.expect(reader, this.getSmaliDirective(), true);
    }

    private boolean parseElements(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        if (this.getSmaliDirective().isEnd(reader)) {
            return false;
        }
        SmaliAnnotationElement element = new SmaliAnnotationElement();
        this.add(element);
        element.parse(reader);
        return true;
    }
}

