/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali;

import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;

public class SmaliDirective
implements SmaliFormat {
    private static final byte[] END_BYTES = new byte[]{46, 101, 110, 100};
    public static final SmaliDirective CLASS = new SmaliDirective("class");
    public static final SmaliDirective SUPER = new SmaliDirective("super");
    public static final SmaliDirective SOURCE = new SmaliDirective("source");
    public static final SmaliDirective IMPLEMENTS = new SmaliDirective("implements");
    public static final SmaliDirective ANNOTATION = new SmaliDirective("annotation");
    public static final SmaliDirective SUB_ANNOTATION = new SmaliDirective("subannotation");
    public static final SmaliDirective FIELD = new SmaliDirective("field");
    public static final SmaliDirective METHOD = new SmaliDirective("method");
    public static final SmaliDirective ENUM = new SmaliDirective("enum");
    public static final SmaliDirective CATCH_ALL;
    public static final SmaliDirective CATCH;
    public static final SmaliDirective LOCALS;
    public static final SmaliDirective ARRAY_DATA;
    public static final SmaliDirective PACKED_SWITCH;
    public static final SmaliDirective SPARSE_SWITCH;
    public static final SmaliDirective PROLOGUE;
    public static final SmaliDirective PARAM;
    public static final SmaliDirective END_LOCAL;
    public static final SmaliDirective LOCAL;
    public static final SmaliDirective LINE;
    public static final SmaliDirective RESTART_LOCAL;
    public static final SmaliDirective EPILOGUE;
    public static final SmaliDirective SET_SOURCE_FILE;
    private static final SmaliDirective[] VALUES;
    private final String name;
    private final byte[] nameBytes;
    private final boolean methodCode;

    SmaliDirective(String name, byte[] nameBytes, boolean methodCode) {
        this.name = name;
        this.nameBytes = nameBytes;
        this.methodCode = methodCode;
    }

    SmaliDirective(String name, boolean methodCode) {
        this(name, StringsUtil.getASCII(name), methodCode);
    }

    SmaliDirective(String name) {
        this(name, StringsUtil.getASCII(name), false);
    }

    public String getName() {
        return this.name;
    }

    public boolean isMethodCode() {
        return this.methodCode;
    }

    public boolean is(SmaliDirective smaliDirective) {
        return smaliDirective == this;
    }

    boolean readMatches(SmaliReader reader) {
        int length = reader.startsWithSqueezeSpaces(this.nameBytes);
        if (length > 0) {
            reader.skip(length);
            return true;
        }
        return false;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append('.');
        writer.append(this.getName());
        writer.append(' ');
    }

    public void appendEnd(SmaliWriter writer) throws IOException {
        writer.newLine();
        writer.append(".end ");
        writer.append(this.getName());
    }

    public boolean isEnd(SmaliReader reader) {
        if (!reader.startsWith(END_BYTES)) {
            return false;
        }
        return SmaliDirective.parse(reader, false) == this;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "." + this.getName();
    }

    public String toString(boolean end) {
        if (end) {
            return ".end " + this.getName();
        }
        return "." + this.getName();
    }

    public static SmaliDirective parse(SmaliReader reader) {
        return SmaliDirective.parse(reader, true);
    }

    public static SmaliDirective parse(SmaliReader reader, boolean skip) {
        if (reader == null) {
            return null;
        }
        int position = reader.position();
        reader.skipWhitespaces();
        if (reader.get() != 46) {
            reader.position(position);
            return null;
        }
        if (reader.startsWith(END_BYTES)) {
            reader.skip(1);
            if (END_LOCAL.readMatches(reader)) {
                if (!skip) {
                    reader.position(position);
                }
                return END_LOCAL;
            }
            reader.skip(END_BYTES.length - 1);
            reader.skipWhitespaces();
        } else {
            reader.skip(1);
        }
        SmaliDirective directive = SmaliDirective.directiveOf(reader);
        if (!skip) {
            reader.position(position);
        }
        return directive;
    }

    private static SmaliDirective directiveOf(SmaliReader reader) {
        for (SmaliDirective smaliDirective : VALUES) {
            if (!smaliDirective.readMatches(reader)) continue;
            return smaliDirective;
        }
        return null;
    }

    static {
        LOCALS = new SmaliDirective("locals");
        CATCH = new SmaliDirective("catch", true);
        CATCH_ALL = new SmaliDirective("catchall", true);
        ARRAY_DATA = new SmaliDirective("array-data", true);
        PACKED_SWITCH = new SmaliDirective("packed-switch", true);
        SPARSE_SWITCH = new SmaliDirective("sparse-switch", true);
        LINE = new SmaliDirective("line", true);
        RESTART_LOCAL = new SmaliDirective("restart local", true);
        PROLOGUE = new SmaliDirective("prologue", true);
        PARAM = new SmaliDirective("param", true);
        END_LOCAL = new SmaliDirective("end local", true);
        LOCAL = new SmaliDirective("local", true);
        EPILOGUE = new SmaliDirective("epilogue", true);
        SET_SOURCE_FILE = new SmaliDirective("set source file", true);
        VALUES = new SmaliDirective[]{CLASS, SUPER, SOURCE, IMPLEMENTS, ANNOTATION, SUB_ANNOTATION, FIELD, METHOD, ENUM, LOCALS, CATCH_ALL, CATCH, ARRAY_DATA, PACKED_SWITCH, SPARSE_SWITCH, LINE, RESTART_LOCAL, EPILOGUE, SET_SOURCE_FILE, PROLOGUE, PARAM, END_LOCAL, LOCAL};
    }
}

