/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.dex.smali.SmaliWriter;
import java.io.IOException;

public interface ResourceIdComment {
    public void writeResourceIdComment(SmaliWriter var1, int var2) throws IOException;

    public static class ResourceTableComment
    implements ResourceIdComment {
        private final PackageBlock packageBlock;
        private final TableBlock tableBlock;

        public ResourceTableComment(PackageBlock packageBlock) {
            this.packageBlock = packageBlock;
            this.tableBlock = packageBlock.getTableBlock();
        }

        @Override
        public void writeResourceIdComment(SmaliWriter writer, int resourceId) throws IOException {
            if (!PackageBlock.isResourceId(resourceId)) {
                return;
            }
            String comment = this.buildComment(resourceId);
            if (comment != null) {
                writer.appendComment(comment);
            }
        }

        private String buildComment(int resourceId) {
            ResourceEntry resourceEntry = this.tableBlock.getResource(resourceId);
            if (resourceEntry == null || !resourceEntry.isDeclared()) {
                return null;
            }
            String ref = resourceEntry.buildReference(this.packageBlock, ValueType.REFERENCE);
            if (resourceEntry.getPackageBlock().getTableBlock() != this.tableBlock) {
                return ref;
            }
            if ("id".equals(resourceEntry.getType())) {
                return ref;
            }
            Entry entry = resourceEntry.get();
            if (entry == null) {
                return ref;
            }
            ResValue resValue = entry.getResValue();
            if (resValue == null) {
                return ref;
            }
            String decoded = resValue.decodeValue();
            if (decoded == null) {
                return ref;
            }
            if (decoded.length() > 100) {
                decoded = decoded.substring(0, 100) + " ...";
            }
            return ref + " '" + this.replaceNewLines(decoded) + "'";
        }

        private String replaceNewLines(String decoded) {
            StringBuilder builder = new StringBuilder();
            int length = decoded.length();
            for (int i = 0; i < length; ++i) {
                char ch = decoded.charAt(i);
                builder.append(this.escapeChar(ch));
            }
            return builder.toString();
        }

        private String escapeChar(char ch) {
            if (ch == '\n') {
                return "\\n";
            }
            if (ch == '\t') {
                return "\\t";
            }
            if (ch == '\r') {
                return "\\r";
            }
            return String.valueOf(ch);
        }
    }
}

