/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali;

import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.CollectionUtil;
import java.io.IOException;

public interface MethodComment {
    public void writeMethodComment(SmaliWriter var1, MethodKey var2) throws IOException;

    public static class MethodHierarchyComment
    implements MethodComment {
        private final DexClassRepository classRepository;

        public MethodHierarchyComment(DexClassRepository classRepository) {
            this.classRepository = classRepository;
        }

        @Override
        public void writeMethodComment(SmaliWriter writer, MethodKey methodKey) throws IOException {
            DexMethod dexMethod = this.classRepository.getDeclaredMethod(methodKey);
            if (dexMethod.isConstructor()) {
                return;
            }
            DexMethod superMethod = CollectionUtil.getFirst(dexMethod.getSuperMethods());
            if (superMethod == null) {
                return;
            }
            writer.newLine();
            writer.appendComment("@Override: ");
            writer.appendComment(superMethod.getKey().getDeclaring().getTypeName());
        }
    }
}

