/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Block;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.data.StringData;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.IdSection;
import com.reandroid.dex.sections.Marker;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.sections.StringIdArray;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Iterator;

public class StringIdSection
extends IdSection<StringId> {
    StringIdSection(IntegerPair countAndOffset, SectionType<StringId> sectionType) {
        super(sectionType, new StringIdArray(countAndOffset, sectionType.getCreator()));
    }

    public StringIdArray getItemArray() {
        return (StringIdArray)super.getItemArray();
    }

    @Override
    protected void onPreRefresh() {
        CollectionUtil.walk(Marker.parse(this));
        super.onPreRefresh();
    }

    @Override
    boolean keyChanged(Block block, Key key, boolean immediateSort) {
        char ch;
        String text;
        boolean changed = super.keyChanged(block, key, immediateSort);
        if (key instanceof StringKey && (text = ((StringKey)key).getString()).length() > 0 && ((ch = text.charAt(0)) == 'L' || ch == '[')) {
            this.updateTypeId(new TypeKey(text));
        }
        return changed;
    }

    private void updateTypeId(TypeKey typeKey) {
        SectionList sectionList = this.getSectionList();
        if (sectionList == null) {
            return;
        }
        TypeId typeId = sectionList.getSectionItem(SectionType.TYPE_ID, typeKey);
        if (typeId != null) {
            typeId.getKey();
        }
    }

    @Override
    void sortImmediate(StringId item) {
        StringData stringData = item.getStringData();
        stringData.getSection(SectionType.STRING_DATA).sortImmediate(stringData);
        super.sortImmediate(item);
    }

    private Iterator<StringKey> getAllStringKeys(Key key) {
        Iterator<? extends Key> iterator = key.mentionedKeys();
        return ComputeIterator.of(iterator, key1 -> {
            if (key1 instanceof StringKey) {
                return (StringKey)key1;
            }
            if (key1 instanceof TypeKey) {
                return new StringKey(((TypeKey)key1).getTypeName());
            }
            return null;
        });
    }
}

