/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.NumberIntegerReference;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.data.AnnotationGroup;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.data.EncodedArray;
import com.reandroid.dex.data.HiddenApiRestrictions;
import com.reandroid.dex.data.StringData;
import com.reandroid.dex.data.TypeList;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.dex.id.CallSiteId;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.MethodHandle;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.id.ProtoId;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.sections.AnnotationSetSection;
import com.reandroid.dex.sections.ClassIdSection;
import com.reandroid.dex.sections.DataSection;
import com.reandroid.dex.sections.IdSection;
import com.reandroid.dex.sections.MapList;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SpecialItem;
import com.reandroid.dex.sections.SpecialSection;
import com.reandroid.dex.sections.StringDataSection;
import com.reandroid.dex.sections.StringIdSection;
import com.reandroid.utils.collection.ArrayIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;

public class SectionType<T extends SectionItem> {
    public static final SectionType<?>[] VALUES = new SectionType[21];
    private static final SectionType<?>[] READ_ORDER;
    private static final SectionType<?>[] DATA_REMOVE_ORDER;
    public static final SectionType<?>[] ID_TYPES;
    private static final SectionType<?>[] R8_ORDER;
    private static final SectionType<?>[] DEX_LIB2_ORDER;
    private static final SectionType<?>[] SORT_SECTIONS_ORDER;
    public static final SectionType<DexHeader> HEADER;
    public static final SectionType<StringId> STRING_ID;
    public static final SectionType<TypeId> TYPE_ID;
    public static final SectionType<ProtoId> PROTO_ID;
    public static final SectionType<FieldId> FIELD_ID;
    public static final SectionType<MethodId> METHOD_ID;
    public static final SectionType<ClassId> CLASS_ID;
    public static final SectionType<CallSiteId> CALL_SITE_ID;
    public static final SectionType<MethodHandle> METHOD_HANDLE;
    public static final SectionType<TypeList> TYPE_LIST;
    public static final SectionType<AnnotationItem> ANNOTATION_ITEM;
    public static final SectionType<AnnotationSet> ANNOTATION_SET;
    public static final SectionType<AnnotationGroup> ANNOTATION_GROUP;
    public static final SectionType<AnnotationsDirectory> ANNOTATION_DIRECTORY;
    public static final SectionType<ClassData> CLASS_DATA;
    public static final SectionType<CodeItem> CODE;
    public static final SectionType<StringData> STRING_DATA;
    public static final SectionType<DebugInfo> DEBUG_INFO;
    public static final SectionType<EncodedArray> ENCODED_ARRAY;
    public static final SectionType<HiddenApiRestrictions> HIDDEN_API;
    public static final SectionType<MapList> MAP_LIST;
    private final String name;
    private final int type;
    private final Creator<T> creator;

    private SectionType(String name, int type, Creator<T> creator) {
        this.name = name;
        this.type = type;
        this.creator = creator;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isIdSection() {
        return false;
    }

    public boolean isDataSection() {
        return false;
    }

    public boolean isSpecialSection() {
        return false;
    }

    public Section<T> createSection(IntegerPair countAndOffset) {
        return null;
    }

    public Section<T> createSpecialSection(IntegerReference offset) {
        throw new RuntimeException("Not implemented for: " + this.getName());
    }

    public int getReferenceType() {
        return 7;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.type;
    }

    public String toString() {
        return this.getName();
    }

    public Creator<T> getCreator() {
        return this.creator;
    }

    public static <T1 extends SectionItem> SectionType<T1> get(int type) {
        for (SectionType<?> sectionType : VALUES) {
            if (type != sectionType.type) continue;
            return sectionType;
        }
        return null;
    }

    public static SectionType<? extends IdItem> getReferenceType(int reference) {
        switch (reference) {
            case 0: {
                return STRING_ID;
            }
            case 1: {
                return TYPE_ID;
            }
            case 2: {
                return FIELD_ID;
            }
            case 3: {
                return METHOD_ID;
            }
            case 4: {
                return PROTO_ID;
            }
            case 5: {
                return CALL_SITE_ID;
            }
            case 6: {
                return METHOD_HANDLE;
            }
        }
        return null;
    }

    public static Iterator<SectionType<?>> getIdSectionTypes() {
        return new ArrayIterator(ID_TYPES);
    }

    public static <T1> Comparator<T1> comparator(SectionType<?>[] sortOrder, Function<? super T1, SectionType<?>> function) {
        return new OrderBasedComparator<T1>(sortOrder, function);
    }

    public static SectionType<?>[] getR8Order() {
        return (SectionType[])R8_ORDER.clone();
    }

    public static SectionType<?>[] getDexLib2Order() {
        return (SectionType[])DEX_LIB2_ORDER.clone();
    }

    public static SectionType<?>[] getReadOrderList() {
        return (SectionType[])READ_ORDER.clone();
    }

    public static SectionType<?>[] getRemoveOrderList() {
        return (SectionType[])DATA_REMOVE_ORDER.clone();
    }

    public static SectionType<?>[] getSortSectionsOrder() {
        return (SectionType[])SORT_SECTIONS_ORDER.clone();
    }

    static {
        int index = 0;
        HEADER = new SpecialSectionType<DexHeader>("HEADER", 0, new Creator<DexHeader>(){

            public DexHeader[] newArrayInstance(int length) {
                return new DexHeader[length];
            }

            @Override
            public DexHeader newInstance() {
                return new DexHeader();
            }
        });
        SectionType.VALUES[index++] = HEADER;
        MAP_LIST = new SpecialSectionType<MapList>("MAP_LIST", 4096, new Creator<MapList>(){

            public MapList[] newArrayInstance(int length) {
                return new MapList[length];
            }

            @Override
            public MapList newInstance() {
                return new MapList(new NumberIntegerReference());
            }
        });
        SectionType.VALUES[index++] = MAP_LIST;
        STRING_ID = new StringIdSectionType("STRING_ID", 1, index, 0, new Creator<StringId>(){

            public StringId[] newArrayInstance(int length) {
                return new StringId[length];
            }

            @Override
            public StringId newInstance() {
                return new StringId();
            }
        });
        SectionType.VALUES[index++] = STRING_ID;
        STRING_DATA = new StringDataSectionType("STRING_DATA", 8194, new Creator<StringData>(){

            public StringData[] newArrayInstance(int length) {
                return new StringData[length];
            }

            @Override
            public StringData newInstance() {
                return new StringData();
            }
        });
        SectionType.VALUES[index++] = STRING_DATA;
        TYPE_ID = new IdSectionType<TypeId>("TYPE_ID", 2, 1, new Creator<TypeId>(){

            public TypeId[] newArrayInstance(int length) {
                return new TypeId[length];
            }

            @Override
            public TypeId newInstance() {
                return new TypeId();
            }
        });
        SectionType.VALUES[index++] = TYPE_ID;
        TYPE_LIST = new DataSectionType<TypeList>("TYPE_LIST", 4097, new Creator<TypeList>(){

            public TypeList[] newArrayInstance(int length) {
                return new TypeList[length];
            }

            @Override
            public TypeList newInstance() {
                return new TypeList();
            }
        });
        SectionType.VALUES[index++] = TYPE_LIST;
        PROTO_ID = new IdSectionType<ProtoId>("PROTO_ID", 3, 4, new Creator<ProtoId>(){

            public ProtoId[] newArrayInstance(int length) {
                return new ProtoId[length];
            }

            @Override
            public ProtoId newInstance() {
                return new ProtoId();
            }
        });
        SectionType.VALUES[index++] = PROTO_ID;
        FIELD_ID = new IdSectionType<FieldId>("FIELD_ID", 4, 2, new Creator<FieldId>(){

            public FieldId[] newArrayInstance(int length) {
                return new FieldId[length];
            }

            @Override
            public FieldId newInstance() {
                return new FieldId();
            }
        });
        SectionType.VALUES[index++] = FIELD_ID;
        METHOD_ID = new IdSectionType<MethodId>("METHOD_ID", 5, 3, new Creator<MethodId>(){

            public MethodId[] newArrayInstance(int length) {
                return new MethodId[length];
            }

            @Override
            public MethodId newInstance() {
                return new MethodId();
            }
        });
        SectionType.VALUES[index++] = METHOD_ID;
        ANNOTATION_ITEM = new DataSectionType<AnnotationItem>("ANNOTATION_ITEM", 8196, new Creator<AnnotationItem>(){

            public AnnotationItem[] newArrayInstance(int length) {
                return new AnnotationItem[length];
            }

            @Override
            public AnnotationItem newInstance() {
                return new AnnotationItem();
            }
        });
        SectionType.VALUES[index++] = ANNOTATION_ITEM;
        ANNOTATION_SET = new AnnotationSetSectionType("ANNOTATION_SET", 4099, new Creator<AnnotationSet>(){

            public AnnotationSet[] newArrayInstance(int length) {
                return new AnnotationSet[length];
            }

            @Override
            public AnnotationSet newInstance() {
                return new AnnotationSet();
            }
        });
        SectionType.VALUES[index++] = ANNOTATION_SET;
        ANNOTATION_GROUP = new DataSectionType<AnnotationGroup>("ANNOTATION_GROUP", 4098, new Creator<AnnotationGroup>(){

            public AnnotationGroup[] newArrayInstance(int length) {
                return new AnnotationGroup[length];
            }

            @Override
            public AnnotationGroup newInstance() {
                return new AnnotationGroup();
            }
        });
        SectionType.VALUES[index++] = ANNOTATION_GROUP;
        ANNOTATION_DIRECTORY = new DataSectionType<AnnotationsDirectory>("ANNOTATIONS_DIRECTORY", 8198, new Creator<AnnotationsDirectory>(){

            public AnnotationsDirectory[] newArrayInstance(int length) {
                return new AnnotationsDirectory[length];
            }

            @Override
            public AnnotationsDirectory newInstance() {
                return new AnnotationsDirectory();
            }
        });
        SectionType.VALUES[index++] = ANNOTATION_DIRECTORY;
        CALL_SITE_ID = new IdSectionType<CallSiteId>("CALL_SITE_ID", 7, 5, new Creator<CallSiteId>(){

            public CallSiteId[] newArrayInstance(int length) {
                return new CallSiteId[length];
            }

            @Override
            public CallSiteId newInstance() {
                return new CallSiteId();
            }
        });
        SectionType.VALUES[index++] = CALL_SITE_ID;
        METHOD_HANDLE = new IdSectionType<MethodHandle>("METHOD_HANDLE", 8, 6, new Creator<MethodHandle>(){

            public MethodHandle[] newArrayInstance(int length) {
                return new MethodHandle[length];
            }

            @Override
            public MethodHandle newInstance() {
                return new MethodHandle();
            }
        });
        SectionType.VALUES[index++] = METHOD_HANDLE;
        DEBUG_INFO = new DataSectionType<DebugInfo>("DEBUG_INFO", 8195, new Creator<DebugInfo>(){

            public DebugInfo[] newArrayInstance(int length) {
                return new DebugInfo[length];
            }

            @Override
            public DebugInfo newInstance() {
                return new DebugInfo();
            }
        });
        SectionType.VALUES[index++] = DEBUG_INFO;
        CODE = new DataSectionType<CodeItem>("CODE", 8193, new Creator<CodeItem>(){

            public CodeItem[] newArrayInstance(int length) {
                return new CodeItem[length];
            }

            @Override
            public CodeItem newInstance() {
                return new CodeItem();
            }
        });
        SectionType.VALUES[index++] = CODE;
        ENCODED_ARRAY = new DataSectionType<EncodedArray>("ENCODED_ARRAY", 8197, new Creator<EncodedArray>(){

            public EncodedArray[] newArrayInstance(int length) {
                return new EncodedArray[length];
            }

            @Override
            public EncodedArray newInstance() {
                return new EncodedArray();
            }
        });
        SectionType.VALUES[index++] = ENCODED_ARRAY;
        CLASS_DATA = new DataSectionType<ClassData>("CLASS_DATA", 8192, new Creator<ClassData>(){

            public ClassData[] newArrayInstance(int length) {
                return new ClassData[length];
            }

            @Override
            public ClassData newInstance() {
                return new ClassData();
            }
        });
        SectionType.VALUES[index++] = CLASS_DATA;
        CLASS_ID = new IdSectionType<ClassId>("CLASS_ID", 6, 7, new Creator<ClassId>(){

            public ClassId[] newArrayInstance(int length) {
                return new ClassId[length];
            }

            @Override
            public ClassId newInstance() {
                return new ClassId();
            }
        });
        SectionType.VALUES[index++] = CLASS_ID;
        HIDDEN_API = new DataSectionType<HiddenApiRestrictions>("HIDDEN_API", 61440, new Creator<HiddenApiRestrictions>(){

            public HiddenApiRestrictions[] newArrayInstance(int length) {
                return new HiddenApiRestrictions[length];
            }

            @Override
            public HiddenApiRestrictions newInstance() {
                return new HiddenApiRestrictions();
            }
        });
        SectionType.VALUES[index] = HIDDEN_API;
        READ_ORDER = new SectionType[]{HEADER, MAP_LIST, STRING_ID, STRING_DATA, TYPE_ID, TYPE_LIST, PROTO_ID, FIELD_ID, METHOD_ID, METHOD_HANDLE, ANNOTATION_ITEM, ANNOTATION_SET, ANNOTATION_GROUP, ANNOTATION_DIRECTORY, ENCODED_ARRAY, CALL_SITE_ID, DEBUG_INFO, CODE, CLASS_DATA, CLASS_ID, HIDDEN_API};
        DATA_REMOVE_ORDER = new SectionType[]{CLASS_DATA, CODE, DEBUG_INFO, ANNOTATION_DIRECTORY, ANNOTATION_GROUP, ANNOTATION_SET, ANNOTATION_ITEM, ENCODED_ARRAY, METHOD_ID, FIELD_ID, PROTO_ID, TYPE_LIST, TYPE_ID, STRING_ID};
        ID_TYPES = new SectionType[]{STRING_ID, TYPE_ID, PROTO_ID, FIELD_ID, METHOD_ID, CLASS_ID, CALL_SITE_ID, METHOD_HANDLE};
        R8_ORDER = new SectionType[]{HEADER, STRING_ID, TYPE_ID, PROTO_ID, FIELD_ID, METHOD_ID, CLASS_ID, CALL_SITE_ID, METHOD_HANDLE, CODE, DEBUG_INFO, TYPE_LIST, STRING_DATA, ANNOTATION_ITEM, CLASS_DATA, ENCODED_ARRAY, ANNOTATION_SET, ANNOTATION_GROUP, ANNOTATION_DIRECTORY, MAP_LIST};
        SORT_SECTIONS_ORDER = new SectionType[]{STRING_DATA, STRING_ID, TYPE_ID, TYPE_LIST, PROTO_ID, FIELD_ID, METHOD_ID, METHOD_HANDLE, ANNOTATION_ITEM, ANNOTATION_SET, ANNOTATION_GROUP, ANNOTATION_DIRECTORY, ENCODED_ARRAY, CALL_SITE_ID, DEBUG_INFO, CODE, CLASS_DATA, CLASS_ID, HIDDEN_API, MAP_LIST, HEADER};
        DEX_LIB2_ORDER = new SectionType[]{HEADER, STRING_ID, TYPE_ID, PROTO_ID, FIELD_ID, METHOD_ID, CLASS_ID, STRING_DATA, TYPE_LIST, ENCODED_ARRAY, ANNOTATION_ITEM, ANNOTATION_SET, ANNOTATION_GROUP, ANNOTATION_DIRECTORY, DEBUG_INFO, CODE, CLASS_DATA, MAP_LIST};
    }

    static class OrderBasedComparator<T1>
    implements Comparator<T1> {
        private final Function<? super T1, SectionType<?>> function;
        private final SectionType<?>[] sortOrder;

        public OrderBasedComparator(SectionType<?>[] sortOrder, Function<? super T1, SectionType<?>> function) {
            this.sortOrder = sortOrder;
            this.function = function;
        }

        private int getOrder(SectionType<?> sectionType) {
            SectionType<?>[] sortOrder = this.sortOrder;
            int length = sortOrder.length;
            for (int i = 0; i < length; ++i) {
                if (sortOrder[i] != sectionType) continue;
                return i;
            }
            return length - 2;
        }

        private int getOrder(T1 item) {
            if (item == null) {
                return this.sortOrder.length - 1;
            }
            return this.getOrder((T1)this.function.apply(item));
        }

        @Override
        public int compare(T1 item1, T1 item2) {
            return Integer.compare(this.getOrder(item1), this.getOrder(item2));
        }
    }

    private static class AnnotationSetSectionType
    extends DataSectionType<AnnotationSet> {
        AnnotationSetSectionType(String name, int type, Creator<AnnotationSet> creator) {
            super(name, type, creator);
        }

        public AnnotationSetSection createSection(IntegerPair countAndOffset) {
            return new AnnotationSetSection(countAndOffset, this);
        }
    }

    private static class StringDataSectionType
    extends DataSectionType<StringData> {
        StringDataSectionType(String name, int type, Creator<StringData> creator) {
            super(name, type, creator);
        }

        public StringDataSection createSection(IntegerPair countAndOffset) {
            return new StringDataSection(countAndOffset, this);
        }
    }

    private static class DataSectionType<T1 extends DataItem>
    extends SectionType<T1> {
        DataSectionType(String name, int type, Creator<T1> creator) {
            super(name, type, creator);
        }

        @Override
        public boolean isDataSection() {
            return true;
        }

        @Override
        public Section<T1> createSection(IntegerPair countAndOffset) {
            return new DataSection(countAndOffset, this);
        }
    }

    private static class StringIdSectionType
    extends IdSectionType<StringId> {
        StringIdSectionType(String name, int type, int readOrder, int referenceType, Creator<StringId> creator) {
            super(name, type, referenceType, creator);
        }

        public StringIdSection createSection(IntegerPair countAndOffset) {
            return new StringIdSection(countAndOffset, this);
        }
    }

    private static class IdSectionType<T1 extends IdItem>
    extends SectionType<T1> {
        private final int referenceType;

        private IdSectionType(String name, int type, int referenceType, Creator<T1> creator) {
            super(name, type, creator);
            this.referenceType = referenceType;
        }

        @Override
        public boolean isIdSection() {
            return true;
        }

        @Override
        public Section<T1> createSection(IntegerPair countAndOffset) {
            if (this == CLASS_ID) {
                return new ClassIdSection(countAndOffset);
            }
            return new IdSection(countAndOffset, this);
        }

        @Override
        public int getReferenceType() {
            return this.referenceType;
        }
    }

    private static class SpecialSectionType<T1 extends SpecialItem>
    extends SectionType<T1> {
        SpecialSectionType(String name, int type, Creator<T1> creator) {
            super(name, type, creator);
        }

        @Override
        public boolean isSpecialSection() {
            return true;
        }

        @Override
        public Section<T1> createSection(IntegerPair countAndOffset) {
            return new SpecialSection(countAndOffset, this);
        }

        @Override
        public SpecialSection<T1> createSpecialSection(IntegerReference offset) {
            return new SpecialSection(offset, this);
        }
    }
}

