/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.NumberIntegerReference;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.StringData;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.sections.DataSection;
import com.reandroid.dex.sections.DexLayout;
import com.reandroid.dex.sections.IdSection;
import com.reandroid.dex.sections.MapItem;
import com.reandroid.dex.sections.MapList;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionArray;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ArraySupplierIterator;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class SectionList
extends FixedBlockContainer
implements SectionTool,
OffsetSupplier,
Iterable<Section<?>>,
ArraySupplier<Section<?>>,
FullRefresh {
    private final IntegerReference baseOffset = new NumberIntegerReference();
    private final DexHeader dexHeader;
    private final Section<DexHeader> dexHeaderSection;
    private final BlockList<IdSection<?>> idSectionList = new BlockList();
    private final BlockList<DataSection<?>> dataSectionList = new BlockList();
    private final Section<MapList> mapListSection;
    private final Map<SectionType<?>, Section<?>> typeMap;
    private final MapList mapList;
    private boolean immediateIdSort;
    private boolean mReading;

    public SectionList() {
        super(4);
        Section<DexHeader> dexHeaderSection = SectionType.HEADER.createSpecialSection(this.baseOffset);
        DexHeader dexHeader = new DexHeader(this.baseOffset);
        dexHeaderSection.add(dexHeader);
        this.dexHeaderSection = dexHeaderSection;
        Section<MapList> mapListSection = SectionType.MAP_LIST.createSpecialSection(dexHeader.map);
        MapList mapList = new MapList(dexHeader.map);
        mapListSection.add(mapList);
        this.mapListSection = mapListSection;
        this.typeMap = new HashMap();
        this.addChild(0, dexHeaderSection);
        this.addChild(1, this.idSectionList);
        this.addChild(2, this.dataSectionList);
        this.addChild(3, mapListSection);
        this.dexHeader = dexHeader;
        this.mapList = mapList;
        this.typeMap.put(SectionType.HEADER, dexHeaderSection);
        this.typeMap.put(SectionType.MAP_LIST, mapListSection);
    }

    public int shrink() {
        int count;
        int result = 0;
        while ((count = this.clearUnused()) != 0) {
            result += count;
        }
        while ((count = this.clearDuplicateData()) != 0) {
            result += count;
            result += this.clearUnused();
        }
        return result += this.clearEmptySections();
    }

    public int clearDuplicateData() {
        SectionType<?>[] remove;
        this.refresh();
        int result = 0;
        for (SectionType<?> sectionType : remove = SectionType.getRemoveOrderList()) {
            Section<?> section = this.getSection(sectionType);
            if (section == null) continue;
            int count = section.getPool().clearDuplicates();
            result += count;
            if (count == 0) continue;
            section.refresh();
        }
        if (result != 0) {
            this.refresh();
        }
        return result;
    }

    public int clearUnused() {
        this.clearUsageTypes();
        this.refresh();
        int result = 0;
        Iterator<Section<?>> iterator = this.getSections();
        while (iterator.hasNext()) {
            result += iterator.next().clearUnused();
        }
        return result;
    }

    public int clearEmptySections() {
        int result = 0;
        List<Section<?>> sections = CollectionUtil.toList(this.getSections());
        for (Section<?> section : sections) {
            if (!section.removeIfEmpty()) continue;
            ++result;
        }
        return result;
    }

    private void clearUsageTypes() {
        Iterator<Section<?>> iterator = this.getSections();
        while (iterator.hasNext()) {
            iterator.next().clearUsageTypes();
        }
    }

    public void updateHeader() {
        Block parent = this.getParentInstance(DexLayout.class);
        if (parent == null) {
            parent = this;
        }
        this.dexHeader.updateHeaderInternal(parent);
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.mapList.refresh();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.readSections(reader, null);
    }

    void readSections(BlockReader reader, Predicate<SectionType<?>> filter) throws IOException {
        this.mReading = true;
        this.readSpecialSections(reader);
        this.readBody(reader, filter);
        this.mReading = false;
    }

    private void readSpecialSections(BlockReader reader) throws IOException {
        this.getSection(SectionType.HEADER).readBytes(reader);
        this.getSection(SectionType.MAP_LIST).readBytes(reader);
    }

    private void readBody(BlockReader reader, Predicate<SectionType<?>> filter) throws IOException {
        for (MapItem mapItem : this.mapList.getReadSorted()) {
            if (mapItem == null || filter != null && !filter.test(mapItem.getSectionType())) continue;
            this.loadSection(mapItem, reader);
        }
        this.idSectionList.trimToSize();
        this.dataSectionList.trimToSize();
        this.idSectionList.sort(SectionList.getOffsetComparator());
        this.dataSectionList.sort(SectionList.getOffsetComparator());
        this.mapList.linkHeader(this.dexHeader);
    }

    private void loadSection(MapItem mapItem, BlockReader reader) throws IOException {
        if (mapItem == null) {
            return;
        }
        SectionType sectionType = mapItem.getSectionType();
        if (this.typeMap.containsKey(sectionType)) {
            return;
        }
        Section section = mapItem.createNewSection();
        if (section == null) {
            return;
        }
        this.add(section);
        section.readBytes(reader);
    }

    @Override
    public boolean isReading() {
        return this.mReading;
    }

    public <T1 extends SectionItem> Section<T1> add(Section<T1> section) {
        if (section instanceof IdSection) {
            this.idSectionList.add((IdSection)section);
        } else {
            this.dataSectionList.add((DataSection)section);
        }
        this.typeMap.put(section.getSectionType(), section);
        return section;
    }

    public DexHeader getHeader() {
        return this.dexHeader;
    }

    public MapList getMapList() {
        return this.mapList;
    }

    public void remove(Section<?> section) {
        if (section == null) {
            return;
        }
        SectionType<?> sectionType = section.getSectionType();
        if (this.typeMap.remove(sectionType) != section) {
            return;
        }
        section.onRemove(this);
        if (sectionType.isDataSection()) {
            this.dataSectionList.remove((DataSection)section);
        } else if (sectionType.isIdSection()) {
            this.idSectionList.remove((IdSection)section);
        }
    }

    public void clear() {
        Iterator<Section<?>> iterator = this.getSections();
        while (iterator.hasNext()) {
            Section<?> section = iterator.next();
            section.onRemove(this);
        }
        this.idSectionList.clearChildes();
        this.dataSectionList.clearChildes();
        this.typeMap.clear();
    }

    public void clearPool(SectionType<?> sectionType) {
        Section<?> section = this.getSection(sectionType);
        if (section != null) {
            section.clearPool();
        }
    }

    public void clearPools() {
        for (Section<?> section : this) {
            section.clearPool();
        }
    }

    public void sortSection(SectionType<?>[] order) {
        this.idSectionList.sort(SectionType.comparator(order, Section::getSectionType));
        this.dataSectionList.sort(SectionType.comparator(order, Section::getSectionType));
        this.mapList.sortMapItems(order);
    }

    @Override
    public void refreshFull() {
        SectionType<?>[] sortOrder;
        for (SectionType<?> sectionType : sortOrder = SectionType.getSortSectionsOrder()) {
            Section<?> section = this.getSection(sectionType);
            if (section == null) continue;
            section.refreshFull();
        }
        this.clearUnused();
        this.clearDuplicateData();
    }

    public boolean sortStrings() {
        boolean result = false;
        Section<StringData> stringDataSection = this.getSection(SectionType.STRING_DATA);
        if (stringDataSection != null) {
            result = stringDataSection.sort();
        }
        if (this.sortItems(SectionType.STRING_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.TYPE_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.PROTO_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.FIELD_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.METHOD_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.CLASS_ID)) {
            result = true;
        }
        return result;
    }

    private boolean sortItems(SectionType<?> sectionType) {
        Section<?> section = this.getSection(sectionType);
        if (section != null) {
            return section.sort();
        }
        return false;
    }

    public <T1 extends SectionItem> T1 getLoaded(SectionType<T1> sectionType, Key key) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section.getSectionItem(key);
        }
        return null;
    }

    @Override
    public <T1 extends SectionItem> Section<T1> getSection(SectionType<T1> sectionType) {
        return this.typeMap.get(sectionType);
    }

    @Override
    public SectionList getSectionList() {
        return this;
    }

    @Override
    public <T1 extends SectionItem> Section<T1> getOrCreateSection(SectionType<T1> sectionType) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section;
        }
        if (sectionType == SectionType.MAP_LIST || sectionType == SectionType.HEADER) {
            return null;
        }
        MapList mapList = this.getMapList();
        MapItem mapItem = mapList.getOrCreate(sectionType);
        section = mapItem.createNewSection();
        this.add(section);
        this.sortSection(SectionType.getR8Order());
        mapItem.link(this.getHeader());
        return section;
    }

    public int indexOf(Section<?> section) {
        if (section == this.dexHeaderSection) {
            return 0;
        }
        if (section == this.mapListSection) {
            return this.getCount() - 1;
        }
        if (section == this.idSectionList.get(section.getIndex())) {
            return 1 + section.getIndex();
        }
        if (section == this.dataSectionList.get(section.getIndex())) {
            return 1 + this.idSectionList.size() + section.getIndex();
        }
        return -1;
    }

    @Override
    public Section<?> get(int i) {
        if (i == 0) {
            return this.dexHeaderSection;
        }
        if (i == this.getCount() - 1) {
            return this.mapListSection;
        }
        if (i <= this.idSectionList.size()) {
            return this.idSectionList.get(i - 1);
        }
        return this.dataSectionList.get(i - 1 - this.idSectionList.size());
    }

    public boolean contains(Key key) {
        if (key == null) {
            return false;
        }
        if (key instanceof StringKey) {
            return this.contains(SectionType.STRING_ID, key);
        }
        if (key instanceof TypeKey) {
            return this.contains(SectionType.TYPE_ID, key);
        }
        if (key instanceof FieldKey) {
            return this.contains(SectionType.FIELD_ID, key);
        }
        if (key instanceof ProtoKey) {
            return this.contains(SectionType.PROTO_ID, key);
        }
        if (key instanceof MethodKey) {
            return this.contains(SectionType.METHOD_ID, key);
        }
        if (key instanceof TypeListKey) {
            return this.contains(SectionType.TYPE_LIST, key);
        }
        throw new IllegalArgumentException("Unknown key type: " + key.getClass() + ", '" + key + "'");
    }

    private boolean contains(SectionType<?> sectionType, Key key) {
        Section<?> section = this.getSection(sectionType);
        if (section != null) {
            return section.contains(key);
        }
        return false;
    }

    public boolean isImmediateIdSort() {
        return this.immediateIdSort;
    }

    public void setImmediateIdSort(boolean immediateIdSort) {
        this.immediateIdSort = immediateIdSort;
    }

    public void keyChanged(Block item, SectionType<?> sectionType, Key oldKey) {
        ClassId classId;
        Section<?> section = this.getSection(sectionType);
        if (section == null) {
            return;
        }
        section.keyChanged(item, oldKey, this.isImmediateIdSort());
        if (sectionType == SectionType.TYPE_ID && (classId = this.getLoaded(SectionType.CLASS_ID, oldKey)) != null) {
            classId.getKey();
        }
    }

    public Iterator<Section<?>> getSections() {
        return new CombiningIterator(this.getIdSections(), this.getDataSections());
    }

    public Iterator<IdSection<?>> getIdSections() {
        return this.idSectionList.iterator();
    }

    public Iterator<DataSection<?>> getDataSections() {
        return this.dataSectionList.iterator();
    }

    @Override
    public int getCount() {
        return 2 + this.idSectionList.size() + this.dataSectionList.size();
    }

    @Override
    public Iterator<Section<?>> iterator() {
        return ArraySupplierIterator.of(this);
    }

    @Override
    public IntegerReference getOffsetReference() {
        return this.baseOffset;
    }

    private boolean canAdd(Collection<IdItem> usedIds) {
        Iterator<IdSection<?>> idSections = this.getIdSections();
        while (idSections.hasNext()) {
            IdSection<?> section = idSections.next();
            if (section.canAdd(usedIds)) continue;
            return false;
        }
        return true;
    }

    public boolean merge(MergeOptions options, ClassId classId) {
        if (classId == null) {
            options.onMergeError(this.getParentInstance(DexLayout.class), classId, "Null class id");
            return false;
        }
        if (classId.getParent() == null) {
            options.onMergeError(this.getParentInstance(DexLayout.class), classId, "Destroyed class id");
            return false;
        }
        if (classId.getParent(SectionList.class) == this) {
            options.onMergeError(this.getParentInstance(DexLayout.class), classId, "Class id is on same section");
            return false;
        }
        if (options.skipMerging(classId, classId.getKey())) {
            return false;
        }
        if (this.contains(SectionType.CLASS_ID, classId.getKey())) {
            options.onDuplicate(classId);
            return false;
        }
        ArrayCollection<IdItem> collection = classId.listUsedIds();
        if (!this.canAdd(collection)) {
            options.onDexFull(this.getParentInstance(DexLayout.class), classId);
            return false;
        }
        Section<ClassId> mySection = this.getOrCreateSection(SectionType.CLASS_ID);
        ClassId myClass = mySection.getOrCreate(classId.getKey());
        myClass.merge(classId);
        if (options.relocateClass()) {
            classId.removeSelf();
        }
        options.onMergeSuccess(classId, classId.getKey());
        return true;
    }

    public boolean merge(MergeOptions options, SectionList sectionList) {
        int size;
        if (sectionList == this) {
            options.onMergeError(this.getParentInstance(DexLayout.class), sectionList, "Can not merge with self");
            return false;
        }
        if (sectionList.getParent() == null) {
            options.onMergeError(this.getParentInstance(DexLayout.class), sectionList, "Destroyed section list");
            return false;
        }
        Section<ClassId> comingSection = sectionList.getSection(SectionType.CLASS_ID);
        if (comingSection == null || comingSection.getCount() == 0) {
            return false;
        }
        boolean mergedOnce = false;
        boolean mergedAll = true;
        Section<ClassId> mySection = this.getOrCreateSection(SectionType.CLASS_ID);
        SectionArray<ClassId> comingArray = comingSection.getItemArray();
        for (int i = size = comingArray.size() - 1; i >= 0; --i) {
            TypeKey key;
            ClassId coming = (ClassId)comingArray.get(i);
            if (options.skipMerging(coming, key = coming.getKey())) continue;
            if (mySection.contains(key)) {
                options.onDuplicate(coming);
                continue;
            }
            ArrayCollection<IdItem> collection = coming.listUsedIds();
            if (!this.canAdd(collection)) {
                mergedAll = false;
                options.onDexFull(this.getParentInstance(DexLayout.class), coming);
                break;
            }
            ClassId classId = mySection.getOrCreate(coming.getKey());
            classId.merge(coming);
            options.onMergeSuccess(coming, key);
            if (options.relocateClass()) {
                coming.removeSelf();
            }
            mergedOnce = true;
        }
        if (comingSection.getCount() == 0) {
            SectionList comingSectionSectionList = comingSection.getSectionList();
            DexLayout dexLayout = comingSectionSectionList.getParentInstance(DexLayout.class);
            dexLayout.clear();
        }
        if (mergedOnce) {
            this.refresh();
            this.sortStrings();
            this.refresh();
        }
        return mergedAll;
    }

    public void fromSmali(SmaliClass smaliClass) throws IOException {
        ClassId classId = this.getOrCreateSectionItem(SectionType.CLASS_ID, smaliClass.getKey());
        classId.fromSmali(smaliClass);
    }

    private static <T1 extends Section<?>> Comparator<T1> getOffsetComparator() {
        return (section1, section2) -> {
            if (section1 == section2) {
                return 0;
            }
            if (section1 == null) {
                return 1;
            }
            return section1.compareOffset((Section<?>)section2);
        };
    }
}

