/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.item.AlignItem;
import com.reandroid.dex.base.BlockListArray;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.base.PositionAlignedItem;
import com.reandroid.dex.base.PositionedItem;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.sections.Section;
import java.util.Iterator;

public class SectionArray<T extends SectionItem>
extends BlockListArray<T>
implements FullRefresh {
    public SectionArray(IntegerPair countAndOffset, Creator<T> creator) {
        super(countAndOffset, creator);
    }

    @Override
    public void refreshFull() {
        if (!(this.getFirst() instanceof FullRefresh)) {
            return;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FullRefresh refreshFull = (FullRefresh)iterator.next();
            refreshFull.refreshFull();
        }
    }

    int updatePositionedItemOffsets(int position) {
        int count = this.getCount();
        this.getCountAndOffset().getFirst().set(count);
        if (!(this.getFirst() instanceof PositionedItem)) {
            return position;
        }
        AlignItem previous = null;
        for (int i = 0; i < count; ++i) {
            SectionItem item = (SectionItem)this.get(i);
            if (item == null) {
                previous = null;
                continue;
            }
            DexPositionAlign itemAlign = null;
            if (item instanceof PositionAlignedItem) {
                itemAlign = ((PositionAlignedItem)((Object)item)).getPositionAlign();
                if (itemAlign != null) {
                    itemAlign.setSize(0);
                }
                if (previous != null) {
                    previous.align(position);
                    position += previous.size();
                }
            }
            if (i == count - 1) {
                ((PositionedItem)((Object)item)).removeLastAlign();
            }
            ((PositionedItem)((Object)item)).setPosition(position);
            position += item.countBytes();
            previous = itemAlign;
        }
        return position;
    }

    @Override
    public void onPreRemove(T item) {
        super.onPreRemove(item);
        this.notifyBeforeRemoved(item);
    }

    private void notifyBeforeRemoved(T item) {
        Section<T> section = this.getParentSection();
        if (section != null) {
            section.onRemoving(item);
        }
    }

    Section<T> getParentSection() {
        return this.getParentInstance(Section.class);
    }

    public void clear() {
        this.clearChildes();
        this.destroy();
    }
}

