/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.DexArraySupplier;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.FixedDexContainer;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.base.PositionAlignedItem;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.SectionArray;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public class Section<T extends SectionItem>
extends FixedDexContainer
implements DexArraySupplier<T>,
OffsetSupplier,
Iterable<T>,
FullRefresh {
    private final SectionType<T> sectionType;
    private final DexPositionAlign sectionAlign;
    private final SectionArray<T> itemArray;
    private DexSectionPool<T> dexSectionPool;

    Section(SectionType<T> sectionType, SectionArray<T> itemArray) {
        super(2);
        this.sectionType = sectionType;
        this.itemArray = itemArray;
        this.sectionAlign = new DexPositionAlign();
        this.addChild(0, this.sectionAlign);
        this.addChild(1, itemArray);
    }

    public Section(IntegerPair countAndOffset, SectionType<T> sectionType) {
        this(sectionType, new SectionArray<T>(countAndOffset, sectionType.getCreator()));
    }

    public Iterator<T> getWithUsage(int usage) {
        return this.iterator(item -> item.containsUsage(usage));
    }

    @Override
    public void refreshFull() {
        this.clearPool();
        SectionArray<T> array = this.getItemArray();
        array.refreshFull();
        this.sort();
        this.refresh();
    }

    int clearUnused() {
        return this.removeEntries(item -> item.getUsageType() == UsageMarker.USAGE_NONE);
    }

    public boolean remove(Key key) {
        return false;
    }

    public Iterator<Key> removeWithKeys(Predicate<Key> filter) {
        return EmptyIterator.of();
    }

    public int removeEntries(Predicate<? super T> filter) {
        return this.getItemArray().remove(filter);
    }

    void clearUsageTypes() {
        UsageMarker.clearUsageTypes(this.iterator());
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public boolean removeIfEmpty() {
        if (this.isEmpty()) {
            this.removeSelf();
            return true;
        }
        return false;
    }

    public void removeSelf() {
        SectionList sectionList = this.getSectionList();
        if (sectionList != null) {
            sectionList.remove(this);
        }
    }

    void onRemove(SectionList sectionList) {
        this.clear();
        sectionList.getMapList().remove(this.getSectionType());
        this.setParent(null);
        this.setIndex(-1);
    }

    public void clear() {
        this.clearPool();
        this.getItemArray().clear();
    }

    public void clearPool() {
        DexSectionPool<T> dexSectionPool = this.getLoadedPool();
        if (dexSectionPool != null) {
            dexSectionPool.clear();
            this.dexSectionPool = null;
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.sectionAlign.setAlignment(0);
        super.onReadBytes(reader);
    }

    public boolean contains(Key key) {
        return this.getPool().contains(key);
    }

    public Iterator<T> getAll(Key key) {
        return this.getPool().getAll(key);
    }

    public T getSectionItem(Key key) {
        return this.getPool().get(key);
    }

    public T getLoaded(Key key) {
        DexSectionPool<T> pool = this.getLoadedPool();
        if (pool != null) {
            return pool.get(key);
        }
        return null;
    }

    boolean keyChanged(Block block, Key key, boolean immediateIdSort) {
        DexSectionPool<T> dexSectionPool = this.getLoadedPool();
        if (dexSectionPool != null) {
            return dexSectionPool.update(key);
        }
        return false;
    }

    void sortImmediate(T item) {
        SectionArray<T> array = this.getItemArray();
        array.sortSingle(item, CompareUtil.getComparatorUnchecked());
    }

    public DexSectionPool<T> getPool() {
        DexSectionPool<T> dexSectionPool = this.dexSectionPool;
        if (dexSectionPool == null) {
            dexSectionPool = this.createPool();
            this.dexSectionPool = dexSectionPool;
            dexSectionPool.load();
        }
        return dexSectionPool;
    }

    public DexSectionPool<T> getLoadedPool() {
        return this.dexSectionPool;
    }

    DexSectionPool<T> createPool() {
        return new DexSectionPool(this);
    }

    public void add(T item) {
        this.getItemArray().add(item);
    }

    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    public T getSectionItem(int idx) {
        return null;
    }

    public T[] getSectionItems(int[] indexes) {
        return null;
    }

    public T getOrCreate(Key key) {
        return this.getPool().getOrCreate(key);
    }

    public T createItem() {
        return (T)((SectionItem)this.getItemArray().createNext());
    }

    public T get(Key key) {
        return this.getPool().get(key);
    }

    @Override
    public T get(int i) {
        return (T)((SectionItem)this.getItemArray().get(i));
    }

    @Override
    public int getCount() {
        return this.getItemArray().getCount();
    }

    public int getOffset() {
        return this.getOffsetReference().get();
    }

    @Override
    public IntegerReference getOffsetReference() {
        return this.getItemArray().getOffsetReference();
    }

    public SectionArray<T> getItemArray() {
        return this.itemArray;
    }

    public boolean sort() throws ClassCastException {
        Object first = this.getItemArray().getFirst();
        if (!(first instanceof Comparable)) {
            return false;
        }
        return this.sort(CompareUtil.getComparatorUnchecked());
    }

    public boolean sort(Comparator<? super T> comparator) {
        return this.getItemArray().sort(comparator);
    }

    public Iterator<T> clonedIterator() {
        return this.getItemArray().clonedIterator();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getItemArray().iterator();
    }

    public Iterator<T> iterator(Predicate<? super T> filter) {
        return this.getItemArray().iterator(filter);
    }

    public Iterator<T> arrayIterator() {
        return this.getItemArray().arrayIterator();
    }

    void updateNextSection(int position) {
        Section<?> next = this.getNextSection();
        if (next != null) {
            next.getOffsetReference().set(position);
        }
    }

    Section<?> getNextSection() {
        int i;
        SectionList sectionList = this.getSectionList();
        if (sectionList != null && (i = sectionList.indexOf(this)) >= 0) {
            return sectionList.get(i + 1);
        }
        return null;
    }

    Section<?> getPreviousSection() {
        int i;
        SectionList sectionList = this.getSectionList();
        if (sectionList != null && (i = sectionList.indexOf(this)) >= 0) {
            return sectionList.get(i - 1);
        }
        return null;
    }

    public SectionList getSectionList() {
        return this.getParent(SectionList.class);
    }

    int compareOffset(Section<?> section) {
        if (section == null) {
            return 1;
        }
        return Integer.compare(this.getOffset(), section.getOffset());
    }

    @Override
    protected boolean isValidOffset(int offset) {
        if (offset == 0) {
            return this.getSectionType() == SectionType.HEADER;
        }
        return offset > 0;
    }

    @Override
    protected void onRefreshed() {
        int position = this.getOffset();
        this.alignSection(this.sectionAlign, position);
        this.getOffsetReference().set(position += this.sectionAlign.size());
        this.onRefreshed(position);
        this.clearPool();
    }

    void alignSection(DexPositionAlign positionAlign, int position) {
        if (this.isPositionAlignedItem()) {
            positionAlign.setAlignment(4);
            positionAlign.align(position);
        }
    }

    private boolean isPositionAlignedItem() {
        return this.getItemArray().get(0) instanceof PositionAlignedItem;
    }

    void onRefreshed(int position) {
        this.updateNextSection(position += this.getItemArray().countBytes());
    }

    void onRemoving(T item) {
        DexSectionPool<T> dexSectionPool = this.dexSectionPool;
        if (dexSectionPool != null) {
            dexSectionPool.remove(item);
        }
    }

    int getDiffCount(Section<T> section) {
        return this.getCount();
    }

    public String toString() {
        return this.getSectionType() + ", offset = " + this.getOffset() + ", count = " + this.getCount();
    }
}

