/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.DexLayout;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;

public interface MergeOptions {
    public static final MergeOptions DEFAULT = new MergeOptions(){

        @Override
        public boolean skipMerging(ClassId classId, TypeKey typeKey) {
            return false;
        }

        @Override
        public void onDuplicate(ClassId classId) {
            classId.removeSelf();
        }

        @Override
        public void onMergeError(DexLayout dexLayout, ClassId classId, String message) {
        }

        @Override
        public void onMergeError(DexLayout dexLayout, SectionList sectionList, String message) {
        }

        @Override
        public void onDexFull(DexLayout dexLayout, ClassId classId) {
        }

        @Override
        public void onMergeSuccess(ClassId classId, TypeKey key) {
        }

        @Override
        public boolean relocateClass() {
            return true;
        }

        @Override
        public DexLayout onCreateNext(DexLayout last) {
            return null;
        }
    };

    public boolean skipMerging(ClassId var1, TypeKey var2);

    public void onDuplicate(ClassId var1);

    public void onMergeError(DexLayout var1, ClassId var2, String var3);

    public void onMergeError(DexLayout var1, SectionList var2, String var3);

    public void onDexFull(DexLayout var1, ClassId var2);

    public void onMergeSuccess(ClassId var1, TypeKey var2);

    public boolean relocateClass();

    default public int getMergeStartDexFile() {
        return 0;
    }

    default public void setMergeStartDexFile(int startDexFile) {
    }

    public DexLayout onCreateNext(DexLayout var1);

    default public boolean isEmptyDexFile(DexLayout dexLayout) {
        if (dexLayout == null || dexLayout.isEmpty()) {
            return true;
        }
        Section<ClassId> section = dexLayout.get(SectionType.CLASS_ID);
        for (ClassId classId : section) {
            if (this.skipMerging(classId, classId.getKey())) continue;
            return false;
        }
        return true;
    }
}

