/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.CountedArray;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.ParallelIntegerPair;
import com.reandroid.dex.base.ParallelReference;
import com.reandroid.dex.base.PositionAlignedItem;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.dex.sections.MapItem;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.sections.SpecialItem;
import com.reandroid.utils.collection.ArraySort;
import java.util.Comparator;
import java.util.Iterator;

public class MapList
extends SpecialItem
implements Iterable<MapItem>,
PositionAlignedItem {
    private final CountedArray<MapItem> itemArray;
    private final DexPositionAlign positionAlign;
    private final ParallelReference fileSize;
    private final ParallelReference dataStart;
    private final ParallelReference dataSize;
    private static final Creator<MapItem> CREATOR = new Creator<MapItem>(){

        public MapItem[] newArrayInstance(int length) {
            return new MapItem[length];
        }

        @Override
        public MapItem newInstance() {
            return new MapItem();
        }
    };

    public MapList(IntegerReference offsetReference) {
        super(3);
        IntegerItem mapItemsCount = new IntegerItem();
        this.itemArray = new CountedArray<MapItem>(mapItemsCount, CREATOR);
        this.positionAlign = new DexPositionAlign();
        this.addChild(0, this.positionAlign);
        this.addChild(1, mapItemsCount);
        this.addChild(2, this.itemArray);
        this.setOffsetReference(offsetReference);
        this.fileSize = new ParallelReference(new FileSizeReference(this));
        this.dataStart = new ParallelReference(new DataStartReference(this));
        this.dataSize = new ParallelReference(new DataSizeReference(this));
    }

    public SectionType<MapList> getSectionType() {
        return SectionType.MAP_LIST;
    }

    public ParallelReference getFileSize() {
        return this.fileSize;
    }

    public ParallelReference getDataStart() {
        return this.dataStart;
    }

    public ParallelReference getDataSize() {
        return this.dataSize;
    }

    public void sortMapItems(SectionType<?>[] order) {
        this.itemArray.sort(SectionType.comparator(order, MapItem::getSectionType));
    }

    public void linkHeader(DexHeader dexHeader) {
        this.linkSpecialReference(SectionType.HEADER);
        this.linkSpecialReference(SectionType.MAP_LIST);
        this.linkIdTypesHeader(dexHeader);
        this.getFileSize().setReference2(dexHeader.fileSize);
        this.getDataSize().setReference2(dexHeader.data.getFirst());
        this.getDataStart().setReference2(dexHeader.data.getSecond());
    }

    private void linkSpecialReference(SectionType<?> sectionType) {
        MapItem mapItem = this.get(sectionType);
        Section<?> section = this.getSection(sectionType);
        ParallelIntegerPair pair = (ParallelIntegerPair)section.getItemArray().getCountAndOffset();
        pair.setReference2(mapItem.getCountAndOffset());
        pair.refresh();
    }

    private void linkIdTypesHeader(DexHeader dexHeader) {
        Iterator<SectionType<?>> iterator = SectionType.getIdSectionTypes();
        while (iterator.hasNext()) {
            SectionType<?> sectionType = iterator.next();
            MapItem mapItem = this.get(sectionType);
            if (mapItem == null) continue;
            mapItem.link(dexHeader);
        }
    }

    public MapItem getDataStartItem() {
        boolean headerFound = false;
        for (MapItem mapItem : this) {
            SectionType sectionType = mapItem.getSectionType();
            if (!headerFound) {
                headerFound = sectionType == SectionType.HEADER;
                continue;
            }
            if (!sectionType.isDataSection()) continue;
            return mapItem;
        }
        return null;
    }

    public void remove(SectionType<?> sectionType) {
        this.remove(this.get(sectionType));
    }

    public void remove(MapItem mapItem) {
        if (mapItem == null) {
            return;
        }
        ParallelIntegerPair pair = mapItem.getCountAndOffset();
        pair.getFirst().set(0);
        pair.getSecond().set(0);
        pair.setReference2(null);
        this.itemArray.remove(mapItem);
        mapItem.setParent(null);
        mapItem.setIndex(-1);
    }

    public MapItem get(SectionType<?> type) {
        for (MapItem mapItem : this) {
            if (type != mapItem.getSectionType()) continue;
            return mapItem;
        }
        return null;
    }

    public MapItem getOrCreate(SectionType<?> type) {
        MapItem mapItem = this.get(type);
        if (mapItem != null) {
            return null;
        }
        mapItem = (MapItem)this.itemArray.createNext();
        mapItem.setType(type);
        return mapItem;
    }

    @Override
    public Iterator<MapItem> iterator() {
        return this.itemArray.iterator();
    }

    public MapItem[] getReadSorted() {
        Object[] mapItemList = (MapItem[])((MapItem[])this.itemArray.getChildes()).clone();
        Comparator<MapItem> comparator = SectionType.comparator(SectionType.getReadOrderList(), MapItem::getSectionType);
        ArraySort.sort(mapItemList, comparator);
        return mapItemList;
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.getFileSize().refresh();
        this.getDataStart().refresh();
        this.getDataSize().refresh();
    }

    public String toString() {
        MapItem[] mapItems = (MapItem[])this.itemArray.getChildes();
        StringBuilder builder = new StringBuilder(mapItems.length * 47);
        for (int i = 0; i < mapItems.length; ++i) {
            if (i != 0) {
                builder.append('\n');
            }
            if (i < 9) {
                builder.append(' ');
            }
            builder.append(i + 1);
            builder.append(") ");
            builder.append(mapItems[i]);
        }
        return builder.toString();
    }

    @Override
    public DexPositionAlign getPositionAlign() {
        return this.positionAlign;
    }

    static class FileSizeReference
    implements IntegerReference {
        private final MapList mapList;

        private FileSizeReference(MapList mapList) {
            this.mapList = mapList;
        }

        @Override
        public int get() {
            return this.mapList.getOffset() + this.mapList.countBytes();
        }

        @Override
        public void set(int value) {
        }
    }

    static class DataSizeReference
    implements IntegerReference {
        private final MapList mapList;

        private DataSizeReference(MapList mapList) {
            this.mapList = mapList;
        }

        @Override
        public int get() {
            MapItem mapItem = this.mapList.getDataStartItem();
            if (mapItem != null) {
                return this.mapList.getFileSize().get() - mapItem.getOffset().get();
            }
            return 0;
        }

        @Override
        public void set(int value) {
        }
    }

    static class DataStartReference
    implements IntegerReference {
        private final MapList mapList;

        private DataStartReference(MapList mapList) {
            this.mapList = mapList;
        }

        @Override
        public int get() {
            MapItem mapItem = this.mapList.getDataStartItem();
            if (mapItem != null) {
                return mapItem.getOffset().get();
            }
            return 0;
        }

        @Override
        public void set(int value) {
        }
    }
}

