/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Block;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.sections.IdSectionArray;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionArray;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;

public class IdSection<T extends IdItem>
extends Section<T> {
    public IdSection(IntegerPair countAndOffset, SectionType<T> sectionType) {
        super(sectionType, new IdSectionArray<T>(countAndOffset, sectionType.getCreator()));
    }

    IdSection(SectionType<T> sectionType, IdSectionArray<T> itemArray) {
        super(sectionType, itemArray);
    }

    @Override
    boolean keyChanged(Block block, Key key, boolean immediateSort) {
        boolean changed = super.keyChanged(block, key, immediateSort);
        if (!immediateSort) {
            return changed;
        }
        IdItem item = (IdItem)block;
        this.sortImmediate(item);
        return changed;
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.sort();
    }

    @Override
    public boolean remove(Key key) {
        IdItem item = (IdItem)this.getSectionItem(key);
        if (item != null && item.getParent() != null) {
            item.removeSelf();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Key> removeWithKeys(Predicate<Key> filter) {
        Iterator iterator = this.getItemArray().clonedIterator();
        return ComputeIterator.of(iterator, item -> {
            Key key = item.getKey();
            if (filter.test(key)) {
                item.removeSelf();
                return key;
            }
            return null;
        });
    }

    @Override
    public T getSectionItem(int i) {
        IdItem result = (IdItem)this.getItemArray().get(i);
        if (i >= 0 && result == null) {
            throw new NullPointerException("Null id: " + i);
        }
        return (T)result;
    }

    @Override
    public T[] getSectionItems(int[] indexes) {
        if (indexes == null || indexes.length == 0) {
            return null;
        }
        SectionArray itemArray = this.getItemArray();
        int length = indexes.length;
        IdItem[] results = (IdItem[])itemArray.newArrayInstance(indexes.length);
        for (int i = 0; i < length; ++i) {
            results[i] = (IdItem)itemArray.get(indexes[i]);
            if (results[i] != null) continue;
            throw new NullPointerException("Null id: " + i);
        }
        return results;
    }

    @Override
    public T createItem() {
        return (T)((IdItem)this.getItemArray().createNext());
    }

    @Override
    void onRefreshed(int position) {
        this.updateNextSection(position += this.getItemArray().countBytes());
    }

    @Override
    int getDiffCount(Section<T> section) {
        int count = this.getCount();
        if (section == this || section == null) {
            return count;
        }
        for (IdItem item : section) {
            if (this.contains(item.getKey())) continue;
            ++count;
        }
        return count;
    }

    public boolean canAdd(Collection<IdItem> collection) {
        int count = this.getCount() + 200;
        int check = count + collection.size();
        if ((check & 0xFFFF0000) == 0) {
            return true;
        }
        SectionType sectionType = this.getSectionType();
        for (IdItem item : collection) {
            if (item.getSectionType() != sectionType) continue;
            Key key = item.getKey();
            if (!this.contains(key)) {
                ++count;
            }
            if ((count & 0xFFFF0000) == 0) continue;
            return false;
        }
        return (count & 0xFFFF0000) == 0;
    }
}

