/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.common.BytesOutputStream;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.header.Checksum;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.pool.KeyPool;
import com.reandroid.dex.sections.MapList;
import com.reandroid.dex.sections.Marker;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.function.Predicate;

public class DexLayout
extends FixedBlockContainer
implements FullRefresh {
    private final SectionList sectionList = new SectionList();
    private String mSimpleName;
    private final KeyPool<ClassId> extendingClassMap;
    private final KeyPool<ClassId> interfaceMap;
    private Object mTag;

    public DexLayout() {
        super(1);
        this.addChild(0, this.sectionList);
        this.extendingClassMap = new KeyPool<ClassId>(SectionType.CLASS_ID, 2000);
        this.interfaceMap = new KeyPool<ClassId>(SectionType.CLASS_ID, 2000);
    }

    public int getVersion() {
        return this.getHeader().getVersion();
    }

    public void setVersion(int version) {
        this.getHeader().setVersion(version);
    }

    public Iterator<Marker> getMarkers() {
        return Marker.parse(this.get(SectionType.STRING_ID));
    }

    public Iterator<ClassId> getSubTypes(TypeKey typeKey) {
        Iterator<ClassId> iterator = CombiningIterator.two(this.getExtendingClassIds(typeKey), this.getImplementationIds(typeKey));
        return new IterableIterator<ClassId, ClassId>(iterator){

            @Override
            public Iterator<ClassId> iterator(ClassId element) {
                return CombiningIterator.two(SingleIterator.of(element), DexLayout.this.getSubTypes(element.getKey()));
            }
        };
    }

    public Iterator<ClassId> getExtendingClassIds(TypeKey typeKey) {
        if (this.extendingClassMap.size() == 0) {
            this.loadExtendingClassMap();
        }
        return this.extendingClassMap.getAll(typeKey);
    }

    public Iterator<ClassId> getImplementationIds(TypeKey interfaceClass) {
        if (this.interfaceMap.size() == 0) {
            this.loadInterfacesMap();
        }
        return this.interfaceMap.getAll(interfaceClass);
    }

    public void clear() {
        this.extendingClassMap.clear();
        this.interfaceMap.clear();
        this.getSectionList().clear();
    }

    private void loadExtendingClassMap() {
        KeyPool<ClassId> superClassMap = this.extendingClassMap;
        superClassMap.clear();
        Iterator<ClassId> iterator = this.getItems(SectionType.CLASS_ID);
        while (iterator.hasNext()) {
            ClassId classId = iterator.next();
            String superName = classId.getSuperClassKey().getTypeName();
            if (DexUtils.isJavaFramework(superName)) continue;
            TypeKey typeKey = TypeKey.create(superName);
            superClassMap.put((Key)typeKey, classId);
        }
        superClassMap.trimToSize();
    }

    private void loadInterfacesMap() {
        KeyPool<ClassId> interfaceMap = this.interfaceMap;
        interfaceMap.clear();
        Iterator<ClassId> iterator = this.getItems(SectionType.CLASS_ID);
        while (iterator.hasNext()) {
            ClassId classId = iterator.next();
            Iterator<TypeKey> interfaceKeys = classId.getInterfaceKeys();
            while (interfaceKeys.hasNext()) {
                TypeKey typeKey = interfaceKeys.next();
                if (DexUtils.isJavaFramework(typeKey.getTypeName())) continue;
                interfaceMap.put((Key)typeKey, classId);
            }
        }
        interfaceMap.trimToSize();
    }

    public Iterator<StringId> getStrings() {
        return this.getItems(SectionType.STRING_ID);
    }

    public <T1 extends SectionItem> Iterator<T1> getClonedItems(SectionType<T1> sectionType) {
        Section<T1> section = this.getSectionList().getSection(sectionType);
        if (section != null) {
            return section.clonedIterator();
        }
        return EmptyIterator.of();
    }

    public <T1 extends SectionItem> Iterator<T1> getItems(SectionType<T1> sectionType) {
        Section<T1> section = this.getSectionList().getSection(sectionType);
        if (section != null) {
            return section.iterator();
        }
        return EmptyIterator.of();
    }

    @Override
    public void refreshFull() throws DexException {
        int trials;
        this.getSectionList().refreshFull();
        Checksum checksum = this.getHeader().checksum;
        int previousSum = checksum.getValue();
        int max_trials = 10;
        for (trials = 0; trials < max_trials; ++trials) {
            this.refresh();
            int sum = checksum.getValue();
            if (previousSum == sum) {
                return;
            }
            previousSum = sum;
        }
        throw new DexException("Failed to refresh trials = " + trials);
    }

    public void sortSection(SectionType<?>[] order) {
        this.refresh();
        this.getSectionList().sortSection(order);
        this.refresh();
    }

    public void clearPool(SectionType<?> sectionType) {
        this.getSectionList().clearPool(sectionType);
    }

    public void clearPools() {
        this.getSectionList().clearPools();
    }

    public void sortStrings() {
        this.getSectionList().sortStrings();
    }

    public <T1 extends SectionItem> Iterator<T1> getAll(SectionType<T1> sectionType, Key key) {
        Section<T1> section = this.get(sectionType);
        if (section != null) {
            return section.getAll(key);
        }
        return EmptyIterator.of();
    }

    public <T1 extends SectionItem> int removeEntries(SectionType<T1> sectionType, Predicate<T1> filter) {
        Section<T1> section = this.get(sectionType);
        if (section != null) {
            return section.removeEntries(filter);
        }
        return 0;
    }

    public <T1 extends SectionItem> Iterator<Key> removeWithKeys(SectionType<T1> sectionType, Predicate<Key> filter) {
        Section<T1> section = this.get(sectionType);
        if (section != null) {
            return section.removeWithKeys(filter);
        }
        return EmptyIterator.of();
    }

    public <T1 extends SectionItem> T1 get(SectionType<T1> sectionType, Key key) {
        Section<T1> section = this.get(sectionType);
        if (section != null) {
            return section.getSectionItem(key);
        }
        return null;
    }

    public <T1 extends SectionItem> Section<T1> get(SectionType<T1> sectionType) {
        return this.getSectionList().getSection(sectionType);
    }

    public DexHeader getHeader() {
        return this.getSectionList().getHeader();
    }

    public SectionList getSectionList() {
        return this.sectionList;
    }

    public MapList getMapList() {
        return this.getSectionList().getMapList();
    }

    @Override
    protected void onPreRefresh() {
        this.sectionList.refresh();
        this.interfaceMap.clear();
        this.extendingClassMap.clear();
    }

    @Override
    protected void onRefreshed() {
        this.sectionList.updateHeader();
    }

    public boolean isEmpty() {
        Section<ClassId> section = this.get(SectionType.CLASS_ID);
        return section == null || section.getCount() == 0;
    }

    public boolean merge(MergeOptions options, ClassId classId) {
        return this.getSectionList().merge(options, classId);
    }

    public boolean merge(MergeOptions options, DexLayout dexFile) {
        if (dexFile == this) {
            options.onMergeError(this, this.getSectionList(), "Can not merge dex file to self");
            return false;
        }
        return this.getSectionList().merge(options, dexFile.getSectionList());
    }

    public void fromSmali(SmaliClass smaliClass) throws IOException {
        this.getSectionList().fromSmali(smaliClass);
    }

    @Override
    public byte[] getBytes() {
        BytesOutputStream outputStream = new BytesOutputStream(this.getHeader().fileSize.get());
        try {
            this.writeBytes(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public void read(byte[] dexBytes) throws IOException {
        BlockReader reader = new BlockReader(dexBytes);
        this.readBytes(reader);
        reader.close();
    }

    public void read(InputStream inputStream) throws IOException {
        BlockReader reader = inputStream instanceof BlockReader ? (BlockReader)inputStream : new BlockReader(inputStream);
        this.readBytes(reader);
        reader.close();
    }

    public void readStrings(InputStream inputStream) throws IOException {
        BlockReader reader = inputStream instanceof BlockReader ? (BlockReader)inputStream : new BlockReader(inputStream);
        this.readStrings(reader);
    }

    public void readStrings(BlockReader reader) throws IOException {
        this.readSections(reader, sectionType -> sectionType == SectionType.STRING_ID || sectionType == SectionType.STRING_DATA);
    }

    public void readClassIds(BlockReader reader) throws IOException {
        this.readSections(reader, sectionType -> sectionType == SectionType.STRING_ID || sectionType == SectionType.STRING_DATA || sectionType == SectionType.TYPE_ID || sectionType == SectionType.CLASS_ID);
    }

    public void readSections(BlockReader reader, Predicate<SectionType<?>> filter) throws IOException {
        this.getSectionList().readSections(reader, filter);
        reader.close();
    }

    public void read(File file) throws IOException {
        BlockReader reader = new BlockReader(file);
        this.readBytes(reader);
        reader.close();
    }

    public void write(File file) throws IOException {
        OutputStream outputStream = FileUtil.outputStream(file);
        this.writeBytes(outputStream);
        outputStream.close();
    }

    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    public String getSimpleName() {
        return this.mSimpleName;
    }

    public void setSimpleName(String simpleName) {
        this.mSimpleName = simpleName;
    }

    public static DexLayout createDefault() {
        SectionType<?>[] commonTypes;
        DexLayout dexLayout = new DexLayout();
        SectionList sectionList = dexLayout.getSectionList();
        MapList mapList = sectionList.getMapList();
        mapList.getOrCreate(SectionType.HEADER);
        mapList.getOrCreate(SectionType.MAP_LIST);
        for (SectionType<?> sectionType : commonTypes = SectionType.getR8Order()) {
            sectionList.getOrCreateSection(sectionType);
        }
        sectionList.getMapList().linkHeader(sectionList.getHeader());
        return dexLayout;
    }

    public static boolean isDexFile(File file) {
        if (file == null || !file.isFile()) {
            return false;
        }
        DexHeader dexHeader = null;
        try {
            InputStream inputStream = FileUtil.inputStream(file);
            dexHeader = DexHeader.readHeader(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DexLayout.isDexFile(dexHeader);
    }

    public static boolean isDexFile(InputStream inputStream) {
        DexHeader dexHeader = null;
        try {
            dexHeader = DexHeader.readHeader(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DexLayout.isDexFile(dexHeader);
    }

    private static boolean isDexFile(DexHeader dexHeader) {
        if (dexHeader == null) {
            return false;
        }
        if (dexHeader.magic.isDefault()) {
            return false;
        }
        int version = dexHeader.getVersion();
        return version > 0 && version < 1000;
    }
}

