/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.container.BlockList;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.sections.DexLayout;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Iterator;

public class DexContainer
extends BlockList<DexLayout>
implements Iterable<DexLayout> {
    private DexLayout current = new DexLayout();

    public DexContainer() {
        this.add(this.current);
    }

    public DexLayout getDexLayout() {
        return this.current;
    }

    public <T1 extends SectionItem> Iterator<T1> getSectionItems(SectionType<T1> sectionType, Key key) {
        return ComputeIterator.of(this.getSectionLists(), sectionList -> sectionList.getSectionItem(sectionType, key));
    }

    public <T1 extends SectionItem> Iterator<Section<T1>> getSections(SectionType<T1> sectionType) {
        return ComputeIterator.of(this.getSectionLists(), sectionList -> sectionList.getSection(sectionType));
    }

    public <T1 extends SectionItem> Section<T1> getSection(SectionType<T1> sectionType) {
        Iterator<SectionList> iterator = this.getSectionLists();
        while (iterator.hasNext()) {
            Section<T1> section = iterator.next().getSection(sectionType);
            if (section == null) continue;
            return section;
        }
        return null;
    }

    public Iterator<SectionList> getSectionLists() {
        return ComputeIterator.of(this.iterator(), DexLayout::getSectionList);
    }
}

