/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.common.SectionItemContainer;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.sections.SectionArray;
import java.io.IOException;

public class DataSectionArray<T extends DataItem>
extends SectionArray<T> {
    private int mStart;
    private int mEnd;

    public DataSectionArray(IntegerPair countAndOffset, Creator<T> creator) {
        super(countAndOffset, creator);
    }

    @Override
    public void onChanged() {
        super.onChanged();
        this.mStart = 0;
    }

    public T getAt(int offset) {
        if (offset <= 0) {
            return null;
        }
        int start = this.mStart;
        if (start == 0 || offset < start || offset > this.mEnd) {
            this.updateBounds();
        }
        return this.getAt(offset, this.estimateBeginPosition(offset));
    }

    public T getAt(int offset, int indexHint) {
        if (offset <= 0) {
            return null;
        }
        T item = this.spiderSearch(offset, indexHint);
        if (item != null) {
            return item;
        }
        item = this.lazySearch(offset);
        if (item != null) {
            this.updateBounds();
        }
        return item;
    }

    public T[] getAt(int[] offsets) {
        if (offsets == null || offsets.length == 0) {
            return null;
        }
        int length = offsets.length;
        DataItem[] results = (DataItem[])this.newArrayInstance(offsets.length);
        for (int i = 0; i < length; ++i) {
            results[i] = this.getAt(offsets[i]);
        }
        return results;
    }

    @Override
    public void readChild(BlockReader reader, T item) throws IOException {
        int offset = reader.getPosition();
        ((SectionItemContainer)item).setPosition(offset);
        ((SectionItemContainer)item).onReadBytes(reader);
    }

    @Override
    public void onPreRemove(T item) {
        super.onPreRemove(item);
        IntegerReference reference = ((SectionItemContainer)item).getOffsetReference();
        if (reference != null) {
            reference.set(0);
        }
    }

    private T lazySearch(int offset) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            DataItem item = (DataItem)this.get(i);
            if (offset != item.getOffset()) continue;
            return (T)item;
        }
        return null;
    }

    private T spiderSearch(int offset, int beginIndex) {
        int size = this.size();
        int i = beginIndex;
        boolean lookBack = false;
        boolean lookFront = false;
        boolean lookChanged = false;
        int step = 1;
        int acceleration = 1;
        while (i >= 0 && i < size) {
            int remain;
            DataItem item = (DataItem)this.get(i);
            int itemOffset = item.getOffset();
            if (itemOffset == offset) {
                return (T)item;
            }
            if (offset < itemOffset) {
                if (lookFront) {
                    if (lookChanged) {
                        return null;
                    }
                    lookChanged = true;
                    lookFront = false;
                    step = 1;
                } else if (lookBack && i == 0) {
                    return null;
                }
                if (!lookChanged && step > (remain = i / 3 + 1)) {
                    step = remain;
                }
                lookBack = true;
                if ((i -= step) < 0) {
                    i = 0;
                }
            } else {
                if (lookBack) {
                    if (lookChanged) {
                        return null;
                    }
                    lookBack = false;
                    lookChanged = true;
                    step = 1;
                }
                if (!lookChanged && step > (remain = (size - i) / 3 + 1)) {
                    step = remain;
                }
                lookFront = true;
                i += step;
            }
            if (lookChanged || (step += acceleration + 1) % 2 != 1) continue;
            ++acceleration;
        }
        return null;
    }

    private int estimateBeginPosition(int offset) {
        int bytes = this.mEnd - this.mStart;
        if (bytes == 0) {
            bytes = 1;
        }
        int offsetDiff = offset - this.mStart;
        long result = (long)offsetDiff * (long)this.size();
        int index = (int)(result /= (long)bytes);
        int size = this.size();
        if (--index >= size) {
            index = size - 1;
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    private void updateBounds() {
        this.mStart = 0;
        DataItem item = (DataItem)this.getFirst();
        if (item != null) {
            this.mStart = item.getOffset();
        }
        this.mEnd = this.mStart;
        item = (DataItem)this.getLast();
        if (item != null) {
            this.mEnd = item.getOffset();
        }
    }
}

