/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.base.PositionAlignedItem;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.pool.DataSectionPool;
import com.reandroid.dex.sections.DataSectionArray;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionArray;
import com.reandroid.dex.sections.SectionType;

public class DataSection<T extends DataItem>
extends Section<T> {
    public DataSection(IntegerPair countAndOffset, SectionType<T> sectionType) {
        super(sectionType, new DataSectionArray<T>(countAndOffset, sectionType.getCreator()));
    }

    DataSection(SectionType<T> sectionType, DataSectionArray<T> itemArray) {
        super(sectionType, itemArray);
    }

    @Override
    int clearUnused() {
        return 0;
    }

    @Override
    public T getSectionItem(int offset) {
        return ((DataSectionArray)this.getItemArray()).getAt(offset);
    }

    @Override
    public T[] getSectionItems(int[] offsets) {
        return this.getItemArray().getAt(offsets);
    }

    @Override
    public T createItem() {
        int position = this.estimateLastOffset();
        DataItem item = (DataItem)this.getItemArray().createNext();
        item.setPosition(position);
        return (T)item;
    }

    @Override
    public DataSectionPool<T> getPool() {
        return (DataSectionPool)super.getPool();
    }

    @Override
    DataSectionPool<T> createPool() {
        return new DataSectionPool(this);
    }

    @Override
    public DataSectionArray<T> getItemArray() {
        return (DataSectionArray)super.getItemArray();
    }

    private int estimateLastOffset() {
        int offset;
        DataItem last = (DataItem)this.getItemArray().getLast();
        if (last != null) {
            IntegerReference supplier = last.getOffsetReference();
            offset = supplier.get();
            offset += last.countBytes();
        } else {
            offset = this.getOffset() + this.countBytes();
            if (offset == 0) {
                offset = this.estimateMainOffset();
            }
        }
        return offset;
    }

    private int estimateMainOffset() {
        int offset = this.getOffset();
        if (offset != 0) {
            return offset;
        }
        Section<?> section = this.getNextSection();
        if (section == null && (section = this.getPreviousSection()) != null) {
            offset = section.countBytes();
        }
        if (section != null) {
            offset += section.getOffset();
        }
        if (offset == 0) {
            offset = 1;
        }
        this.getOffsetReference().set(offset);
        return offset;
    }

    @Override
    void onRefreshed(int position) {
        this.updateItemOffsets(position);
    }

    @Override
    void alignSection(DexPositionAlign positionAlign, int position) {
        if (this.isPositionAlignedItem()) {
            positionAlign.setAlignment(4);
            positionAlign.align(position);
        }
    }

    private boolean isPositionAlignedItem() {
        return this.getItemArray().get(0) instanceof PositionAlignedItem;
    }

    private void updateItemOffsets(int position) {
        SectionArray array = this.getItemArray();
        position = array.updatePositionedItemOffsets(position);
        this.updateNextSection(position);
    }

    @Override
    int getDiffCount(Section<T> section) {
        return this.getCount();
    }
}

