/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.reference.IdReference;
import com.reandroid.dex.sections.SectionType;
import java.io.IOException;

public class Ule128IdItemReference<T extends IdItem>
extends Ule128Item
implements IdReference<T> {
    private final SectionType<T> sectionType;
    private T item;
    private final int usageType;

    public Ule128IdItemReference(SectionType<T> sectionType, int usageType) {
        this.sectionType = sectionType;
        this.usageType = usageType;
    }

    @Override
    public T getItem() {
        return this.item;
    }

    @Override
    public void setItem(T item) {
        int index = 0;
        if (item != null) {
            index = ((IdItem)item).getIdx();
            ((SectionItem)item).addUsageType(this.usageType);
        }
        this.item = item;
        this.set(index);
    }

    @Override
    public Key getKey() {
        SectionItem item = this.getItem();
        if (item != null) {
            return item.getKey();
        }
        return null;
    }

    @Override
    public void setItem(Key item) {
        DexSectionPool<T> pool = this.getPool(this.getSectionType());
        this.setItem((T)((IdItem)pool.getOrCreate(item)));
    }

    @Override
    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    @Override
    public void pullItem() {
        this.item = (IdItem)this.getSectionItem(this.getSectionType(), this.get());
        this.updateItemUsage();
    }

    @Override
    public void refresh() {
        SectionItem item = this.getItem();
        if (item != null) {
            item = (IdItem)item.getReplace();
        }
        this.checkNonNullItem(item);
        if (item != null) {
            this.set(((IdItem)item).getIdx());
        }
        this.item = item;
        this.updateItemUsage();
    }

    private void updateItemUsage() {
        T item = this.item;
        if (item != null) {
            ((SectionItem)item).addUsageType(this.usageType);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.pullItem();
    }

    @Override
    public String toString() {
        T item = this.item;
        if (item != null) {
            return item.toString();
        }
        return this.getSectionType().getName() + ": " + this.get();
    }
}

