/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.dex.base.DexException;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.SizeXIns;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.IdReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.HexUtil;
import java.util.Objects;

public class InsIdSectionReference
implements IdReference<IdItem> {
    private final SizeXIns sizeXIns;
    private IdItem item;

    public InsIdSectionReference(SizeXIns sizeXIns) {
        this.sizeXIns = sizeXIns;
    }

    @Override
    public IdItem getItem() {
        return this.item;
    }

    @Override
    public void setItem(IdItem item) {
        this.item = item = this.validateReplace(item);
        this.set(item.getIdx());
        this.updateUsage();
    }

    @Override
    public Key getKey() {
        return this.getItem().getKey();
    }

    @Override
    public void setItem(Key key) {
        IdItem item = this.sizeXIns.getOrCreateSection(this.getSectionType()).getOrCreate(key);
        this.setItem(item);
    }

    @Override
    public void pullItem() {
        this.setItem(this.sizeXIns.getSectionItem(this.getSectionType(), this.get()));
    }

    @Override
    public void refresh() {
        IdItem item;
        this.item = item = this.validateReplace(this.item);
        this.set(item.getIdx());
        this.updateUsage();
    }

    public void validate() {
        this.validateReplace(this.item);
    }

    private void updateUsage() {
        IdItem item = this.item;
        if (item != null) {
            item.addUsageType(UsageMarker.USAGE_INSTRUCTION);
        }
    }

    @Override
    public int get() {
        return this.sizeXIns.getData();
    }

    @Override
    public void set(int value) {
        this.sizeXIns.setData(value);
    }

    @Override
    public SectionType<IdItem> getSectionType() {
        return this.sizeXIns.getSectionType();
    }

    private IdItem validateReplace(IdItem idItem) {
        if (idItem == null) {
            throw new DexException("null id item: " + this.buildTrace(null));
        }
        if ((idItem = (IdItem)idItem.getReplace()) == null) {
            throw new DexException("Invalid id item: " + this.buildTrace(null));
        }
        return this.validateType(idItem);
    }

    private IdItem validateType(IdItem idItem) {
        Key key = idItem.getKey();
        if (key instanceof TypeKey) {
            TypeKey typeKey = (TypeKey)key;
            if (this.item != null && !typeKey.isTypeObject() && !this.sizeXIns.is(Opcode.CONST_CLASS)) {
                throw new DexException("Unexpected type '" + key + "', " + this.buildTrace(idItem));
            }
        }
        return idItem;
    }

    private String buildTrace(IdItem item) {
        SizeXIns sizeXIns = this.sizeXIns;
        InstructionList instructionList = sizeXIns.getInstructionList();
        if (instructionList == null) {
            return "removed instruction";
        }
        CodeItem codeItem = instructionList.getCodeItem();
        if (codeItem == null) {
            return "removed instruction list";
        }
        if (codeItem.getParent() == null) {
            return "removed code item";
        }
        MethodDef methodDef = codeItem.getMethodDef();
        StringBuilder builder = new StringBuilder();
        if (methodDef != null) {
            builder.append("method = ");
            builder.append(methodDef.getKey());
            builder.append(", ");
        }
        builder.append(sizeXIns.getOpcode());
        String key = InsIdSectionReference.toDebugString(item);
        if (key == null) {
            key = HexUtil.toHex(this.get(), 1);
        }
        builder.append(", key = '");
        builder.append(key);
        builder.append('\'');
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InsIdSectionReference sectionItem = (InsIdSectionReference)obj;
        return Objects.equals(this.getItem(), sectionItem.getItem());
    }

    public int hashCode() {
        IdItem idItem = this.getItem();
        if (idItem == null) {
            return 0;
        }
        return idItem.hashCode();
    }

    public String toString() {
        IdItem item = this.item;
        if (item == null) {
            return this.getSectionType().getName() + ": " + this.get();
        }
        return item.getKey().toString();
    }

    private static String toDebugString(IdItem item) {
        if (item == null) {
            return null;
        }
        Key key = item.getKey();
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        if (keyString == null) {
            return null;
        }
        if (keyString.length() > 100) {
            keyString = keyString.substring(0, 100) + "...";
        }
        if (keyString.startsWith("\"")) {
            keyString = keyString.substring(1);
        }
        if (keyString.endsWith("\"")) {
            keyString = keyString.substring(0, keyString.length() - 1);
        }
        return keyString;
    }
}

