/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.IndirectItem;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.reference.IdReference;
import com.reandroid.dex.sections.SectionType;
import java.lang.reflect.Field;

public class IdItemIndirectReference<T extends IdItem>
extends IndirectItem<SectionItem>
implements IdReference<T>,
Comparable<IdReference<T>> {
    private final SectionType<T> sectionType;
    private final int usageType;
    private T item;

    public IdItemIndirectReference(SectionType<T> sectionType, SectionItem blockItem, int offset, int usage) {
        super(blockItem, offset);
        this.sectionType = sectionType;
        this.usageType = usage;
        Block.putInteger(this.getBytesInternal(), this.getOffset(), -1);
    }

    public IdItemIndirectReference(SectionType<T> sectionType, SectionItem blockItem, int offset) {
        this(sectionType, blockItem, offset, IdItem.USAGE_NONE);
    }

    @Override
    public Key getKey() {
        SectionItem item = this.getItem();
        if (item != null) {
            return ((IdItem)item).getKey();
        }
        return null;
    }

    @Override
    public T getItem() {
        return this.item;
    }

    @Override
    public void setItem(T item) {
        if (item == this.item) {
            return;
        }
        int index = this.getItemIndex(item);
        this.set(index);
        this.item = item;
        this.updateItemUsage();
    }

    @Override
    public void pullItem() {
        this.item = this.pullItem(this.get());
        this.updateItemUsage();
    }

    protected T pullItem(int i) {
        return (T)((IdItem)((SectionItem)this.getBlockItem()).getSectionItem(this.getSectionType(), i));
    }

    @Override
    public void setItem(Key key) {
        this.setItem((T)((IdItem)((SectionItem)this.getBlockItem()).getOrCreateSectionItem(this.getSectionType(), key)));
    }

    @Override
    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    @Override
    public void set(int value) {
        Block.putInteger(this.getBytesInternal(), this.getOffset(), value);
    }

    @Override
    public int get() {
        return Block.getInteger(this.getBytesInternal(), this.getOffset());
    }

    @Override
    public void refresh() {
        SectionItem item = this.getItem();
        if (item != null) {
            item = (IdItem)item.getReplace();
        }
        this.checkNonNullItem(item);
        if (item != null) {
            this.set(((IdItem)item).getIdx());
        }
        this.item = item;
        this.updateItemUsage();
    }

    @Override
    public void checkNonNullItem(T item) {
        if (item != null) {
            return;
        }
        throw new NullPointerException(this.buildMessage());
    }

    private String buildMessage() {
        Field[] fields;
        SectionItem blockItem = (SectionItem)this.getBlockItem();
        StringBuilder builder = new StringBuilder();
        builder.append("Parent = ");
        builder.append(blockItem);
        Class<?> clazz = blockItem.getClass();
        for (Field field : fields = clazz.getFields()) {
            try {
                field.setAccessible(true);
                Object obj = field.get(blockItem);
                if (obj != this) continue;
                builder.append(", Field = ");
                builder.append(field.getName());
                break;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        builder.append(", section = ");
        builder.append(this.getSectionType().getName());
        return builder.toString();
    }

    protected int getItemIndex(T item) {
        if (item == null) {
            throw new NullPointerException("Can't set null for reference of: " + this.getSectionType().getName());
        }
        return ((IdItem)item).getIdx();
    }

    private void updateItemUsage() {
        int usageType = this.usageType;
        if (usageType == UsageMarker.USAGE_NONE) {
            return;
        }
        T item = this.item;
        if (item != null) {
            ((SectionItem)item).addUsageType(usageType);
        }
    }

    public void unlink() {
        this.item = null;
        this.set(0);
    }

    public void replaceKeys(Key search, Key replace) {
        Key key = this.getKey();
        if (key == null) {
            return;
        }
        Key key2 = key.replaceKey(search, replace);
        if (key != key2) {
            this.setItem(key2);
        }
    }

    @Override
    public int compareTo(IdReference<T> reference) {
        return SectionTool.compareIdx(this.getItem(), (IdItem)reference.getItem());
    }

    public String toString() {
        if (this.item != null) {
            return this.get() + ": " + this.item.toString();
        }
        return this.sectionType.getName() + ": " + this.get();
    }
}

