/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.refactor;

import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.KeyPair;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.refactor.Rename;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.ObjectsUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RenameTypes
extends Rename<TypeKey, TypeKey> {
    private int arrayDepth = DEFAULT_ARRAY_DEPTH;
    private boolean renameSignatures = true;
    private boolean renameSource = true;
    private boolean noRenameSourceForNoPackageClass = true;
    public static final int DEFAULT_ARRAY_DEPTH = ObjectsUtil.of(3);

    @Override
    public int apply(DexClassRepository classRepository) {
        Map<String, String> map = this.buildRenameMap();
        Iterator<StringId> iterator = classRepository.getClonedItems(SectionType.STRING_ID);
        int count = 0;
        while (iterator.hasNext()) {
            StringId stringId = iterator.next();
            stringId.addUsageType(UsageMarker.USAGE_DEFINITION);
            String text = map.get(stringId.getString());
            if (text != null) {
                stringId.setString(text);
                ++count;
                continue;
            }
            if (!this.renameSignatures(map, stringId)) continue;
            ++count;
        }
        return count;
    }

    private boolean renameSignatures(Map<String, String> map, StringId stringId) {
        if (!stringId.containsUsage(UsageMarker.USAGE_SIGNATURE_TYPE)) {
            return false;
        }
        String text = stringId.getString();
        if (text.indexOf(76) < 0) {
            return false;
        }
        String[] signatures = DexUtils.splitSignatures(text);
        int length = signatures.length;
        boolean found = false;
        for (int i = 0; i < length; ++i) {
            String type = signatures[i];
            String replace = map.get(type);
            if (replace == null) continue;
            signatures[i] = replace;
            found = true;
        }
        if (!found) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(signatures[i]);
        }
        stringId.setString(builder.toString());
        return true;
    }

    public void setArrayDepth(int arrayDepth) {
        if (arrayDepth < 0) {
            arrayDepth = DEFAULT_ARRAY_DEPTH;
        }
        this.arrayDepth = arrayDepth;
    }

    public void setRenameSignatures(boolean renameSignatures) {
        this.renameSignatures = renameSignatures;
    }

    public void setRenameSource(boolean renameSource) {
        this.renameSource = renameSource;
    }

    public void setNoRenameSourceForNoPackageClass(boolean noRenameSourceForNoPackageClass) {
        this.noRenameSourceForNoPackageClass = noRenameSourceForNoPackageClass;
    }

    private Map<String, String> buildRenameMap() {
        List list = this.sortedList();
        boolean renameSignatures = this.renameSignatures;
        boolean renameSource = this.renameSource;
        boolean noRenameSourceForNoPackageClass = this.noRenameSourceForNoPackageClass;
        int estimatedSize = 1;
        if (renameSignatures) {
            estimatedSize += 2;
        }
        if (renameSource) {
            ++estimatedSize;
        }
        if (this.arrayDepth > 0) {
            estimatedSize = estimatedSize + this.arrayDepth + 1;
        }
        estimatedSize = list.size() * estimatedSize;
        HashMap<String, String> map = new HashMap<String, String>(estimatedSize);
        int size = list.size();
        int arrayDepth = this.arrayDepth + 1;
        for (int i = 0; i < size; ++i) {
            KeyPair keyPair = list.get(i);
            TypeKey first = (TypeKey)keyPair.getFirst();
            TypeKey second = (TypeKey)keyPair.getSecond();
            String name1 = first.getTypeName();
            String name2 = second.getTypeName();
            map.put(name1, name2);
            if (renameSignatures) {
                name1 = first.getTypeName();
                name2 = second.getTypeName();
                name1 = name1.replace(';', '<');
                name2 = name2.replace(';', '<');
                map.put(name1, name2);
                name1 = first.getTypeName();
                name2 = second.getTypeName();
                name1 = name1.substring(0, name1.length() - 1);
                name2 = name2.substring(0, name2.length() - 1);
                map.put(name1, name2);
            }
            for (int j = 1; j < arrayDepth; ++j) {
                name1 = first.getArrayType(j);
                name2 = second.getArrayType(j);
                map.put(name1, name2);
                if (!renameSignatures || j != 1) continue;
                name1 = name1.replace(';', '<');
                name2 = name2.replace(';', '<');
                map.put(name1, name2);
            }
            if (!renameSource) continue;
            name1 = first.getTypeName();
            if (noRenameSourceForNoPackageClass && name1.indexOf(47) <= 0) continue;
            name1 = first.getSourceName();
            name2 = second.getSourceName();
            map.put(name1, name2);
        }
        return map;
    }

    private Map<String, String> buildSignatureRenameMap() {
        List list = this.sortedList();
        boolean renameSignatures = this.renameSignatures;
        boolean renameSource = this.renameSource;
        boolean noRenameSourceForNoPackageClass = this.noRenameSourceForNoPackageClass;
        int estimatedSize = 1;
        if (renameSignatures) {
            estimatedSize += 2;
        }
        if (renameSource) {
            ++estimatedSize;
        }
        if (this.arrayDepth > 0) {
            estimatedSize = estimatedSize + this.arrayDepth + 1;
        }
        estimatedSize = list.size() * estimatedSize;
        HashMap<String, String> map = new HashMap<String, String>(estimatedSize);
        int size = list.size();
        int arrayDepth = this.arrayDepth + 1;
        for (int i = 0; i < size; ++i) {
            KeyPair keyPair = list.get(i);
            TypeKey first = (TypeKey)keyPair.getFirst();
            TypeKey second = (TypeKey)keyPair.getSecond();
            String name1 = first.getTypeName();
            String name2 = second.getTypeName();
            map.put(name1, name2);
            if (renameSignatures) {
                name1 = first.getTypeName();
                name2 = second.getTypeName();
                name1 = name1.replace(';', '<');
                name2 = name2.replace(';', '<');
                map.put(name1, name2);
                name1 = first.getTypeName();
                name2 = second.getTypeName();
                name1 = name1.substring(0, name1.length() - 1);
                name2 = name2.substring(0, name2.length() - 1);
                map.put(name1, name2);
            }
            for (int j = 1; j < arrayDepth; ++j) {
                name1 = first.getArrayType(j);
                name2 = second.getArrayType(j);
                map.put(name1, name2);
                if (!renameSignatures || j != 1) continue;
                name1 = name1.replace(';', '<');
                name2 = name2.replace(';', '<');
                map.put(name1, name2);
            }
            if (!renameSource) continue;
            name1 = first.getTypeName();
            if (noRenameSourceForNoPackageClass && name1.indexOf(47) <= 0) continue;
            name1 = first.getSourceName();
            name2 = second.getSourceName();
            map.put(name1, name2);
        }
        return map;
    }
}

