/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.pool;

import com.reandroid.dex.data.StringData;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.pool.DataSectionPool;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.sections.StringDataSection;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import java.util.Iterator;

public class StringDataPool
extends DataSectionPool<StringData> {
    public StringDataPool(StringDataSection section) {
        super(section, 0);
    }

    @Override
    public void load() {
    }

    @Override
    public int size() {
        DexSectionPool<StringId> pool = this.getLoadedIdPool();
        if (pool != null) {
            return pool.size();
        }
        return 0;
    }

    @Override
    public StringData get(Key key) {
        return this.getStringData(key);
    }

    @Override
    public Iterator<StringData> getAll(Key key) {
        DexSectionPool<StringId> pool = this.getLoadedIdPool();
        if (pool == null) {
            return EmptyIterator.of();
        }
        return ComputeIterator.of(pool.getAll(key), StringId::getStringData);
    }

    @Override
    public boolean update(Key key) {
        DexSectionPool<StringId> pool = this.getLoadedIdPool();
        if (pool != null) {
            return pool.update(key);
        }
        return false;
    }

    @Override
    public boolean contains(Key key) {
        DexSectionPool<StringId> pool = this.getIdPool();
        if (pool != null) {
            return pool.contains(key);
        }
        return false;
    }

    @Override
    Object getItem(Key key) {
        return this.getStringData(key);
    }

    @Override
    StringDataSection getSection() {
        return (StringDataSection)super.getSection();
    }

    @Override
    boolean isKeyItemsCreate() {
        return false;
    }

    private StringData getStringData(Key key) {
        DexSectionPool<StringId> pool = this.getIdPool();
        if (pool == null) {
            return null;
        }
        StringId stringId = (StringId)pool.get(key);
        if (stringId != null) {
            return stringId.getStringData();
        }
        return null;
    }

    private DexSectionPool<StringId> getIdPool() {
        Section<StringId> section = this.getStringIdSection();
        if (section != null) {
            return section.getPool();
        }
        return null;
    }

    private DexSectionPool<StringId> getLoadedIdPool() {
        Section<StringId> section = this.getStringIdSection();
        if (section != null) {
            return section.getLoadedPool();
        }
        return null;
    }

    private Section<StringId> getStringIdSection() {
        StringDataSection section = this.getSection();
        SectionList sectionList = section.getSectionList();
        if (sectionList != null) {
            return sectionList.getSection(SectionType.STRING_ID);
        }
        return null;
    }
}

