/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.pool;

import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyItem;
import com.reandroid.dex.pool.KeyItemGroup;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class KeyPool<T extends SectionItem> {
    private final SectionType<T> sectionType;
    private Map<Key, Object> itemsMap;

    public KeyPool(SectionType<T> sectionType, int initialSize) {
        this.sectionType = sectionType;
        this.itemsMap = new HashMap<Key, Object>(initialSize);
    }

    public void trimToSize() {
        for (Object obj : this.itemsMap.values()) {
            if (!(obj instanceof KeyItemGroup)) continue;
            ((KeyItemGroup)obj).trimToSize();
        }
    }

    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    public void put(Key key, T item) {
        KeyItemGroup<SectionItem> group;
        if (key == null || item == null) {
            return;
        }
        Object obj = this.getItem(key);
        if (obj == null) {
            this.itemsMap.put(key, item);
            return;
        }
        if (!(obj instanceof KeyItemGroup)) {
            group = new KeyItemGroup<SectionItem>((SectionItem)obj);
            this.itemsMap.remove(key);
            this.itemsMap.put(key, group);
        } else {
            group = (KeyItemGroup<SectionItem>)obj;
        }
        group.add((SectionItem)item);
    }

    public void put(Key key, KeyItemGroup<T> group) {
        if (key != null && group != null) {
            this.itemsMap.put(key, group);
        }
    }

    public int size() {
        return this.itemsMap.size();
    }

    public void clear() {
        this.itemsMap.clear();
    }

    public void reInitialize(int capacity) {
        this.itemsMap.clear();
        this.itemsMap = new HashMap<Key, Object>(capacity);
    }

    void add(T item) {
        KeyItemGroup<SectionItem> group;
        if (item == null) {
            return;
        }
        Key key = ((KeyItem)item).getKey();
        if (key == null) {
            return;
        }
        Object obj = this.getItem(key);
        if (obj == null) {
            this.itemsMap.put(key, item);
            return;
        }
        if (!(obj instanceof KeyItemGroup)) {
            group = new KeyItemGroup<SectionItem>((SectionItem)obj);
            this.itemsMap.put(key, group);
        } else {
            group = (KeyItemGroup<SectionItem>)obj;
        }
        group.add((SectionItem)item);
    }

    public void remove(T item) {
        if (item == null) {
            return;
        }
        Key key = ((KeyItem)item).getKey();
        Object obj = this.getItem(key);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof KeyItemGroup)) {
            this.remove(key);
            return;
        }
        KeyItemGroup group = (KeyItemGroup)obj;
        group.remove(item);
        if (group.isEmpty()) {
            this.remove(key);
        }
    }

    void remove(Key key) {
        if (key == null) {
            return;
        }
        this.itemsMap.remove(key);
    }

    public boolean contains(Key key) {
        return this.itemsMap.containsKey(key);
    }

    public T get(Key key) {
        Object obj = this.getItem(key);
        if (!(obj instanceof KeyItemGroup)) {
            return (T)((SectionItem)obj);
        }
        KeyItemGroup group = (KeyItemGroup)obj;
        return (T)((SectionItem)group.matching(key));
    }

    public Iterator<T> getAll(Key key) {
        Object obj = this.getItem(key);
        if (!(obj instanceof KeyItemGroup)) {
            return SingleIterator.of((SectionItem)obj);
        }
        KeyItemGroup group = (KeyItemGroup)obj;
        return group.iterator();
    }

    public KeyItemGroup<T> getGroup(Key key) {
        if (key == null) {
            return null;
        }
        Object item = this.getItem(key);
        if (item == null) {
            return null;
        }
        if (item instanceof KeyItemGroup) {
            return (KeyItemGroup)item;
        }
        return new KeyItemGroup<SectionItem>((SectionItem)item);
    }

    Object getItem(Key key) {
        return this.itemsMap.get(key);
    }

    Iterator<KeyItemGroup<T>> groupIterator() {
        return ComputeIterator.of(this.itemsMap.values().iterator(), obj -> {
            if (obj instanceof KeyItemGroup) {
                return (KeyItemGroup)obj;
            }
            return null;
        });
    }

    public String toString() {
        return this.getSectionType().getName() + "-Pool = " + this.size();
    }
}

