/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.pool;

import com.reandroid.arsc.base.Block;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyItem;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayCollection;
import java.util.Comparator;
import java.util.Objects;

public class KeyItemGroup<T extends Block>
extends ArrayCollection<T>
implements ArraySupplier<T>,
Comparator<T> {
    private boolean sorted;

    public KeyItemGroup() {
    }

    public KeyItemGroup(T item) {
        super(new Object[]{item});
    }

    public T matching(Key key) {
        int length = this.size();
        if (length == 0) {
            return null;
        }
        Block result = null;
        for (int i = 0; i < length; ++i) {
            Key itemKey;
            int compare;
            Block item = (Block)this.get(i);
            if (result == null) {
                result = item;
            }
            if ((compare = CompareUtil.compare(key, itemKey = ((KeyItem)((Object)item)).getKey())) != 0) continue;
            return (T)item;
        }
        return (T)result;
    }

    public Key getKey() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        Block first = (Block)this.get(0);
        if (first instanceof KeyItem) {
            return ((KeyItem)((Object)first)).getKey();
        }
        return null;
    }

    private void sort() {
        if (this.sorted) {
            return;
        }
        this.sorted = true;
        int size = this.size();
        if (size < 2) {
            return;
        }
        super.sort(this);
        this.sorted = true;
    }

    @Override
    public int compare(T item1, T item2) {
        if (item1 == item2) {
            return 0;
        }
        if (item1 == null) {
            return -1;
        }
        if (item2 == null) {
            return 1;
        }
        int i = CompareUtil.compare(((KeyItem)item1).getKey(), ((KeyItem)item2).getKey());
        if (i != 0) {
            return i;
        }
        return Integer.compare(((Block)item1).getIndex(), ((Block)item2).getIndex());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KeyItemGroup)) {
            return false;
        }
        return Objects.equals(this.getKey(), ((KeyItemGroup)obj).getKey());
    }

    @Override
    public void onChanged() {
        super.onChanged();
        this.sorted = false;
    }

    @Override
    public int hashCode() {
        Key key = this.getKey();
        if (key != null) {
            return 31 * key.hashCode();
        }
        return 0;
    }

    @Override
    public String toString() {
        Key key = this.getKey();
        return this.size() + " {" + key + "}";
    }
}

