/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.pool;

import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyItem;
import com.reandroid.dex.key.KeyItemCreate;
import com.reandroid.dex.pool.KeyItemGroup;
import com.reandroid.dex.pool.KeyPool;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionArray;
import com.reandroid.utils.collection.ArrayCollection;
import java.util.Iterator;

public class DexSectionPool<T extends SectionItem>
extends KeyPool<T> {
    private final Section<T> section;
    private boolean keyItems;
    private boolean keyItemsCreate;
    private boolean keyItemsChecked;

    DexSectionPool(Section<T> section, int initialCapacity) {
        super(section.getSectionType(), initialCapacity);
        this.section = section;
    }

    public DexSectionPool(Section<T> section) {
        this(section, section.getCount());
    }

    @Override
    public void remove(T item) {
        if (this.isKeyItems()) {
            super.remove(item);
        }
    }

    public boolean update(Key key) {
        Object obj = this.getItem(key);
        if (obj == null) {
            return false;
        }
        this.remove((T)key);
        if (!(obj instanceof KeyItemGroup)) {
            SectionItem item = (SectionItem)obj;
            key = ((KeyItem)((Object)item)).getKey();
            this.put(key, item);
            return true;
        }
        KeyItemGroup group = (KeyItemGroup)obj;
        if (group.size() == 0) {
            return false;
        }
        key = group.getKey();
        this.put(key, group);
        return true;
    }

    public T getOrCreate(Key key) {
        if (key == null || !this.isKeyItemsCreate()) {
            return null;
        }
        Object obj = this.getItem(key);
        if (obj != null) {
            if (obj instanceof KeyItemGroup) {
                return (T)((SectionItem)((KeyItemGroup)obj).matching(key));
            }
            return (T)((SectionItem)obj);
        }
        T item = this.createNext(key);
        this.add(item);
        return item;
    }

    public void load() {
        if (!this.isKeyItems()) {
            return;
        }
        Section<T> section = this.getSection();
        SectionArray<T> itemArray = section.getItemArray();
        int length = itemArray.size();
        this.reInitialize(length);
        for (int i = 0; i < length; ++i) {
            this.add((SectionItem)itemArray.get(i));
        }
        this.trimToSize();
    }

    T createNext(Key key) {
        T item = this.getSection().createItem();
        ((KeyItemCreate)item).setKey(key);
        return item;
    }

    Section<T> getSection() {
        return this.section;
    }

    public int clearDuplicates() {
        ArrayCollection result = new ArrayCollection(this.size() / 10);
        Iterator iterator = this.groupIterator();
        while (iterator.hasNext()) {
            this.replaceDuplicates(result, iterator.next());
        }
        Section<SectionItem> section = this.getSection();
        int size = result.size();
        section.removeEntries(item -> {
            int i = result.indexOfFast(item);
            if (i < 0) {
                return false;
            }
            result.remove(i);
            return true;
        });
        result.clear();
        return size;
    }

    private void replaceDuplicates(ArrayCollection<T> result, KeyItemGroup<T> group) {
        int size = group.size();
        if (size < 2) {
            return;
        }
        SectionItem first = (SectionItem)group.getFirst();
        if (first.isRemoved() || first.getReplace() != first) {
            return;
        }
        Iterator iterator = group.iterator(1);
        int start = result.size();
        while (iterator.hasNext()) {
            SectionItem item = (SectionItem)iterator.next();
            if (start < result.size() && result.indexOf(item, start) < 0 || start == result.size() && !first.equalsKey(item)) {
                this.undoSetReplace(result, start);
                return;
            }
            if (item == first) continue;
            item.setReplace(first);
            result.add(item);
        }
    }

    private void undoSetReplace(ArrayCollection<T> result, int start) {
        Iterator<T> iterator = result.iterator(start);
        while (iterator.hasNext()) {
            SectionItem item = (SectionItem)iterator.next();
            item.setReplace(null);
        }
        result.setSize(start);
    }

    boolean isKeyItemsCreate() {
        this.isKeyItems();
        return this.keyItemsCreate;
    }

    private boolean isKeyItems() {
        if (this.keyItemsChecked) {
            return this.keyItems;
        }
        if (this.getSectionType().isIdSection()) {
            this.keyItemsChecked = true;
            this.keyItems = true;
            this.keyItemsCreate = true;
            return true;
        }
        SectionItem sample = (SectionItem)this.getSectionType().getCreator().newInstance();
        this.keyItemsChecked = true;
        this.keyItems = sample instanceof KeyItem;
        this.keyItemsCreate = sample instanceof KeyItemCreate;
        return this.keyItems;
    }
}

