/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexValue;
import com.reandroid.dex.model.RClass;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.IntValue;
import com.reandroid.dex.value.PrimitiveValueBlock;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlSerializer;

public class RField
extends DexField
implements Comparable<RField> {
    public RField(RClass rClass, FieldDef fieldDef) {
        super(rClass, fieldDef);
    }

    public void serializePublicXml(XmlSerializer serializer) throws IOException {
        ResourceEntry resourceEntry = this.toResourceEntry();
        resourceEntry.serializePublicXml(serializer);
    }

    public String toJavaDeclare() {
        return this.toJavaDeclare(true);
    }

    public String toJavaDeclare(boolean makeFinal) {
        String name = this.getName();
        StringBuilder builder = new StringBuilder(38 + name.length());
        builder.append("public static ");
        if (makeFinal) {
            builder.append("int ");
        }
        builder.append(this.getName());
        builder.append(" = ");
        builder.append(HexUtil.toHex8(this.getResourceId()));
        builder.append(';');
        return builder.toString();
    }

    public ResourceEntry toResourceEntry() {
        return new DexResourceEntry(this);
    }

    public int getResourceId() {
        DexValue dexValue = this.getInitialValue();
        if (dexValue != null) {
            return dexValue.getAsInteger();
        }
        return 0;
    }

    public void setResourceId(int resourceId) {
        IntValue dexValue = this.getOrCreateInitialValue(DexValueType.INT);
        dexValue.set(resourceId);
    }

    public String getResourceName() {
        String name = this.getName();
        if (TypeString.isTypeStyle(this.getResourceType())) {
            name = RField.toStyleResourceName(name);
        }
        return name;
    }

    public String getResourceType() {
        return this.getDexClass().getResourceType();
    }

    @Override
    public RClass getDexClass() {
        return (RClass)super.getDexClass();
    }

    @Override
    public int compareTo(RField rField) {
        if (rField == null) {
            return -1;
        }
        return Integer.compare(this.getResourceId(), rField.getResourceId());
    }

    @Override
    public int hashCode() {
        return this.getResourceId();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RField rField = (RField)obj;
        return this.getResourceId() == rField.getResourceId();
    }

    @Override
    public String toString() {
        return this.toJavaDeclare();
    }

    static boolean isResourceIdValue(DexValueBlock<?> dexValueBlock) {
        if (dexValueBlock instanceof PrimitiveValueBlock) {
            long value = ((PrimitiveValueBlock)dexValueBlock).getNumberValue();
            if ((value & 0xFFFFFFFF00000000L) != 0L) {
                return false;
            }
            return PackageBlock.isResourceId((int)value);
        }
        return false;
    }

    public static String toStyleResourceName(String fieldName) {
        int length = fieldName.length();
        if (length < 3 || fieldName.indexOf(95) < 0) {
            return fieldName;
        }
        StringBuilder builder = new StringBuilder(length);
        --length;
        for (int i = 0; i < length; ++i) {
            char next;
            int ch = fieldName.charAt(i);
            if (ch == 95 && (next = fieldName.charAt(i + 1)) <= 'Z' && next >= 'A') {
                ch = 46;
            }
            builder.append((char)ch);
        }
        builder.append(fieldName.charAt(length));
        return builder.toString();
    }

    public static String sanitizeResourceName(String resourceName) {
        if (resourceName.charAt(0) == '$') {
            resourceName = resourceName.substring(1);
        }
        resourceName = resourceName.replace('.', '_');
        return resourceName;
    }

    public static Map<Integer, RField> mapRFields(Iterator<RField> iterator) {
        HashMap<Integer, RField> map = new HashMap<Integer, RField>();
        while (iterator.hasNext()) {
            RField rField = iterator.next();
            map.put(rField.getResourceId(), rField);
        }
        return map;
    }

    public static class DexResourceEntry
    extends ResourceEntry {
        private final RField rField;

        public DexResourceEntry(RField rField) {
            super(RClass.EMPTY_TABLE.pickOrEmptyPackage(), rField.getResourceId());
            this.rField = rField;
        }

        @Override
        public String getType() {
            return this.rField.getResourceType();
        }

        @Override
        public String getName() {
            return this.getRField().getResourceName();
        }

        @Override
        public int getResourceId() {
            return this.getRField().getResourceId();
        }

        @Override
        public PackageBlock getPackageBlock() {
            return RClass.EMPTY_TABLE.pickOrEmptyPackage();
        }

        @Override
        public String getPackageName() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<Entry> iterator(boolean skipNull) {
            return EmptyIterator.of();
        }

        @Override
        public Iterator<Entry> iterator(Predicate<Entry> filter) {
            return EmptyIterator.of();
        }

        public RField getRField() {
            return this.rField;
        }
    }
}

