/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.ins.Ins35c;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.RClass;
import com.reandroid.dex.model.RField;
import com.reandroid.dex.value.ArrayValue;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.TypeValue;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.io.IOUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlSerializer;

public class RClassParent
extends DexClass {
    private final Map<String, RClass> mMembers = new HashMap<String, RClass>();
    private final Set<PackageBlock> mPackageBlocks = new HashSet<PackageBlock>();
    private static final String SIMPLE_NAME_PREFIX = "R";

    public RClassParent(DexFile dexFile, ClassId classId) {
        super(dexFile, classId);
    }

    public RField getRField(int resourceId) {
        return this.load(this.getEntry(resourceId));
    }

    public boolean hasRField(int resourceId) {
        return this.getEntry(resourceId) != null;
    }

    private ResourceEntry getEntry(int resourceId) {
        for (PackageBlock packageBlock : this.mPackageBlocks) {
            ResourceEntry entry = packageBlock.getResource(resourceId);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public void load(PackageBlock packageBlock) {
        this.mPackageBlocks.add(packageBlock);
    }

    private RField load(ResourceEntry entry) {
        if (entry == null || entry.isEmpty()) {
            return null;
        }
        RClass rClass = this.getOrCreateMember(entry.getType());
        return rClass.load(entry);
    }

    public RClass getOrCreateMember(String simpleName) {
        TypeKey typeKey = this.getKey().createInnerClass(simpleName);
        RClass rClass = this.mMembers.get(typeKey.getTypeName());
        if (rClass != null) {
            return rClass;
        }
        this.addMemberAnnotation(simpleName);
        ClassId classId = this.getDexFile().getOrCreateClassId(typeKey);
        rClass = new RClass(this.getDexFile(), classId);
        this.mMembers.put(typeKey.getTypeName(), rClass);
        rClass.initialize();
        return rClass;
    }

    public void addMemberAnnotation(String simpleName) {
        ArrayValue arrayValue = this.getOrCreateMembersArray();
        Iterator<String> iterator = FilterIterator.of(this.getMemberSimpleNames(), simpleName::equals);
        if (iterator.hasNext()) {
            return;
        }
        TypeValue typeValue = arrayValue.createNext(DexValueType.TYPE);
        typeValue.setItem(this.getKey().createInnerClass(simpleName));
    }

    public Iterator<String> getMemberSimpleNames() {
        return ComputeIterator.of(this.getMemberNames(), DexUtils::getSimpleInnerName);
    }

    public Iterator<String> getMemberNames() {
        ArrayValue arrayValue = this.getOrCreateMembersArray();
        return ComputeIterator.of(arrayValue.iterator(TypeValue.class), typeValue -> this.getKey().getTypeName());
    }

    private ArrayValue getOrCreateMembersArray() {
        AnnotationItem item = this.getOrCreateMemberAnnotation();
        AnnotationElement element = item.getElement("value");
        ArrayValue value = element.getValue();
        if (value == null) {
            ArrayValue array = (ArrayValue)DexValueType.ARRAY.newInstance();
            element.setValue(array);
            value = array;
        }
        return value;
    }

    private AnnotationItem getOrCreateMemberAnnotation() {
        String name;
        AnnotationSet annotationSet = this.getOrCreateClassAnnotations();
        AnnotationItem item = annotationSet.getOrCreate("Ldalvik/annotation/MemberClasses;", name = "value");
        AnnotationElement element = item.getElement(name);
        if (element.getValueType() == DexValueType.ARRAY) {
            return item;
        }
        item.setVisibility(AnnotationVisibility.SYSTEM);
        ArrayValue array = (ArrayValue)DexValueType.ARRAY.newInstance();
        element.setValue(array);
        return item;
    }

    private AnnotationSet getOrCreateClassAnnotations() {
        AnnotationSet annotationSet = this.getClassAnnotations();
        if (annotationSet != null) {
            return annotationSet;
        }
        annotationSet = this.getId().getOrCreateClassAnnotations();
        return annotationSet;
    }

    private AnnotationSet getClassAnnotations() {
        return this.getId().getClassAnnotations();
    }

    public void initialize() {
        ClassId classId = this.getId();
        classId.addAccessFlag(AccessFlag.PUBLIC);
        ClassData classData = classId.getOrCreateClassData();
        MethodKey methodKey = new MethodKey(classId.getName(), "<init>", null, "V");
        if (classData.getMethod(methodKey) != null) {
            return;
        }
        MethodDef methodDef = classData.getOrCreateDirect(methodKey);
        methodDef.addAccessFlag(AccessFlag.PUBLIC);
        methodDef.addAccessFlag(AccessFlag.CONSTRUCTOR);
        InstructionList insList = methodDef.getOrCreateInstructionList();
        Ins35c ins = insList.createNext(Opcode.INVOKE_DIRECT);
        ins.setSectionIdKey(MethodKey.parse("Ljava/lang/Object;-><init>()V"));
        ins.setRegistersCount(1);
        ins.setRegister(0, 0);
        insList.createNext(Opcode.RETURN_VOID);
    }

    static boolean isRParentClassName(ClassId classId) {
        if (classId != null) {
            return RClassParent.isRParentClassName(classId.getName());
        }
        return false;
    }

    static boolean isRParentClassName(String name) {
        if (name == null) {
            return false;
        }
        return SIMPLE_NAME_PREFIX.equals(DexUtils.getSimpleName(name));
    }

    public static void serializePublicXml(Collection<RField> rFields, XmlSerializer serializer) throws IOException {
        serializer.startDocument("utf-8", null);
        serializer.text("\n");
        serializer.startTag(null, PackageBlock.TAG_resources);
        ArrayCollection fieldList = new ArrayCollection();
        fieldList.addAll(rFields);
        fieldList.sort(CompareUtil.getComparableComparator());
        for (RField rField : fieldList) {
            rField.serializePublicXml(serializer);
        }
        serializer.text("\n");
        serializer.endTag(null, PackageBlock.TAG_resources);
        serializer.endDocument();
        serializer.flush();
        IOUtil.close(serializer);
    }
}

