/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexAnnotation;
import com.reandroid.dex.model.DexValue;
import com.reandroid.dex.value.ArrayValue;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Comparator;
import java.util.Iterator;

public class DexValueArray
extends DexValue
implements Iterable<DexValue> {
    public DexValueArray(Dex declaring, ArrayValue arrayValue) {
        super(declaring, arrayValue);
    }

    @Override
    public Iterator<DexValue> iterator() {
        return ComputeIterator.of(this.getDexValueBlock().iterator(), valueBlock -> DexValue.create(this, valueBlock));
    }

    public Iterator<DexValue> clonedIterator() {
        return ComputeIterator.of(this.getDexValueBlock().clonedIterator(), valueBlock -> DexValueArray.create(this, valueBlock));
    }

    public DexValue get(int index) {
        return DexValue.create(this.getDeclaring(), this.getDexValueBlock().get(index));
    }

    public int size() {
        return this.getDexValueBlock().size();
    }

    public boolean remove(int index) {
        return this.getDexValueBlock().remove(index);
    }

    public boolean remove(DexValue dexValue) {
        if (dexValue == null) {
            return false;
        }
        return this.getDexValueBlock().remove(dexValue.getDexValueBlock());
    }

    public void clear() {
        this.getDexValueBlock().clear();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean sort(Comparator<DexValue> comparator) {
        Comparator valueComparator = (value1, value2) -> comparator.compare(DexValueArray.create(this, value1), DexValueArray.create(this, value2));
        return this.getDexValueBlock().sort(valueComparator);
    }

    public boolean isFirstType(DexValueType<?> valueType) {
        return valueType != null && valueType == this.getFirstType();
    }

    public DexValueType<?> getFirstType() {
        DexValueBlock<?> valueBlock = this.getDexValueBlock().get(0);
        if (valueBlock != null) {
            return valueBlock.getValueType();
        }
        return null;
    }

    public DexValue createNext(DexValueType<?> valueType) {
        return DexValue.create(this, this.getDexValueBlock().createNext(valueType));
    }

    public Iterator<String> getStrings() {
        return ComputeIterator.of(this.iterator(), DexValue::getString);
    }

    public Iterator<TypeKey> getTypeKeys() {
        return ComputeIterator.of(this.iterator(), DexValue::getTypeKey);
    }

    public Iterator<Number> getNumbers() {
        return ComputeIterator.of(this.iterator(), DexValue::getNumber);
    }

    public Iterator<Character> getCharacters() {
        return ComputeIterator.of(this.iterator(), DexValue::getCharacter);
    }

    public Iterator<Integer> getIntegers() {
        return ComputeIterator.of(this.iterator(), DexValue::getInteger);
    }

    public Iterator<Key> getKeys() {
        return ComputeIterator.of(this.iterator(), DexValue::getKey);
    }

    public Iterator<DexAnnotation> getAnnotations() {
        return ComputeIterator.of(this.iterator(), DexValue::getAnnotation);
    }

    public void add(String str) {
        this.createNext(DexValueType.STRING).setString(str);
    }

    public void add(Key key) {
        if (key instanceof TypeKey) {
            this.createNext(DexValueType.TYPE).setKey(key);
        } else if (key instanceof FieldKey) {
            this.createNext(DexValueType.ENUM).setKey(key);
        } else if (key instanceof MethodKey) {
            this.createNext(DexValueType.METHOD).setKey(key);
        } else {
            throw new RuntimeException("Unimplemented key-type: " + key.getClass());
        }
    }

    public void add(byte b) {
        this.createNext(DexValueType.BYTE).setByte(b);
    }

    public void add(short s) {
        this.createNext(DexValueType.SHORT).setShort(s);
    }

    public void add(int i) {
        this.createNext(DexValueType.INT).setInteger(i);
    }

    public void add(float f) {
        this.createNext(DexValueType.FLOAT).setFloat(f);
    }

    public void add(long l) {
        this.createNext(DexValueType.LONG).setLong(l);
    }

    public void add(double d) {
        this.createNext(DexValueType.DOUBLE).setDouble(d);
    }

    public void add(char c) {
        this.createNext(DexValueType.CHAR).setCharacter(c);
    }

    public ArrayValue getDexValueBlock() {
        return (ArrayValue)super.getDexValueBlock();
    }
}

