/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexAnnotation;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexValueArray;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.value.AnnotationValue;
import com.reandroid.dex.value.ArrayValue;
import com.reandroid.dex.value.ByteValue;
import com.reandroid.dex.value.CharValue;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.DoubleValue;
import com.reandroid.dex.value.FloatValue;
import com.reandroid.dex.value.IntValue;
import com.reandroid.dex.value.LongValue;
import com.reandroid.dex.value.PrimitiveValueBlock;
import com.reandroid.dex.value.SectionValue;
import com.reandroid.dex.value.ShortValue;
import com.reandroid.dex.value.StringValue;
import com.reandroid.dex.value.TypeValue;
import java.io.IOException;

public class DexValue
extends Dex {
    private final Dex declaring;
    private final DexValueBlock<?> dexValueBlock;

    public DexValue(Dex declaring, DexValueBlock<?> dexValueBlock) {
        this.declaring = declaring;
        this.dexValueBlock = dexValueBlock;
    }

    public Key getKey() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof SectionValue) {
            return ((SectionValue)value).getKey();
        }
        return null;
    }

    public void setKey(Key key) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof SectionValue) {
            ((SectionValue)value).setItem(key);
        }
    }

    public TypeKey getTypeKey() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof TypeValue) {
            return ((TypeValue)value).getKey();
        }
        return null;
    }

    public String getString() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof StringValue) {
            return ((StringValue)value).getString();
        }
        return null;
    }

    public void setString(String str) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof StringValue) {
            ((StringValue)value).setString(str);
        }
    }

    public Integer getInteger() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof IntValue) {
            return ((IntValue)value).get();
        }
        return null;
    }

    public void setInteger(int i) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof IntValue) {
            ((IntValue)value).set(i);
        }
    }

    public Byte getByte() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof ByteValue) {
            return ((ByteValue)value).get();
        }
        return null;
    }

    public void setByte(byte b) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof ByteValue) {
            ((ByteValue)value).set(b);
        }
    }

    public Short getShort() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof ShortValue) {
            return ((ShortValue)value).get();
        }
        return null;
    }

    public void setShort(short s) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof ShortValue) {
            ((ShortValue)value).set(s);
        }
    }

    public Character getCharacter() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof CharValue) {
            return Character.valueOf(((CharValue)value).get());
        }
        return null;
    }

    public void setCharacter(char c) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof CharValue) {
            ((CharValue)value).set(c);
        }
    }

    public Long getLong() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof LongValue) {
            return ((LongValue)value).get();
        }
        return null;
    }

    public void setLong(long l) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof LongValue) {
            ((LongValue)value).set(l);
        }
    }

    public Double getDouble() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof DoubleValue) {
            return ((DoubleValue)value).get();
        }
        return null;
    }

    public void setDouble(double d) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof DoubleValue) {
            ((DoubleValue)value).set(d);
        }
    }

    public Float getFloat() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof FloatValue) {
            return Float.valueOf(((FloatValue)value).get());
        }
        return null;
    }

    public void setFloat(float f) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof FloatValue) {
            ((FloatValue)value).set(f);
        }
    }

    public Number getNumber() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof PrimitiveValueBlock) {
            return ((PrimitiveValueBlock)value).getData();
        }
        return null;
    }

    public void setNumber(Number number) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof PrimitiveValueBlock) {
            ((PrimitiveValueBlock)value).setData(number);
        }
    }

    public Object getData() {
        return this.getDexValueBlock().getData();
    }

    public void setData(Object data) {
        this.getDexValueBlock().setData(data);
    }

    public DexAnnotation getAnnotation() {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof AnnotationValue) {
            AnnotationValue annotationValue = (AnnotationValue)value;
            return DexAnnotation.create(this.getDeclaring(), annotationValue.get());
        }
        return null;
    }

    public String getAsString() {
        return this.getDexValueBlock().getAsString();
    }

    public int getAsInteger() {
        return this.getAsInteger(0);
    }

    public int getAsInteger(int def) {
        DexValueBlock<?> value = this.getDexValueBlock();
        if (value instanceof PrimitiveValueBlock) {
            return (int)((PrimitiveValueBlock)value).getNumberValue();
        }
        return def;
    }

    public DexValueType<?> getValueType() {
        return this.getDexValueBlock().getValueType();
    }

    public DexValueBlock<?> getDexValueBlock() {
        return this.dexValueBlock;
    }

    public Dex getDeclaring() {
        return this.declaring;
    }

    @Override
    public boolean uses(Key key) {
        Key valueKey = this.getKey();
        if (valueKey != null) {
            return valueKey.uses(key);
        }
        return false;
    }

    @Override
    public DexClassRepository getClassRepository() {
        return this.getDeclaring().getClassRepository();
    }

    public int getIndex() {
        return this.getDexValueBlock().getIndex();
    }

    public boolean is(DexValueType<?> valueType) {
        return this.getValueType() == valueType;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getDexValueBlock().append(writer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DexValue dexValue = (DexValue)obj;
        return this.getDexValueBlock() == dexValue.getDexValueBlock();
    }

    public int hashCode() {
        return this.getDexValueBlock().hashCode();
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    public static DexValue create(Dex declaring, DexValueBlock<?> valueBlock) {
        if (declaring != null && valueBlock != null) {
            if (valueBlock instanceof ArrayValue) {
                return new DexValueArray(declaring, (ArrayValue)valueBlock);
            }
            return new DexValue(declaring, valueBlock);
        }
        return null;
    }
}

