/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.archive.ByteInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.dex.model.DexFile;
import com.reandroid.utils.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface DexSource<T>
extends Comparable<DexSource<?>>,
Closeable {
    public String getName();

    public InputStream openStream() throws IOException;

    public void write(byte[] var1) throws IOException;

    public boolean delete();

    public T get();

    public void set(T var1);

    @Override
    public void close() throws IOException;

    public boolean isClosed();

    default public int getDexFileNumber() {
        return DexFile.getDexFileNumber(this.getName());
    }

    default public String getSimpleName() {
        String name = this.getName();
        int i = name.lastIndexOf(47);
        if (i < 0) {
            i = name.lastIndexOf(92);
        }
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        return name;
    }

    default public DexSource<T> createNext() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    default public int compareTo(DexSource<?> dexSource) {
        return Integer.compare(this.getDexFileNumber(), dexSource.getDexFileNumber());
    }

    public static <T> DexSource<T> create(ZipEntryMap zipEntryMap, String name) {
        return new ZipDexSource(zipEntryMap, name);
    }

    public static <T> DexSource<T> create(File file) {
        return new FileDexSource(file);
    }

    public static class ZipDexSource<T>
    extends DexSourceImpl<T> {
        private final ZipEntryMap zipEntryMap;
        private final String name;

        public ZipDexSource(ZipEntryMap zipEntryMap, String name) {
            this.zipEntryMap = zipEntryMap;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        boolean onDelete() {
            if (this.isClosed()) {
                return false;
            }
            this.zipEntryMap.remove(this.getName());
            return true;
        }

        @Override
        public InputStream openStream() throws IOException {
            if (this.isClosed()) {
                throw new IOException("Closed: " + this.getName());
            }
            InputSource inputSource = this.zipEntryMap.getInputSource(this.getName());
            if (inputSource == null) {
                throw new IOException("Zip input source not found: " + this.getName());
            }
            return inputSource.openStream();
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            if (this.isClosed()) {
                throw new IOException("Closed: " + this.getName());
            }
            ByteInputSource inputSource = new ByteInputSource(bytes, this.getName());
            this.zipEntryMap.add(inputSource);
        }

        @Override
        public ZipDexSource<T> createNext() {
            if (this.isClosed()) {
                return null;
            }
            int index = this.getDexFileNumber() + 1;
            String name = this.getPath(index);
            ZipEntryMap zipEntryMap = this.zipEntryMap;
            while (zipEntryMap.contains(name)) {
                name = this.getPath(++index);
            }
            return new ZipDexSource<T>(zipEntryMap, name);
        }

        private String getPath(int index) {
            return FileUtil.combineUnixPath(FileUtil.getParent(this.getName()), DexFile.getDexName(index));
        }

        @Override
        public String toString() {
            return this.zipEntryMap.getModuleName() + ":/" + this.getSimpleName();
        }
    }

    public static class FileDexSource<T>
    extends DexSourceImpl<T> {
        private final File file;

        public FileDexSource(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public String getSimpleName() {
            return this.getFile().getName();
        }

        @Override
        public String getName() {
            return this.getFile().getAbsolutePath();
        }

        @Override
        boolean onDelete() {
            if (this.isClosed()) {
                return false;
            }
            File file = this.getFile();
            if (file.isFile()) {
                return file.delete();
            }
            return true;
        }

        @Override
        public InputStream openStream() throws IOException {
            if (this.isClosed()) {
                throw new IOException("Closed: " + this.getName());
            }
            return new FileInputStream(this.getFile());
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            if (this.isClosed()) {
                throw new IOException("Closed: " + this.getName());
            }
            OutputStream outputStream = FileUtil.outputStream(this.getFile());
            outputStream.write(bytes, 0, bytes.length);
            outputStream.close();
        }

        @Override
        public FileDexSource<T> createNext() {
            if (this.isClosed()) {
                return null;
            }
            int index = this.getDexFileNumber() + 1;
            File file = this.getFile(index);
            while (file.isFile()) {
                file = this.getFile(++index);
            }
            return new FileDexSource<T>(file);
        }

        private File getFile(int dexIndex) {
            String name = DexFile.getDexName(dexIndex);
            File dir = this.getFile().getParentFile();
            File file = dir == null ? new File(name) : new File(dir, name);
            return file;
        }
    }

    public static abstract class DexSourceImpl<T>
    implements DexSource<T> {
        private T item;
        private boolean closed;

        @Override
        public T get() {
            return this.item;
        }

        @Override
        public void set(T item) {
            if (this.isClosed()) {
                return;
            }
            this.item = item;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            T item = this.item;
            this.item = null;
            if (item instanceof Closeable) {
                ((Closeable)item).close();
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean delete() {
            this.set(null);
            return this.onDelete();
        }

        abstract boolean onDelete();

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DexSource)) {
                return false;
            }
            DexSource dexSource = (DexSource)obj;
            return this.getDexFileNumber() == dexSource.getDexFileNumber();
        }

        public int hashCode() {
            return this.getDexFileNumber();
        }

        public String toString() {
            return this.getSimpleName();
        }
    }
}

