/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.AnnotatedDex;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexAnnotation;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.Iterator;

public class DexMethodParameter
extends Dex
implements AnnotatedDex {
    private final DexMethod dexMethod;
    private final MethodDef.Parameter parameter;

    public DexMethodParameter(DexMethod dexMethod, MethodDef.Parameter parameter) {
        this.dexMethod = dexMethod;
        this.parameter = parameter;
    }

    @Override
    public Iterator<DexAnnotation> getAnnotations() {
        return ComputeIterator.of(this.getParameter().getAnnotationItems(), annotationItem -> DexAnnotation.create(this, annotationItem));
    }

    @Override
    public Iterator<DexAnnotation> getAnnotations(TypeKey typeKey) {
        return FilterIterator.of(this.getAnnotations(), dexAnnotation -> typeKey.equals(dexAnnotation.getType()));
    }

    @Override
    public DexAnnotation getAnnotation(TypeKey typeKey) {
        return CollectionUtil.getFirst(this.getAnnotations(typeKey));
    }

    @Override
    public DexAnnotation getOrCreateAnnotation(TypeKey typeKey) {
        return DexAnnotation.create(this, this.getParameter().getOrCreateAnnotationItem(typeKey));
    }

    @Override
    public DexAnnotation newAnnotation(TypeKey typeKey) {
        return DexAnnotation.create(this, this.getParameter().addAnnotationItem(typeKey));
    }

    public String getDebugName() {
        return this.getParameter().getDebugName();
    }

    public void removeDebugName() {
        this.getParameter().setDebugName(null);
    }

    public void setDebugName(String name) {
        this.getParameter().setDebugName(name);
    }

    public void clearAnnotations() {
        this.getParameter().clearAnnotations();
    }

    public DexClass getTypeClass() {
        return this.getClassRepository().getDexClass(this.getType());
    }

    public TypeKey getType() {
        return this.getParameter().getType();
    }

    public int getIndex() {
        return this.getParameter().getDefinitionIndex();
    }

    public DexMethod getDexMethod() {
        return this.dexMethod;
    }

    public MethodDef.Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public boolean uses(Key key) {
        if (ObjectsUtil.equals(this.getType(), key)) {
            return true;
        }
        Iterator<DexAnnotation> iterator = this.getAnnotations();
        while (iterator.hasNext()) {
            DexAnnotation dexAnnotation = iterator.next();
            if (!dexAnnotation.uses(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DexClassRepository getClassRepository() {
        return this.getDexMethod().getClassRepository();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getParameter().append(writer);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.PARAMETER;
    }

    public static DexMethodParameter create(DexMethod dexMethod, MethodDef.Parameter parameter) {
        if (dexMethod != null && parameter != null) {
            return new DexMethodParameter(dexMethod, parameter);
        }
        return null;
    }
}

