/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.TryBlock;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexAnnotation;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMethodParameter;
import com.reandroid.dex.model.DexTry;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.EmptyList;
import com.reandroid.utils.collection.ExpandIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.MergingIterator;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class DexMethod
extends DexDeclaration {
    private final DexClass dexClass;
    private final MethodDef methodDef;

    public DexMethod(DexClass dexClass, MethodDef methodDef) {
        this.dexClass = dexClass;
        this.methodDef = methodDef;
    }

    public DexMethod getDeclared() {
        DexMethod dexMethod;
        DexClass dexClass = this.getDexClass().getSuperClass();
        if (dexClass != null && (dexMethod = dexClass.getMethod(this.getKey())) != null) {
            return dexMethod.getDeclared();
        }
        dexClass = this.getDexClass();
        Iterator<DexClass> iterator = dexClass.getInterfaceClasses();
        while (iterator.hasNext()) {
            dexClass = iterator.next();
            DexMethod dexMethod2 = dexClass.getMethod(this.getKey());
            if (dexMethod2 == null) continue;
            return dexMethod2.getDeclared();
        }
        return this;
    }

    public Iterator<DexMethod> getSuperMethods() {
        MethodKey key = this.getKey();
        return ComputeIterator.of(this.getDexClass().getSuperTypes(), dexClass -> dexClass.getDeclaredMethod(key));
    }

    public Iterator<DexMethod> getOverriding() {
        return CombiningIterator.two(this.getExtending(), this.getImplementations());
    }

    public DexMethod getBridged() {
        if (!this.isBridge()) {
            return null;
        }
        MethodKey bridgedKey = null;
        Iterator<DexInstruction> iterator = this.getInstructions();
        while (iterator.hasNext()) {
            DexInstruction instruction = iterator.next();
            Key key = instruction.getKey();
            if (!(key instanceof MethodKey)) continue;
            MethodKey methodKey = (MethodKey)key;
            if (bridgedKey != null) {
                return null;
            }
            bridgedKey = methodKey;
        }
        if (bridgedKey == null) {
            return null;
        }
        if (!this.getDefining().equals(bridgedKey.getDeclaring())) {
            return null;
        }
        if (!this.getName().equals(bridgedKey.getName())) {
            return null;
        }
        DexClass dexClass = this.getDexClass();
        dexClass.addAccessFlag(AccessFlag.SYNTHETIC);
        return dexClass.getDeclaredMethod(bridgedKey);
    }

    public Iterator<DexMethod> getExtending() {
        return new MergingIterator<DexMethod>(ComputeIterator.of(this.getDexClass().getExtending(), dexClass -> dexClass.getExtending(this.getKey())));
    }

    public Iterator<DexMethod> getImplementations() {
        return new MergingIterator<DexMethod>(ComputeIterator.of(this.getDexClass().getImplementations(), dexClass -> dexClass.getImplementations(this.getKey())));
    }

    public Iterator<MethodKey> getOverridingKeys() {
        return new MergingIterator<MethodKey>(ComputeIterator.of(this.getDexClass().getOverriding(), dexClass -> dexClass.getOverridingKeys(this.getKey())));
    }

    public String getName() {
        return this.getDefinition().getName();
    }

    public void setName(String name) {
        this.getDefinition().setName(name);
    }

    @Override
    public Iterator<DexAnnotation> getAnnotations() {
        return ComputeIterator.of(ExpandIterator.of(this.getDefinition().getAnnotations()), annotationItem -> DexAnnotation.create(this, annotationItem));
    }

    @Override
    public Iterator<DexAnnotation> getAnnotations(TypeKey typeKey) {
        return FilterIterator.of(this.getAnnotations(), item -> typeKey.equals(item.getType()));
    }

    @Override
    public DexAnnotation getAnnotation(TypeKey typeKey) {
        return CollectionUtil.getFirst(this.getAnnotations(typeKey));
    }

    @Override
    public DexAnnotation getOrCreateAnnotation(TypeKey typeKey) {
        return DexAnnotation.create(this, this.getDefinition().getOrCreateAnnotationSet().getOrCreate(typeKey));
    }

    @Override
    public DexAnnotation newAnnotation(TypeKey typeKey) {
        return DexAnnotation.create(this, this.getDefinition().getOrCreateAnnotationSet().addNewItem(typeKey));
    }

    public Iterator<DexInstruction> getInstructions(Opcode<?> opcode) {
        return this.getInstructions((? super Ins ins) -> ins.getOpcode() == opcode);
    }

    public Iterator<DexInstruction> getInstructions(Predicate<? super Ins> filter) {
        Iterator<? super Ins> iterator = FilterIterator.of(this.getDefinition().getInstructions(), filter);
        return ComputeIterator.of(iterator, this::create);
    }

    public Iterator<DexInstruction> getInstructions() {
        return DexInstruction.create(this, this.getDefinition().getInstructions());
    }

    public void clearCode() {
        this.getDefinition().clearCode();
    }

    public void clearDebug() {
        this.getDefinition().clearDebug();
    }

    public Iterator<DexTry> getDexTry() {
        TryBlock tryBlock = this.getDefinition().getTryBlock();
        if (tryBlock == null) {
            return EmptyIterator.of();
        }
        return DexTry.create(this, tryBlock.iterator());
    }

    public DexTry createDexTry() {
        TryBlock tryBlock = this.getDefinition().getOrCreateTryBlock();
        return DexTry.create(this, tryBlock.createNext());
    }

    public DexInstruction getInstruction(int i) {
        return this.create(this.getDefinition().getInstruction(i));
    }

    public DexInstruction getInstructionAt(int address) {
        return this.create(this.getDefinition().getInstructionAt(address));
    }

    public DexInstruction addInstruction(Opcode<?> opcode) {
        return this.create((Ins)this.getDefinition().getOrCreateInstructionList().createNext(opcode));
    }

    public DexInstruction parseInstruction(String smaliString) throws IOException {
        return this.parseInstruction(SmaliReader.of(smaliString));
    }

    public DexInstruction parseInstruction(SmaliReader reader) throws IOException {
        int index = this.getInstructionsCount();
        return this.parseInstruction(index, reader);
    }

    public DexInstruction parseInstruction(int index, SmaliReader reader) throws IOException {
        SmaliInstruction smaliInstruction = new SmaliInstruction();
        smaliInstruction.parse(reader);
        InstructionList instructionList = this.getDefinition().getOrCreateInstructionList();
        Object ins = instructionList.createAt(index, smaliInstruction.getOpcode());
        ((Ins)ins).fromSmali(smaliInstruction);
        return this.create((Ins)ins);
    }

    public DexInstruction createInstruction(int index, Opcode<?> opcode) {
        return this.create((Ins)this.getDefinition().getOrCreateInstructionList().createAt(index, opcode));
    }

    public int getInstructionsCount() {
        return this.getDefinition().getInstructionsCount();
    }

    public RegistersTable getRegistersTable() {
        return this.getDefinition().getCodeItem();
    }

    public RegistersTable getOrCreateRegistersTable() {
        return this.getDefinition().getOrCreateCodeItem();
    }

    public List<Register> getLocalFreeRegisters(int instructionIndex) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.getLocalFreeRegisters(instructionIndex);
        }
        return EmptyList.of();
    }

    public void ensureLocalRegistersCount(int locals) {
        if (locals == 0) {
            return;
        }
        RegistersTable registersTable = this.getRegistersTable();
        if (registersTable != null && locals <= registersTable.getLocalRegistersCount()) {
            return;
        }
        registersTable = this.getOrCreateRegistersTable();
        registersTable.ensureLocalRegistersCount(locals);
    }

    public int refreshParameterRegistersCount() {
        RegistersTable registersTable = this.getRegistersTable();
        if (registersTable == null) {
            return 0;
        }
        int parameterCount = this.getKey().getParameterRegistersCount();
        if (!this.isStatic()) {
            ++parameterCount;
        }
        int locals = registersTable.getLocalRegistersCount();
        registersTable.setParameterRegistersCount(parameterCount);
        registersTable.setRegistersCount(locals + parameterCount);
        return parameterCount;
    }

    private InstructionList getInstructionList() {
        return this.getDefinition().getInstructionList();
    }

    public int getLocalRegistersCount() {
        RegistersTable registersTable = this.getRegistersTable();
        if (registersTable != null) {
            return registersTable.getLocalRegistersCount();
        }
        return 0;
    }

    public void setParameterRegistersCount(int count) {
        CodeItem codeItem = this.getDefinition().getOrCreateCodeItem();
        if (codeItem != null) {
            codeItem.setParameterRegistersCount(count);
        }
    }

    public void setLocalRegistersCount(int count) {
        CodeItem codeItem = this.getDefinition().getOrCreateCodeItem();
        if (codeItem != null) {
            codeItem.setRegistersCount(codeItem.getParameterRegistersCount() + count);
        }
    }

    private DexInstruction create(Ins ins) {
        return DexInstruction.create(this, ins);
    }

    @Override
    public MethodKey getKey() {
        return this.getId().getKey();
    }

    @Override
    public MethodId getId() {
        return (MethodId)this.getDefinition().getId();
    }

    @Override
    public DexClass getDexClass() {
        return this.dexClass;
    }

    public MethodDef getDefinition() {
        return this.methodDef;
    }

    public boolean isConstructor() {
        return AccessFlag.CONSTRUCTOR.isSet(this.getAccessFlagsValue());
    }

    public boolean isBridge() {
        return AccessFlag.BRIDGE.isSet(this.getAccessFlagsValue());
    }

    public boolean isDirect() {
        return this.isConstructor() || this.isPrivate() || this.isStatic();
    }

    public Iterator<DexMethodParameter> getParameters() {
        return ComputeIterator.of(this.getDefinition().getParameters(), parameter -> DexMethodParameter.create(this, parameter));
    }

    @Override
    public void removeSelf() {
        this.getDefinition().removeSelf();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getDefinition().append(writer);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.METHOD;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DexMethod dexMethod = (DexMethod)obj;
        return MethodId.equals(true, this.getId(), dexMethod.getId());
    }
}

