/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexDirectory;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.sections.DexLayout;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.SectionList;
import java.util.HashSet;
import java.util.Set;

public class DexMergeOptions
implements MergeOptions {
    private final boolean relocate;
    private final Set<TypeKey> mergedSet;
    private int mergeStartDexFile;

    public DexMergeOptions(boolean relocate) {
        this.relocate = relocate;
        this.mergedSet = new HashSet<TypeKey>();
    }

    public DexMergeOptions() {
        this(true);
    }

    @Override
    public boolean skipMerging(ClassId classId, TypeKey typeKey) {
        return this.mergedSet.contains(typeKey);
    }

    @Override
    public void onDuplicate(ClassId classId) {
        if (this.relocate) {
            classId.removeSelf();
        }
        this.mergedSet.add(classId.getKey());
    }

    @Override
    public void onMergeError(DexLayout dexLayout, ClassId classId, String message) {
    }

    @Override
    public void onMergeError(DexLayout dexLayout, SectionList sectionList, String message) {
    }

    @Override
    public void onDexFull(DexLayout dexLayout, ClassId classId) {
        DexFile coming = DexFile.findDexFile(classId);
        if (coming == null) {
            return;
        }
        DexFile dexFile = DexFile.findDexFile(dexLayout);
        if (dexFile == null) {
            return;
        }
        DexDirectory directory = dexFile.getDexDirectory();
        if (directory == null || directory == coming.getDexDirectory()) {
            return;
        }
        this.onCreateNext(dexLayout);
    }

    @Override
    public void onMergeSuccess(ClassId classId, TypeKey key) {
        if (!this.relocate) {
            this.mergedSet.add(key);
        }
    }

    @Override
    public boolean relocateClass() {
        return this.relocate;
    }

    @Override
    public int getMergeStartDexFile() {
        return this.mergeStartDexFile;
    }

    @Override
    public void setMergeStartDexFile(int mergeStartDexFile) {
        this.mergeStartDexFile = mergeStartDexFile;
    }

    @Override
    public DexLayout onCreateNext(DexLayout last) {
        DexFile dexFile = DexFile.findDexFile(last);
        if (dexFile == null) {
            return null;
        }
        DexDirectory directory = dexFile.getDexDirectory();
        if (directory == null || directory.getLast() != dexFile) {
            return null;
        }
        dexFile = directory.createDefault();
        this.setMergeStartDexFile(dexFile.getIndex());
        return dexFile.getDexLayout();
    }
}

