/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.EncodedArray;
import com.reandroid.dex.ins.ConstNumber;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsArrayData;
import com.reandroid.dex.ins.InsSparseSwitchData;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.value.AnnotationValue;
import com.reandroid.dex.value.ArrayValue;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.IntValue;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.util.Iterator;

public class DexIntegerVisitor
extends CombiningIterator<IntegerReference, IntegerReference> {
    public DexIntegerVisitor(DexClassRepository classRepository) {
        super(DexIntegerVisitor.getEncodedArrayReferences(classRepository), DexIntegerVisitor.getCodeItemReferences(classRepository));
    }

    private static Iterator<IntegerReference> getEncodedArrayReferences(DexClassRepository repository) {
        return new IterableIterator<EncodedArray, IntegerReference>(repository.getItems(SectionType.ENCODED_ARRAY)){

            @Override
            public Iterator<IntegerReference> iterator(EncodedArray element) {
                return DexIntegerVisitor.iterator(element);
            }
        };
    }

    private static Iterator<IntegerReference> getCodeItemReferences(DexClassRepository repository) {
        return new IterableIterator<CodeItem, IntegerReference>(repository.getItems(SectionType.CODE)){

            @Override
            public Iterator<IntegerReference> iterator(CodeItem element) {
                return DexIntegerVisitor.iterator(element);
            }
        };
    }

    static Iterator<IntegerReference> iterator(CodeItem codeItem) {
        return new IterableIterator<Ins, IntegerReference>(codeItem.getInstructionList().iterator()){

            @Override
            public Iterator<IntegerReference> iterator(Ins element) {
                return DexIntegerVisitor.iterator(element);
            }
        };
    }

    static Iterator<IntegerReference> iterator(Ins ins) {
        if (ins instanceof ConstNumber) {
            return SingleIterator.of((ConstNumber)((Object)ins));
        }
        if (ins instanceof InsArrayData) {
            return ((InsArrayData)ins).getReferences();
        }
        if (ins instanceof InsSparseSwitchData) {
            return InstanceIterator.of(((InsSparseSwitchData)ins).getLabels(), IntegerReference.class);
        }
        return EmptyIterator.of();
    }

    static Iterator<IntegerReference> iterator(EncodedArray encodedArray) {
        return new IterableIterator<DexValueBlock<?>, IntegerReference>(encodedArray.iterator()){

            @Override
            public Iterator<IntegerReference> iterator(DexValueBlock<?> element) {
                return DexIntegerVisitor.iterator(element);
            }
        };
    }

    static Iterator<IntegerReference> iterator(DexValueBlock<?> valueBlock) {
        if (valueBlock instanceof IntValue) {
            return SingleIterator.of((IntValue)valueBlock);
        }
        if (valueBlock instanceof ArrayValue) {
            return DexIntegerVisitor.iterator((ArrayValue)valueBlock);
        }
        if (valueBlock instanceof AnnotationValue) {
            return DexIntegerVisitor.iterator(((AnnotationValue)valueBlock).get());
        }
        return EmptyIterator.of();
    }

    private static Iterator<IntegerReference> iterator(ArrayValue arrayValue) {
        return new IterableIterator<DexValueBlock<?>, IntegerReference>(arrayValue.iterator()){

            @Override
            public Iterator<IntegerReference> iterator(DexValueBlock<?> element) {
                return DexIntegerVisitor.iterator(element);
            }
        };
    }

    private static Iterator<IntegerReference> iterator(AnnotationItem arrayValue) {
        return new IterableIterator<AnnotationElement, IntegerReference>(arrayValue.iterator()){

            @Override
            public Iterator<IntegerReference> iterator(AnnotationElement element) {
                return DexIntegerVisitor.iterator(element.getValue());
            }
        };
    }
}

