/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.common.Register;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.ins.ConstNumber;
import com.reandroid.dex.ins.ConstNumberLong;
import com.reandroid.dex.ins.ConstString;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsConstStringJumbo;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.RegistersSet;
import com.reandroid.dex.ins.SizeXIns;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexCode;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class DexInstruction
extends DexCode {
    private final DexMethod dexMethod;
    private final Ins mIns;

    public DexInstruction(DexMethod dexMethod, Ins ins) {
        this.dexMethod = dexMethod;
        this.mIns = ins;
    }

    public int getAddress() {
        return this.getIns().getAddress();
    }

    public int getCodeUnits() {
        return this.getIns().getCodeUnits();
    }

    public List<Register> getLocalFreeRegisters() {
        return this.getDexMethod().getLocalFreeRegisters(this.getIndex());
    }

    public String getString() {
        IdItem idItem = this.getIdSectionEntry();
        if (idItem instanceof StringId) {
            return ((StringId)idItem).getString();
        }
        return null;
    }

    public void setString(String text) {
        this.setKey(StringKey.create(text));
    }

    public DexInstruction setStringWithJumbo(String text) {
        SizeXIns sizeXIns = (SizeXIns)this.getIns();
        StringId stringId = sizeXIns.getOrCreateSectionItem(SectionType.STRING_ID, StringKey.create(text));
        if ((stringId.getIdx() & 0xFFFF0000) == 0 || !sizeXIns.is(Opcode.CONST_STRING)) {
            sizeXIns.setSectionId(stringId);
            return this;
        }
        int register = ((RegistersSet)((Object)sizeXIns)).getRegister();
        InsConstStringJumbo jumbo = sizeXIns.replace(Opcode.CONST_STRING_JUMBO);
        jumbo.setRegister(register);
        jumbo.setSectionId(stringId);
        return DexInstruction.create(this.getDexMethod(), jumbo);
    }

    public FieldKey getFieldKey() {
        IdItem idItem = this.getIdSectionEntry();
        if (idItem instanceof FieldId) {
            return ((FieldId)idItem).getKey();
        }
        return null;
    }

    public MethodKey getMethodKey() {
        IdItem idItem = this.getIdSectionEntry();
        if (idItem instanceof MethodId) {
            return ((MethodId)idItem).getKey();
        }
        return null;
    }

    public Key getKey() {
        IdItem entry = this.getIdSectionEntry();
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public void setKey(Key key) {
        Ins ins = this.getIns();
        if (ins instanceof SizeXIns) {
            ((SizeXIns)ins).setSectionIdKey(key);
        }
    }

    public IdItem getIdSectionEntry() {
        Ins ins = this.getIns();
        if (ins instanceof SizeXIns) {
            return ((SizeXIns)ins).getSectionId();
        }
        return null;
    }

    public int getRegister(int i) {
        if (i < 0) {
            return -1;
        }
        Ins ins = this.getIns();
        if (ins instanceof RegistersSet) {
            RegistersSet registersSet = (RegistersSet)((Object)ins);
            if (i >= registersSet.getRegistersCount()) {
                return -1;
            }
            return registersSet.getRegister(i);
        }
        return -1;
    }

    public int getRegister() {
        return this.getRegister(0);
    }

    public int getRegistersCount() {
        Ins ins = this.getIns();
        if (ins instanceof RegistersSet) {
            return ((RegistersSet)((Object)ins)).getRegistersCount();
        }
        return 0;
    }

    public void setRegister(int register) {
        this.setRegister(0, register);
    }

    public void setRegister(int i, int register) {
        Ins ins = this.getIns();
        if (ins instanceof RegistersSet) {
            this.ensureRegistersCount(i + 1);
            ((RegistersSet)((Object)ins)).setRegister(i, register);
        }
    }

    private void ensureRegistersCount(int count) {
        if (count > this.getRegistersCount() && this.getOpcode().getRegisterFormat().isOut()) {
            this.setRegistersCount(count);
        }
    }

    public void setRegistersCount(int count) {
        Ins ins = this.getIns();
        if (ins instanceof RegistersSet) {
            ((RegistersSet)((Object)ins)).setRegistersCount(count);
        }
    }

    public boolean is(Opcode<?> opcode) {
        return opcode == this.getOpcode();
    }

    public boolean isConstString() {
        return this.getIns() instanceof ConstString;
    }

    public boolean isNumber() {
        return this.getIns() instanceof ConstNumber;
    }

    public boolean isNumberLong() {
        return this.getIns() instanceof ConstNumberLong;
    }

    public int getTargetAddress() {
        Ins ins = this.getIns();
        if (ins instanceof Label) {
            return ((Label)((Object)ins)).getTargetAddress();
        }
        return -1;
    }

    public void setTargetAddress(int address) {
        Ins ins = this.getIns();
        if (ins instanceof Label) {
            ((Label)((Object)ins)).setTargetAddress(address);
        }
    }

    public Integer getAsInteger() {
        Ins ins = this.getIns();
        if (ins instanceof ConstNumber) {
            return ((ConstNumber)((Object)ins)).get();
        }
        return null;
    }

    public Long getAsLong() {
        Ins ins = this.getIns();
        if (ins instanceof ConstNumberLong) {
            return ((ConstNumberLong)((Object)ins)).getLong();
        }
        return null;
    }

    public void setAsInteger(int value) {
        Ins ins = this.getIns();
        if (ins instanceof ConstNumber) {
            ((ConstNumber)((Object)ins)).set(value);
        }
    }

    public void setAsLong(long value) {
        Ins ins = this.getIns();
        if (ins instanceof ConstNumberLong) {
            ((ConstNumberLong)((Object)ins)).set(value);
        }
    }

    public DexInstruction replace(String smaliString) throws IOException {
        return this.replace(SmaliReader.of(smaliString));
    }

    public DexInstruction replace(SmaliReader reader) throws IOException {
        SmaliInstruction smaliInstruction = new SmaliInstruction();
        smaliInstruction.parse(reader);
        Object ins = this.getIns().replace(smaliInstruction.getOpcode());
        ((Ins)ins).fromSmali(smaliInstruction);
        return DexInstruction.create(this.getDexMethod(), ins);
    }

    public DexInstruction createNext(String smaliString) throws IOException {
        return this.createNext(SmaliReader.of(smaliString));
    }

    public DexInstruction createNext(SmaliReader reader) throws IOException {
        SmaliInstruction smaliInstruction = new SmaliInstruction();
        smaliInstruction.parse(reader);
        Object ins = this.getIns().createNext(smaliInstruction.getOpcode());
        ((Ins)ins).fromSmali(smaliInstruction);
        return DexInstruction.create(this.getDexMethod(), ins);
    }

    public DexInstruction replace(Opcode<?> opcode) {
        return DexInstruction.create(this.getDexMethod(), this.getIns().replace(opcode));
    }

    public DexInstruction createNext(Opcode<?> opcode) {
        return DexInstruction.create(this.getDexMethod(), this.getIns().createNext(opcode));
    }

    public boolean removeSelf() {
        Ins ins = this.getIns();
        InstructionList instructionList = ins.getInstructionList();
        if (instructionList != null) {
            return instructionList.remove(ins);
        }
        return false;
    }

    public Opcode<?> getOpcode() {
        return this.getIns().getOpcode();
    }

    public Ins getIns() {
        return this.mIns;
    }

    @Override
    public boolean uses(Key key) {
        Key insKey = this.getKey();
        if (insKey != null) {
            return insKey.uses(key);
        }
        return false;
    }

    @Override
    public DexMethod getDexMethod() {
        return this.dexMethod;
    }

    public DexDeclaration findDeclaration() {
        DexClassRepository dexClassRepository;
        Key key = this.getKey();
        if (key != null && (dexClassRepository = this.getClassRepository()) != null) {
            return dexClassRepository.getDexDeclaration(key);
        }
        return null;
    }

    public DexInstruction getNext() {
        return this.getDexMethod().getInstruction(this.getIndex() + 1);
    }

    public DexInstruction getPrevious() {
        return this.getDexMethod().getInstruction(this.getIndex() - 1);
    }

    public int getIndex() {
        return this.getIns().getIndex();
    }

    public void moveBackward() {
        int index = this.getIndex();
        if (index != 0) {
            this.getIns().moveTo(index - 1);
        }
    }

    public void moveForward() {
        int index = this.getIndex() + 1;
        if (index < this.getDexMethod().getInstructionsCount()) {
            this.getIns().moveTo(index);
        }
    }

    public void moveTo(int index) {
        this.getIns().moveTo(index);
    }

    public void merge(DexInstruction other) {
        this.getIns().merge(other.getIns());
    }

    @Override
    public DexClassRepository getClassRepository() {
        return this.getDexMethod().getClassRepository();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getIns().append(writer);
    }

    public static Iterator<DexInstruction> create(DexMethod dexMethod, Iterator<Ins> iterator) {
        if (dexMethod == null) {
            return EmptyIterator.of();
        }
        return ComputeIterator.of(iterator, ins -> DexInstruction.create(dexMethod, ins));
    }

    public static DexInstruction create(DexMethod dexMethod, Ins ins) {
        if (dexMethod == null || ins == null) {
            return null;
        }
        return new DexInstruction(dexMethod, ins);
    }
}

