/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.data.StringData;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.SourceFile;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexDirectory;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMergeOptions;
import com.reandroid.dex.model.DexSource;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.DexLayout;
import com.reandroid.dex.sections.Marker;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.io.FileIterator;
import com.reandroid.utils.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class DexFile
implements DexClassRepository,
Closeable,
Iterable<DexClass>,
FullRefresh {
    private final DexLayout dexLayout;
    private DexDirectory dexDirectory;
    private boolean closed;

    public DexFile(DexLayout dexLayout) {
        this.dexLayout = dexLayout;
        dexLayout.setTag(this);
    }

    public int getVersion() {
        return this.getDexLayout().getVersion();
    }

    public void setVersion(int version) {
        this.getDexLayout().setVersion(version);
    }

    public void setClassSourceFileAll() {
        this.setClassSourceFileAll(SourceFile.SourceFile);
    }

    public void setClassSourceFileAll(String sourceFile) {
        Iterator<ClassId> iterator = this.getItems((SectionType)SectionType.CLASS_ID);
        while (iterator.hasNext()) {
            ClassId classId = iterator.next();
            classId.setSourceFile(sourceFile);
        }
    }

    public int shrink() {
        return this.getDexLayout().getSectionList().shrink();
    }

    public int clearDuplicateData() {
        return this.getDexLayout().getSectionList().clearDuplicateData();
    }

    public int clearUnused() {
        return this.getDexLayout().getSectionList().clearUnused();
    }

    public int clearEmptySections() {
        return this.getDexLayout().getSectionList().clearEmptySections();
    }

    public void clearDebug() {
        Section<CodeItem> section;
        Section<DebugInfo> debugInfoSection = this.getSection(SectionType.DEBUG_INFO);
        if (debugInfoSection != null) {
            debugInfoSection.removeSelf();
        }
        if ((section = this.getSection(SectionType.CODE)) == null) {
            return;
        }
        section.clearPool();
        section.refresh();
    }

    public void fixDebugLineNumbers() {
        Section<CodeItem> section = this.getSection(SectionType.CODE);
        if (section == null) {
            return;
        }
        for (CodeItem codeItem : section) {
            DebugInfo debugInfo = codeItem.getDebugInfo();
            if (debugInfo == null) continue;
            debugInfo.getDebugSequence().fixDebugLineNumbers();
        }
    }

    public boolean cleanInvalidDebugLineNumbers() {
        Section<CodeItem> section = this.getSection(SectionType.CODE);
        if (section == null) {
            return false;
        }
        boolean result = false;
        for (CodeItem codeItem : section) {
            if (!codeItem.cleanInvalidDebugLineNumbers()) continue;
            result = true;
        }
        return result;
    }

    public DexClassRepository getClassRepository() {
        DexDirectory directory = this.getDexDirectory();
        if (directory != null) {
            return directory;
        }
        return this;
    }

    public DexDirectory getDexDirectory() {
        return this.dexDirectory;
    }

    public void setDexDirectory(DexDirectory dexDirectory) {
        this.dexDirectory = dexDirectory;
        DexLayout dexLayout = this.getDexLayout();
        dexLayout.setTag(this);
        dexLayout.setSimpleName(this.getSimpleName());
    }

    public Iterator<DexClass> getSubTypes(TypeKey typeKey) {
        return ComputeIterator.of(this.getSubTypeIds(typeKey), this::create);
    }

    public Iterator<DexClass> getExtendingClasses(TypeKey typeKey) {
        return ComputeIterator.of(this.getExtendingClassIds(typeKey), this::create);
    }

    public Iterator<DexClass> getImplementClasses(TypeKey typeKey) {
        return ComputeIterator.of(this.getImplementationIds(typeKey), this::create);
    }

    public Iterator<ClassId> getSubTypeIds(TypeKey superClass) {
        return this.getDexLayout().getSubTypes(superClass);
    }

    public Iterator<ClassId> getExtendingClassIds(TypeKey superClass) {
        return this.getDexLayout().getExtendingClassIds(superClass);
    }

    public Iterator<ClassId> getImplementationIds(TypeKey interfaceClass) {
        return this.getDexLayout().getImplementationIds(interfaceClass);
    }

    public DexClass getOrCreateClass(String type) {
        return this.getOrCreateClass(new TypeKey(type));
    }

    public DexClass getOrCreateClass(TypeKey key) {
        DexClass dexClass = this.search(key);
        if (dexClass != null) {
            return dexClass;
        }
        ClassId classId = this.getOrCreateClassId(key);
        return this.create(classId);
    }

    public DexSource<DexFile> getSource() {
        DexDirectory directory = this.getDexDirectory();
        if (directory != null) {
            return directory.getDexSourceSet().getSource(this);
        }
        return null;
    }

    public String getSimpleName() {
        return this.getDexLayout().getSimpleName();
    }

    public void setSimpleName(String simpleName) {
        this.getDexLayout().setSimpleName(simpleName);
    }

    @Override
    public Iterator<DexClass> iterator() {
        return this.getDexClasses();
    }

    public boolean removeDexClass(TypeKey typeKey) {
        Section<ClassId> section = this.getSection(SectionType.CLASS_ID);
        if (section != null) {
            return section.remove(typeKey);
        }
        return false;
    }

    public Iterator<Key> removeClassesWithKeys(Predicate<Key> filter) {
        return this.getDexLayout().removeWithKeys(SectionType.CLASS_ID, filter);
    }

    public int removeClasses(Predicate<DexClass> filter) {
        Predicate<ClassId> classIdFilter = classId -> filter.test(this.create((ClassId)classId));
        return this.getDexLayout().removeEntries(SectionType.CLASS_ID, classIdFilter);
    }

    @Override
    public <T1 extends SectionItem> int removeEntries(SectionType<T1> sectionType, Predicate<T1> filter) {
        return this.getDexLayout().removeEntries(sectionType, filter);
    }

    public <T1 extends SectionItem> Iterator<Key> removeWithKeys(SectionType<T1> sectionType, Predicate<Key> filter) {
        return this.getDexLayout().removeWithKeys(sectionType, filter);
    }

    public <T1 extends SectionItem> Iterator<T1> getClonedItems(SectionType<T1> sectionType) {
        return this.getDexLayout().getClonedItems(sectionType);
    }

    @Override
    public int getDexClassesCount() {
        Section<ClassId> section = this.getSection(SectionType.CLASS_ID);
        if (section != null) {
            return section.getCount();
        }
        return 0;
    }

    public DexClass getDexClass(String typeName) {
        return this.getDexClass(TypeKey.create(typeName));
    }

    @Override
    public DexClass getDexClass(TypeKey key) {
        ClassId classId = this.getItem(SectionType.CLASS_ID, key);
        if (classId == null) {
            return null;
        }
        return this.create(classId);
    }

    @Override
    public Iterator<DexClass> getDexClasses(Predicate<? super TypeKey> filter) {
        return ComputeIterator.of(this.getClassIds(filter), this::create);
    }

    @Override
    public Iterator<DexClass> getDexClassesCloned(Predicate<? super TypeKey> filter) {
        return ComputeIterator.of(this.getClassIdsCloned(filter), this::create);
    }

    public <T1 extends SectionItem> Iterator<T1> getItems(SectionType<T1> sectionType) {
        return this.getDexLayout().getItems(sectionType);
    }

    @Override
    public <T1 extends SectionItem> Iterator<T1> getItems(SectionType<T1> sectionType, Key key) {
        return this.getDexLayout().getAll(sectionType, key);
    }

    @Override
    public <T1 extends SectionItem> T1 getItem(SectionType<T1> sectionType, Key key) {
        return this.getDexLayout().get(sectionType, key);
    }

    public Iterator<DexClass> searchExtending(TypeKey typeKey) {
        DexDirectory directory = this.getDexDirectory();
        if (directory != null) {
            return directory.searchExtending(typeKey);
        }
        return this.getExtendingClasses(typeKey);
    }

    public Iterator<DexClass> searchImplementations(TypeKey typeKey) {
        DexDirectory directory = this.getDexDirectory();
        if (directory != null) {
            return directory.searchImplementations(typeKey);
        }
        return this.getImplementClasses(typeKey);
    }

    public DexClass search(TypeKey typeKey) {
        return this.getClassRepository().getDexClass(typeKey);
    }

    public boolean containsClass(TypeKey key) {
        return this.contains(SectionType.CLASS_ID, key);
    }

    public boolean contains(SectionType<?> sectionType, Key key) {
        Section<?> section = this.getSection(sectionType);
        if (section != null) {
            return section.contains(key);
        }
        return false;
    }

    public boolean contains(Key key) {
        return this.getDexLayout().getSectionList().contains(key);
    }

    public ClassId getOrCreateClassId(TypeKey key) {
        Section<ClassId> section = this.getDexLayout().get(SectionType.CLASS_ID);
        DexSectionPool<ClassId> pool = section.getPool();
        ClassId classId = (ClassId)pool.get(key);
        if (classId != null) {
            return classId;
        }
        classId = pool.getOrCreate(key);
        classId.getOrCreateClassData();
        classId.setSuperClass(TypeKey.OBJECT);
        classId.setSourceFile(DexUtils.toSourceFileName(key.getTypeName()));
        classId.addAccessFlag(AccessFlag.PUBLIC);
        return classId;
    }

    public ClassId getClassId(Key key) {
        return this.getItem(SectionType.CLASS_ID, key);
    }

    private DexClass create(ClassId classId) {
        return new DexClass(this, classId);
    }

    public Marker getOrCreateMarker() {
        Marker marker = CollectionUtil.getFirst(this.getMarkers().iterator());
        if (marker != null) {
            return marker;
        }
        marker = Marker.createR8();
        Section<StringId> stringSection = this.getSection(SectionType.STRING_ID);
        StringId stringId = stringSection.createItem();
        marker.setStringId(stringId);
        marker.save();
        return marker;
    }

    public void addMarker(Marker marker) {
        StringId stringId = marker.getStringId();
        if (stringId == null) {
            Section<StringId> stringSection = this.getSection(SectionType.STRING_ID);
            stringId = stringSection.createItem();
            marker.setStringId(stringId);
        }
        marker.save();
    }

    public List<Marker> getMarkers() {
        return CollectionUtil.toList(this.getDexLayout().getMarkers());
    }

    public void clearMarkers() {
        List<Marker> markerList = this.getMarkers();
        for (Marker marker : markerList) {
            marker.removeSelf();
        }
    }

    @Override
    public void refreshFull() throws DexException {
        this.getDexLayout().refreshFull();
    }

    public void sortSection(SectionType<?>[] order) {
        this.refresh();
        this.getDexLayout().sortSection(order);
        this.refresh();
    }

    public void clearPool(SectionType<?> sectionType) {
        this.getDexLayout().clearPool(sectionType);
    }

    public void clearPools() {
        this.getDexLayout().clearPools();
    }

    public void sortStrings() {
        this.getDexLayout().sortStrings();
    }

    public Iterator<StringId> unusedStrings() {
        return this.unused(SectionType.STRING_ID);
    }

    public <T1 extends SectionItem> Iterator<T1> unused(SectionType<T1> sectionType) {
        return this.getWithUsage(sectionType, UsageMarker.USAGE_NONE);
    }

    public <T1 extends SectionItem> Iterator<T1> getWithUsage(SectionType<T1> sectionType, int usage) {
        return FilterIterator.of(this.getSection(sectionType).iterator(), item -> item.containsUsage(usage));
    }

    public Iterator<StringId> getStringsWithUsage(int usage) {
        return FilterIterator.of(this.getStringIds(), stringId -> stringId.containsUsage(usage));
    }

    public Iterator<String> getClassNames() {
        return ComputeIterator.of(this.getClassIds(), ClassId::getName);
    }

    public Iterator<DexInstruction> getDexInstructions() {
        return new IterableIterator<DexClass, DexInstruction>(this.getDexClasses()){

            @Override
            public Iterator<DexInstruction> iterator(DexClass element) {
                return element.getDexInstructions();
            }
        };
    }

    public Iterator<DexInstruction> getDexInstructionsCloned() {
        return new IterableIterator<DexClass, DexInstruction>(this.getDexClassesCloned()){

            @Override
            public Iterator<DexInstruction> iterator(DexClass element) {
                return element.getDexInstructions();
            }
        };
    }

    public Iterator<MethodDef> getMethods() {
        return new IterableIterator<ClassData, MethodDef>(this.getClassData()){

            @Override
            public Iterator<MethodDef> iterator(ClassData element) {
                return element.getMethods();
            }
        };
    }

    public Iterator<FieldDef> getFields() {
        return new IterableIterator<ClassData, FieldDef>(this.getClassData()){

            @Override
            public Iterator<FieldDef> iterator(ClassData element) {
                return element.getFields();
            }
        };
    }

    public Iterator<FieldDef> getStaticFields() {
        return new IterableIterator<ClassData, FieldDef>(this.getClassData()){

            @Override
            public Iterator<FieldDef> iterator(ClassData element) {
                return element.getStaticFields();
            }
        };
    }

    public Iterator<FieldDef> getInstanceFields() {
        return new IterableIterator<ClassData, FieldDef>(this.getClassData()){

            @Override
            public Iterator<FieldDef> iterator(ClassData element) {
                return element.getInstanceFields();
            }
        };
    }

    public Iterator<ClassData> getClassData() {
        return ComputeIterator.of(this.getClassIds(), ClassId::getClassData);
    }

    public Iterator<ClassId> getClassIds() {
        return this.getItems((SectionType)SectionType.CLASS_ID);
    }

    public Iterator<ClassId> getClassIds(Predicate<? super TypeKey> filter) {
        return FilterIterator.of(this.getItems((SectionType)SectionType.CLASS_ID), classId -> filter == null || filter.test(classId.getKey()));
    }

    public Iterator<ClassId> getClassIdsCloned(Predicate<? super TypeKey> filter) {
        return FilterIterator.of(this.getClonedItems((SectionType)SectionType.CLASS_ID), classId -> filter == null || filter.test(classId.getKey()));
    }

    public Iterator<StringId> getStringIds() {
        return this.getItems((SectionType)SectionType.STRING_ID);
    }

    public Iterator<StringData> getStringData() {
        return this.getItems((SectionType)SectionType.STRING_DATA);
    }

    public Iterator<TypeId> getTypes() {
        return this.getItems((SectionType)SectionType.TYPE_ID);
    }

    public <T1 extends SectionItem> Section<T1> getSection(SectionType<T1> sectionType) {
        return this.getDexLayout().get(sectionType);
    }

    public void refresh() {
        this.getDexLayout().refresh();
    }

    public DexLayout getDexLayout() {
        return this.dexLayout;
    }

    public boolean isEmpty() {
        return this.getDexLayout().isEmpty();
    }

    public int getIndex() {
        DexDirectory directory = this.getDexDirectory();
        if (directory != null) {
            return directory.indexOf(this);
        }
        return -1;
    }

    public boolean merge(DexClass dexClass) {
        return this.merge((MergeOptions)new DexMergeOptions(true), dexClass);
    }

    public boolean merge(MergeOptions options, DexClass dexClass) {
        return this.merge(options, dexClass.getId());
    }

    public boolean merge(ClassId classId) {
        return this.merge((MergeOptions)new DexMergeOptions(true), classId);
    }

    public boolean merge(MergeOptions options, ClassId classId) {
        return this.getDexLayout().merge(options, classId);
    }

    public boolean merge(MergeOptions options, DexFile dexFile) {
        if (dexFile == null || dexFile.isEmpty()) {
            return false;
        }
        return this.getDexLayout().merge(options, dexFile.getDexLayout());
    }

    public void parseSmaliDirectory(File dir) throws IOException {
        this.requireNotClosed();
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("No such directory: " + dir);
        }
        FileIterator iterator = new FileIterator(dir, FileIterator.getExtensionFilter(".smali"));
        while (iterator.hasNext()) {
            this.parseSmaliFile(iterator.next());
        }
        this.shrink();
    }

    public void parseSmaliFile(File file) throws IOException {
        this.requireNotClosed();
        this.fromSmali(SmaliReader.of(file));
    }

    public void fromSmali(SmaliReader reader) throws IOException {
        this.requireNotClosed();
        while (SmaliDirective.parse(reader, false) == SmaliDirective.CLASS) {
            SmaliClass smaliClass = new SmaliClass();
            smaliClass.parse(reader);
            this.fromSmali(smaliClass);
            reader.skipWhitespacesOrComment();
        }
    }

    public void fromSmali(SmaliClass smaliClass) throws IOException {
        this.requireNotClosed();
        this.getDexLayout().fromSmali(smaliClass);
    }

    public byte[] getBytes() {
        if (this.isClosed()) {
            return null;
        }
        if (this.isEmpty()) {
            return new byte[0];
        }
        return this.getDexLayout().getBytes();
    }

    public void write(File file) throws IOException {
        this.requireNotClosed();
        OutputStream outputStream = FileUtil.outputStream(file);
        this.write(outputStream);
        outputStream.close();
    }

    public void write(OutputStream outputStream) throws IOException {
        this.requireNotClosed();
        byte[] bytes = this.getBytes();
        outputStream.write(bytes, 0, bytes.length);
    }

    public String printSectionInfo() {
        return this.getDexLayout().getMapList().toString();
    }

    public void writeSmali(SmaliWriter writer, File root) throws IOException {
        this.requireNotClosed();
        File dir = new File(root, this.buildSmaliDirectoryName());
        for (DexClass dexClass : this) {
            dexClass.writeSmali(writer, dir);
        }
    }

    public String buildSmaliDirectoryName() {
        int i = 0;
        DexDirectory dexDirectory = this.getDexDirectory();
        if (dexDirectory != null) {
            for (DexFile dexFile : dexDirectory) {
                if (dexFile == this) break;
                ++i;
            }
        }
        if (i == 0) {
            return "classes";
        }
        return "classes" + ++i;
    }

    public String getFileName() {
        String simpleName = this.getSimpleName();
        if (simpleName == null) {
            return this.buildSmaliDirectoryName() + ".dex";
        }
        return FileUtil.getFileName(simpleName);
    }

    private void requireNotClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.getDexLayout().clear();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getSimpleName());
        builder.append(", version = ");
        builder.append(this.getVersion());
        builder.append(", classes = ");
        builder.append(this.getDexClassesCount());
        List<Marker> markers = this.getMarkers();
        int size = markers.size();
        if (size != 0) {
            builder.append(", markers = ");
            builder.append(size);
            if (size > 10) {
                size = 10;
            }
            for (int i = 0; i < size; ++i) {
                builder.append('\n');
                builder.append(markers.get(i));
            }
        }
        return builder.toString();
    }

    public static DexFile read(byte[] dexBytes) throws IOException {
        return DexFile.read(new BlockReader(dexBytes));
    }

    public static DexFile read(InputStream inputStream) throws IOException {
        return DexFile.read(new BlockReader(inputStream));
    }

    public static DexFile read(File file) throws IOException {
        return DexFile.read(new BlockReader(file));
    }

    public static DexFile read(BlockReader reader) throws IOException {
        DexLayout dexLayout = new DexLayout();
        dexLayout.readBytes(reader);
        reader.close();
        return new DexFile(dexLayout);
    }

    public static DexFile readStrings(BlockReader reader) throws IOException {
        DexLayout dexLayout = new DexLayout();
        dexLayout.readStrings(reader);
        return new DexFile(dexLayout);
    }

    public static DexFile readClassIds(BlockReader reader) throws IOException {
        DexLayout dexLayout = new DexLayout();
        dexLayout.readClassIds(reader);
        return new DexFile(dexLayout);
    }

    public static DexFile readSections(BlockReader reader, Predicate<SectionType<?>> filter) throws IOException {
        DexLayout dexLayout = new DexLayout();
        dexLayout.readSections(reader, filter);
        return new DexFile(dexLayout);
    }

    public static DexFile readStrings(InputStream inputStream) throws IOException {
        return DexFile.readStrings(new BlockReader(inputStream));
    }

    public static DexFile readClassIds(InputStream inputStream) throws IOException {
        return DexFile.readClassIds(new BlockReader(inputStream));
    }

    public static DexFile createDefault() {
        return new DexFile(DexLayout.createDefault());
    }

    public static DexFile findDexFile(ClassId classId) {
        if (classId == null) {
            return null;
        }
        return DexFile.findDexFile(classId.getParentInstance(DexLayout.class));
    }

    public static DexFile findDexFile(DexLayout dexLayout) {
        if (dexLayout == null) {
            return null;
        }
        Object obj = dexLayout.getTag();
        if (!(obj instanceof DexFile)) {
            return null;
        }
        return (DexFile)obj;
    }

    public static int getDexFileNumber(String name) {
        int i = name.lastIndexOf(47);
        if (i < 0) {
            i = name.lastIndexOf(92);
        }
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        if (name.equals("classes.dex")) {
            return 0;
        }
        String prefix = "classes";
        String ext = ".dex";
        if (!name.startsWith(prefix) || !name.endsWith(ext)) {
            return -1;
        }
        String num = name.substring(prefix.length(), name.length() - ext.length());
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    public static String getDexName(int i) {
        if (i == 0) {
            return "classes.dex";
        }
        if (i == 1) {
            i = 2;
        }
        return "classes" + i + ".dex";
    }
}

