/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexAnnotation;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexValue;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.ExpandIterator;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.Iterator;

public class DexField
extends DexDeclaration {
    private final DexClass dexClass;
    private final FieldDef fieldDef;

    public DexField(DexClass dexClass, FieldDef fieldDef) {
        this.dexClass = dexClass;
        this.fieldDef = fieldDef;
    }

    public FieldId getOrCreate(DexFile dexFile) {
        Section<FieldId> section = dexFile.getSection(SectionType.FIELD_ID);
        return section.getOrCreate(this.getKey());
    }

    public String getName() {
        return this.getId().getName();
    }

    public void setName(String name) {
        this.getId().setName(name);
    }

    public DexValue getInitialValue() {
        return DexValue.create(this, this.getDefinition().getStaticInitialValue());
    }

    public <T1 extends DexValueBlock<?>> T1 getOrCreateInitialValue(DexValueType<T1> dexValueType) {
        return this.getDefinition().getOrCreateStaticValue(dexValueType);
    }

    @Override
    public FieldKey getKey() {
        return this.getId().getKey();
    }

    @Override
    public FieldId getId() {
        return (FieldId)this.getDefinition().getId();
    }

    @Override
    public DexClass getDexClass() {
        return this.dexClass;
    }

    public FieldDef getDefinition() {
        return this.fieldDef;
    }

    @Override
    public Iterator<DexAnnotation> getAnnotations() {
        return ComputeIterator.of(ExpandIterator.of(this.getDefinition().getAnnotations()), annotationItem -> DexAnnotation.create(this, annotationItem));
    }

    @Override
    public Iterator<DexAnnotation> getAnnotations(TypeKey typeKey) {
        return FilterIterator.of(this.getAnnotations(), item -> typeKey.equals(item.getType()));
    }

    @Override
    public DexAnnotation getAnnotation(TypeKey typeKey) {
        return CollectionUtil.getFirst(this.getAnnotations(typeKey));
    }

    @Override
    public DexAnnotation getOrCreateAnnotation(TypeKey typeKey) {
        return DexAnnotation.create(this, this.getDefinition().getOrCreateAnnotationSet().getOrCreate(typeKey));
    }

    @Override
    public DexAnnotation newAnnotation(TypeKey typeKey) {
        return DexAnnotation.create(this, this.getDefinition().getOrCreateAnnotationSet().addNewItem(typeKey));
    }

    @Override
    public void removeSelf() {
        this.getDefinition().removeSelf();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getDefinition().append(writer);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.FIELD;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DexField dexField = (DexField)obj;
        return FieldId.equals(this.getId(), dexField.getId());
    }
}

