/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.archive.ZipEntryMap;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.id.SourceFile;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyPair;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexFileSourceSet;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMergeOptions;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.model.DexSource;
import com.reandroid.dex.sections.Marker;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionArray;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.EmptyList;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class DexDirectory
implements Iterable<DexFile>,
Closeable,
DexClassRepository,
FullRefresh {
    private final DexFileSourceSet dexSourceSet = new DexFileSourceSet();
    private Object mTag;

    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    public int getVersion() {
        DexFile first = this.getFirst();
        if (first != null) {
            return first.getVersion();
        }
        return 0;
    }

    public void setVersion(int version) {
        for (DexFile dexFile : this) {
            dexFile.setVersion(version);
        }
    }

    public void clearMarkers() {
        for (DexFile dexFile : this) {
            dexFile.clearMarkers();
        }
    }

    public List<Marker> getMarkers() {
        ArrayCollection<Marker> results = new ArrayCollection<Marker>();
        for (DexFile dexFile : this) {
            results.addAll((Collection<Marker>)dexFile.getMarkers());
        }
        return results;
    }

    public void setClassSourceFileAll() {
        this.setClassSourceFileAll(SourceFile.SourceFile);
    }

    public void setClassSourceFileAll(String sourceFile) {
        for (DexFile dexFile : this) {
            dexFile.setClassSourceFileAll(sourceFile);
        }
    }

    public int mergeAll(MergeOptions options, Iterable<DexClass> iterable) {
        return this.mergeAll(options, iterable.iterator());
    }

    public int mergeAll(MergeOptions options, Iterator<DexClass> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            boolean merged = this.merge(options, iterator.next());
            if (!merged) continue;
            ++result;
        }
        return result;
    }

    public boolean merge(DexClass dexClass) {
        return this.merge((MergeOptions)new DexMergeOptions(), dexClass);
    }

    public boolean merge(MergeOptions options, DexClass dexClass) {
        int start;
        if (dexClass.isInSameDirectory(this)) {
            return false;
        }
        if (this.containsClass(dexClass.getKey())) {
            options.onDuplicate(dexClass.getId());
            return false;
        }
        boolean startChanged = false;
        for (int i = start = options.getMergeStartDexFile(); i < this.size(); ++i) {
            DexFile dexFile = this.get(i);
            if (dexFile.merge(options, dexClass)) {
                if (startChanged) {
                    options.setMergeStartDexFile(i);
                }
                return true;
            }
            startChanged = true;
        }
        return false;
    }

    public void merge(DexDirectory directory) {
        this.merge((MergeOptions)new DexMergeOptions(false), directory);
    }

    public void merge(MergeOptions options, DexDirectory directory) {
        int start;
        if (directory == this) {
            throw new IllegalArgumentException("Cyclic merge");
        }
        int i = start = options.getMergeStartDexFile();
        while (true) {
            DexFile dexFile = this.get(i);
            DexFile last = directory.getLastNonEmpty(options, 0);
            if (dexFile == null || last == null) break;
            if (dexFile.merge(options, last)) continue;
            ++i;
        }
        if (i != start) {
            options.setMergeStartDexFile(i);
        }
        this.shrink();
        directory.merge(options);
        this.getDexSourceSet().merge(directory.getDexSourceSet());
    }

    public void merge() {
        this.merge(new DexMergeOptions());
    }

    public void merge(MergeOptions options) {
        if (this.size() < 2) {
            return;
        }
        int i = 0;
        while (true) {
            DexFile dexFile = this.get(i);
            DexFile last = this.getLastNonEmpty(options, i + 1);
            if (dexFile == null || last == null) break;
            if (dexFile.merge(options, last)) continue;
            ++i;
        }
        this.shrink();
    }

    private DexFile getLastNonEmpty(MergeOptions options, int limit) {
        int size;
        for (int i = size = this.size() - 1; i >= limit; --i) {
            DexFile dexFile = this.get(i);
            if (options.isEmptyDexFile(dexFile.getDexLayout())) continue;
            return dexFile;
        }
        return null;
    }

    public int shrink() {
        int result = 0;
        for (DexFile dexFile : this) {
            result += dexFile.shrink();
        }
        return result;
    }

    public int clearDuplicateData() {
        int result = 0;
        for (DexFile dexFile : this) {
            result += dexFile.clearDuplicateData();
        }
        return result;
    }

    public int clearUnused() {
        int result = 0;
        for (DexFile dexFile : this) {
            result += dexFile.clearUnused();
        }
        return result;
    }

    public void clearDebug() {
        for (DexFile dexFile : this) {
            dexFile.clearDebug();
        }
    }

    public void cleanDuplicateDebugLines() {
        for (DexFile dexFile : this) {
            dexFile.fixDebugLineNumbers();
        }
    }

    public Iterator<FieldKey> findEquivalentFields(FieldKey fieldKey) {
        DexClass defining = this.getDexClass(fieldKey.getDeclaring());
        if (defining == null) {
            return EmptyIterator.of();
        }
        DexField dexField = defining.getField(fieldKey);
        if (dexField == null) {
            return EmptyIterator.of();
        }
        defining = dexField.getDexClass();
        FieldKey definingKey = dexField.getKey();
        Iterator<FieldKey> subKeys = ComputeIterator.of(this.getSubTypes(defining.getKey()), dexClass -> {
            FieldKey key = definingKey.changeDeclaring(dexClass.getKey());
            DexField field = dexClass.getField(key);
            if (definingKey.equals(field.getKey())) {
                return key;
            }
            return null;
        });
        return CombiningIterator.two(SingleIterator.of(definingKey), subKeys);
    }

    public Iterator<MethodKey> findEquivalentMethods(MethodKey methodKey) {
        DexClass defining = this.getDexClass(methodKey.getDeclaring());
        if (defining == null) {
            return EmptyIterator.of();
        }
        Iterator<DexMethod> iterator = defining.getMethods(methodKey);
        return new IterableIterator<DexMethod, MethodKey>(iterator){

            @Override
            public Iterator<MethodKey> iterator(DexMethod element) {
                element = element.getDeclared();
                MethodKey definingKey = element.getKey();
                return CombiningIterator.two(SingleIterator.of(definingKey), element.getOverridingKeys());
            }
        };
    }

    public Iterator<DexClass> getSubTypes(final TypeKey typeKey) {
        return new IterableIterator<DexFile, DexClass>(this.iterator()){

            @Override
            public Iterator<DexClass> iterator(DexFile element) {
                return element.getSubTypes(typeKey);
            }
        };
    }

    public Iterator<DexClass> getImplementClasses(final TypeKey typeKey) {
        return new IterableIterator<DexFile, DexClass>(this.iterator()){

            @Override
            public Iterator<DexClass> iterator(DexFile element) {
                return element.getImplementClasses(typeKey);
            }
        };
    }

    public void save() throws IOException {
        this.dexSourceSet.saveAll();
    }

    public void save(File dir) throws IOException {
        this.dexSourceSet.saveAll(dir);
    }

    public Iterator<ClassId> getClassIds() {
        return this.getItems((SectionType)SectionType.CLASS_ID);
    }

    public <T1 extends SectionItem> T1 get(SectionType<T1> sectionType, Key key) {
        for (DexFile dexFile : this) {
            T1 item = dexFile.getItem(sectionType, key);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public <T1 extends SectionItem> Iterator<T1> getAll(final SectionType<T1> sectionType, final Key key) {
        return new IterableIterator<DexFile, T1>(this.iterator()){

            @Override
            public Iterator<T1> iterator(DexFile element) {
                return element.getItems(sectionType, key);
            }
        };
    }

    public boolean removeDexClass(TypeKey typeKey) {
        for (DexFile dexFile : this) {
            if (!dexFile.removeDexClass(typeKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T1 extends SectionItem> int removeEntries(SectionType<T1> sectionType, Predicate<T1> filter) {
        Iterator<DexFile> iterator = this.clonedIterator();
        int result = 0;
        while (iterator.hasNext()) {
            DexFile dexFile = iterator.next();
            result += dexFile.removeEntries(sectionType, filter);
        }
        return result;
    }

    public int removeClasses(Predicate<DexClass> filter) {
        Iterator<DexFile> iterator = this.clonedIterator();
        int result = 0;
        while (iterator.hasNext()) {
            DexFile dexFile = iterator.next();
            result += dexFile.removeClasses(filter);
        }
        return result;
    }

    public Iterator<Key> removeClassesWithKeys(final Predicate<Key> filter) {
        return new IterableIterator<DexFile, Key>(this.clonedIterator()){

            @Override
            public Iterator<Key> iterator(DexFile element) {
                return element.removeClassesWithKeys(filter);
            }
        };
    }

    public <T1 extends SectionItem> Iterator<T1> getClonedItems(final SectionType<T1> sectionType) {
        return new IterableIterator<DexFile, T1>(this.clonedIterator()){

            @Override
            public Iterator<T1> iterator(DexFile element) {
                return element.getClonedItems(sectionType);
            }
        };
    }

    @Override
    public int getDexClassesCount() {
        int result = 0;
        for (DexFile dexFile : this) {
            result += dexFile.getDexClassesCount();
        }
        return result;
    }

    public DexClass getDexClass(String name) {
        return this.getDexClass(TypeKey.create(name));
    }

    @Override
    public DexClass getDexClass(TypeKey key) {
        for (DexFile dexFile : this) {
            DexClass result = dexFile.getDexClass(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Iterator<DexClass> getDexClasses(final Predicate<? super TypeKey> filter) {
        return new IterableIterator<DexFile, DexClass>(this.iterator()){

            @Override
            public Iterator<DexClass> iterator(DexFile dexFile) {
                return dexFile.getDexClasses(filter);
            }
        };
    }

    @Override
    public Iterator<DexClass> getDexClassesCloned(final Predicate<? super TypeKey> filter) {
        return new IterableIterator<DexFile, DexClass>(this.clonedIterator()){

            @Override
            public Iterator<DexClass> iterator(DexFile dexFile) {
                return dexFile.getDexClassesCloned(filter);
            }
        };
    }

    public <T1 extends SectionItem> Iterator<T1> getItems(final SectionType<T1> sectionType) {
        return new IterableIterator<DexFile, T1>(this.iterator()){

            @Override
            public Iterator<T1> iterator(DexFile element) {
                return element.getItems(sectionType);
            }
        };
    }

    @Override
    public <T1 extends SectionItem> Iterator<T1> getItems(final SectionType<T1> sectionType, final Key key) {
        return new IterableIterator<DexFile, T1>(this.iterator()){

            @Override
            public Iterator<T1> iterator(DexFile dexFile) {
                return dexFile.getItems(sectionType, key);
            }
        };
    }

    @Override
    public <T1 extends SectionItem> T1 getItem(SectionType<T1> sectionType, Key key) {
        for (DexFile dexFile : this) {
            T1 item = dexFile.getItem(sectionType, key);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public Iterator<DexInstruction> getDexInstructions() {
        return new IterableIterator<DexFile, DexInstruction>(this.iterator()){

            @Override
            public Iterator<DexInstruction> iterator(DexFile element) {
                return element.getDexInstructions();
            }
        };
    }

    public Iterator<DexInstruction> getDexInstructionsCloned() {
        return new IterableIterator<DexFile, DexInstruction>(this.clonedIterator()){

            @Override
            public Iterator<DexInstruction> iterator(DexFile element) {
                return element.getDexInstructionsCloned();
            }
        };
    }

    @Override
    public Iterator<DexFile> iterator() {
        return this.dexSourceSet.getDexFiles();
    }

    public Iterator<DexFile> clonedIterator() {
        return this.dexSourceSet.getClonedDexFiles();
    }

    public void clearMethodPools() {
        for (DexFile dexFile : this) {
            dexFile.clearPool(SectionType.PROTO_ID);
            dexFile.clearPool(SectionType.METHOD_ID);
        }
    }

    public void clearPool(SectionType<?> sectionType) {
        for (DexFile dexFile : this) {
            dexFile.clearPool(sectionType);
        }
    }

    public void clearPools() {
        for (DexFile dexFile : this) {
            dexFile.clearPools();
        }
    }

    public void sortStrings() {
        for (DexFile dexFile : this) {
            dexFile.sortStrings();
        }
    }

    @Override
    public void refreshFull() {
        for (DexFile dexFile : this) {
            dexFile.setDexDirectory(this);
            dexFile.refreshFull();
        }
    }

    public void refresh() {
        for (DexFile dexFile : this) {
            dexFile.setDexDirectory(this);
            dexFile.refresh();
        }
    }

    public void updateDexFileList() {
        for (DexFile dexFile : this) {
            dexFile.setDexDirectory(this);
        }
    }

    public void addDirectory(File dir) throws IOException {
        this.getDexSourceSet().addAll(dir);
        for (DexFile dexFile : this) {
            dexFile.setDexDirectory(this);
        }
    }

    public void addApk(ZipEntryMap zipEntryMap) throws IOException {
        this.addZip(zipEntryMap, "");
    }

    public void addZip(ZipEntryMap zipEntryMap, String root) throws IOException {
        this.getDexSourceSet().addAll(zipEntryMap, root);
        for (DexFile dexFile : this) {
            dexFile.setDexDirectory(this);
        }
    }

    public void addFile(File file) throws IOException {
        DexSource<DexFile> source = this.getDexSourceSet().add(file);
        if (file.isFile()) {
            source.get().setDexDirectory(this);
        }
    }

    public DexFile createDefault() {
        DexSource<DexFile> source = this.getDexSourceSet().createNext();
        DexFile dexFile = DexFile.createDefault();
        source.set(dexFile);
        dexFile.setDexDirectory(this);
        dexFile.setSimpleName(source.toString());
        int version = this.getVersion();
        if (version != 0) {
            dexFile.setVersion(version);
        }
        return dexFile;
    }

    public DexFileSourceSet getDexSourceSet() {
        return this.dexSourceSet;
    }

    public int rename(TypeKey search, TypeKey replace) {
        if (this.containsClass(replace)) {
            throw new RuntimeException("Duplicate: " + search + " --> " + replace);
        }
        int count = 0;
        Iterator<StringId> iterator = this.renameTypes(search, replace, true, true);
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public Iterator<StringId> renameTypes(TypeKey search, TypeKey replace) {
        return this.renameTypes(search, replace, true, true);
    }

    public Iterator<StringId> renameTypes(TypeKey search, TypeKey replace, boolean renameInner, boolean renameJava) {
        return this.renameTypes(new KeyPair<TypeKey, TypeKey>(search, replace), renameInner, renameJava);
    }

    public Iterator<StringId> renameTypes(KeyPair<TypeKey, TypeKey> pair, boolean renameInner, boolean renameJava) {
        return FilterIterator.of(this.getClonedItems((SectionType)SectionType.STRING_ID), stringId -> this.renameTypes((StringId)stringId, pair, renameInner, renameJava));
    }

    public Iterator<StringId> renameTypes(Iterable<KeyPair<TypeKey, TypeKey>> iterable, boolean renameInner, boolean renameJava) {
        return FilterIterator.of(this.getClonedItems((SectionType)SectionType.STRING_ID), stringId -> this.renameTypes((StringId)stringId, iterable, renameInner, renameJava));
    }

    boolean renameTypes(StringId stringId, Iterable<KeyPair<TypeKey, TypeKey>> iterable, boolean renameInner, boolean renameJava) {
        for (KeyPair<TypeKey, TypeKey> pair : iterable) {
            boolean renamed = this.renameTypes(stringId, pair, renameInner, renameJava);
            if (!renamed) continue;
            return true;
        }
        return false;
    }

    boolean renameTypes(StringId stringId, KeyPair<TypeKey, TypeKey> pair, boolean renameInner, boolean renameJava) {
        DexClass dexClass;
        boolean renamed = this.renameTypeString(stringId, pair, renameInner, renameJava);
        if (renamed && (dexClass = this.getDexClass(stringId.getString())) != null) {
            dexClass.fixDalvikInnerClassName();
        }
        return renamed;
    }

    private boolean renameTypeString(StringId stringId, KeyPair<TypeKey, TypeKey> pair, boolean renameInner, boolean renameJava) {
        String text = stringId.getString();
        TypeKey search = pair.getFirst();
        TypeKey replace = pair.getSecond();
        String type = search.getTypeName();
        String type2 = replace.getTypeName();
        if (type.equals(text)) {
            stringId.setString(type2);
            return true;
        }
        if (renameInner && text.startsWith(type = type.replace(';', '$'))) {
            type2 = replace.getTypeName();
            type2 = type2.replace(';', '$');
            text = text.substring(type.length());
            stringId.setString(type2 + text);
            return true;
        }
        type = search.getSignatureTypeName();
        if (type.equals(text)) {
            type2 = replace.getSignatureTypeName();
            stringId.setString(type2);
            return true;
        }
        type = search.getArrayType(1);
        if (type.equals(text)) {
            type2 = replace.getArrayType(1);
            stringId.setString(type2);
            return true;
        }
        if (renameInner && text.startsWith(type = type.replace(';', '$'))) {
            type2 = replace.getArrayType(1);
            type2 = type2.replace(';', '$');
            text = text.substring(type.length());
            stringId.setString(type2 + text);
            return true;
        }
        type = search.getArrayType(2);
        if (type.equals(text)) {
            type2 = replace.getArrayType(2);
            stringId.setString(type2);
            return true;
        }
        if (renameInner && text.startsWith(type = type.replace(';', '$'))) {
            type2 = replace.getArrayType(2);
            type2 = type2.replace(';', '$');
            text = text.substring(type.length());
            stringId.setString(type2 + text);
            return true;
        }
        type = search.getArrayType(3);
        if (type.equals(text)) {
            type2 = replace.getArrayType(3);
            stringId.setString(type2);
            return true;
        }
        if (renameInner && text.startsWith(type = type.replace(';', '$'))) {
            type2 = replace.getArrayType(3);
            type2 = type2.replace(';', '$');
            text = text.substring(type.length());
            stringId.setString(type2 + text);
            return true;
        }
        if (renameJava) {
            type = search.getSourceName();
            if (type.equals(text)) {
                type2 = replace.getSourceName();
                stringId.setString(type2);
                return true;
            }
            if (renameInner) {
                if (text.startsWith(type = type + "$")) {
                    type2 = replace.getSourceName();
                    type2 = type2 + "$";
                    text = text.substring(type.length());
                    stringId.setString(type2 + text);
                    return true;
                }
                if (text.startsWith(type = type + ".")) {
                    type2 = replace.getSourceName();
                    type2 = type2 + ".";
                    text = text.substring(type.length());
                    stringId.setString(type2 + text);
                    return true;
                }
            }
        }
        return false;
    }

    public List<MethodKey> replace(MethodKey methodKey, String name) {
        List<MethodKey> results = this.rename(methodKey, name);
        if (!results.isEmpty()) {
            return results;
        }
        List<MethodId> methodIdList = CollectionUtil.toList(this.getItems(SectionType.METHOD_ID, methodKey));
        int size = methodIdList.size();
        if (size == 0) {
            return EmptyList.of();
        }
        results = new ArrayCollection<MethodKey>(size);
        for (MethodId methodId : methodIdList) {
            methodId.setName(name);
            results.add(methodId.getKey());
        }
        return results;
    }

    public List<MethodKey> rename(MethodKey methodKey, String name) {
        if (this.containsDeepSearch(methodKey.changeName(name))) {
            return EmptyList.of();
        }
        ArrayCollection<MethodId> methodIdList = new ArrayCollection<MethodId>();
        methodIdList.addAll(this.getMethods(methodKey));
        if (methodIdList.size() == 0) {
            return EmptyList.of();
        }
        MethodKey renamed = methodKey.changeName(name);
        for (MethodId methodId : methodIdList) {
            if (!renamed.equals(methodId.getKey())) continue;
            throw new IllegalArgumentException("Duplicate: " + renamed);
        }
        ArrayCollection<MethodKey> results = new ArrayCollection<MethodKey>(methodIdList.size());
        for (MethodId methodId : methodIdList) {
            methodId.setName(name);
            results.add(methodId.getKey());
        }
        return results;
    }

    public List<FieldKey> replace(FieldKey fieldKey, String name) {
        List<FieldKey> results = this.rename(fieldKey, name);
        if (!results.isEmpty()) {
            return results;
        }
        List<FieldId> fieldIdList = CollectionUtil.toList(this.getItems(SectionType.FIELD_ID, fieldKey));
        int size = fieldIdList.size();
        if (size == 0) {
            return EmptyList.of();
        }
        results = new ArrayCollection<FieldKey>(size);
        for (FieldId fieldId : fieldIdList) {
            fieldId.setName(name);
            results.add(fieldId.getKey());
        }
        return results;
    }

    public List<FieldKey> rename(FieldKey fieldKey, String name) {
        ArrayCollection<FieldKey> existingFields = ArrayCollection.of(this.findEquivalentFields(fieldKey.changeName(name)));
        ArrayCollection<FieldId> fieldIdList = ArrayCollection.of(this.getFields(fieldKey));
        if (fieldIdList.isEmpty()) {
            return EmptyList.of();
        }
        if (!existingFields.isEmpty()) {
            throw new IllegalArgumentException("Conflicting fields: " + existingFields.getFirst());
        }
        FieldKey renamed = fieldKey.changeName(name);
        for (FieldId fieldId : fieldIdList) {
            if (!renamed.equals(fieldId.getKey())) continue;
            throw new IllegalArgumentException("Duplicate: " + renamed);
        }
        ArrayCollection<FieldKey> results = new ArrayCollection<FieldKey>(fieldIdList.size());
        for (FieldId fieldId : fieldIdList) {
            fieldId.setName(name);
            results.add(fieldId.getKey());
        }
        return results;
    }

    public boolean containsDeepSearch(MethodKey methodKey) {
        DexClass startClass = this.getDexClass(methodKey.getDeclaring());
        if (startClass == null) {
            return false;
        }
        if (startClass.containsDeclaredMethod(methodKey)) {
            return true;
        }
        Iterator<DexClass> iterator = startClass.getOverridingAndSuperTypes();
        while (iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            if (!dexClass.containsDeclaredMethod(methodKey)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDeepSearch(FieldKey fieldKey) {
        DexClass startClass = this.getDexClass(fieldKey.getDeclaring());
        if (startClass == null) {
            return false;
        }
        Iterator<DexClass> iterator = startClass.getOverridingAndSuperTypes();
        while (iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            FieldKey key = fieldKey.changeDeclaring(dexClass.getKey());
            if (!fieldKey.equals(key)) continue;
            return true;
        }
        return false;
    }

    public Iterator<FieldId> getFields(FieldKey fieldKey) {
        return new IterableIterator<FieldKey, FieldId>(this.findEquivalentFields(fieldKey)){

            @Override
            public Iterator<FieldId> iterator(FieldKey element) {
                return DexDirectory.this.getAll(SectionType.FIELD_ID, element);
            }
        };
    }

    public Iterator<MethodId> getMethods(MethodKey methodKey) {
        return new IterableIterator<MethodKey, MethodId>(this.findEquivalentMethods(methodKey)){

            @Override
            public Iterator<MethodId> iterator(MethodKey element) {
                return DexDirectory.this.getAll(SectionType.METHOD_ID, element);
            }
        };
    }

    public Iterator<DexClass> searchExtending(final TypeKey typeKey) {
        return new IterableIterator<DexFile, DexClass>(this.iterator()){

            @Override
            public Iterator<DexClass> iterator(DexFile element) {
                return element.getExtendingClasses(typeKey);
            }
        };
    }

    public Iterator<DexClass> searchImplementations(final TypeKey typeKey) {
        return new IterableIterator<DexFile, DexClass>(this.iterator()){

            @Override
            public Iterator<DexClass> iterator(DexFile element) {
                return element.getImplementClasses(typeKey);
            }
        };
    }

    public boolean containsClass(TypeKey key) {
        return this.contains(SectionType.CLASS_ID, key);
    }

    public boolean contains(SectionType<?> sectionType, Key key) {
        for (DexFile dexFile : this) {
            if (!dexFile.contains(sectionType, key)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Key key) {
        for (DexFile dexFile : this) {
            if (!dexFile.contains(key)) continue;
            return true;
        }
        return false;
    }

    public int distributeClasses(int maxClassesPerDex) {
        if (maxClassesPerDex <= 0) {
            throw new IllegalArgumentException("Classes per dex must be greater than zero: " + maxClassesPerDex);
        }
        int size = this.size();
        if (size == 0) {
            return 0;
        }
        int count = this.getDexClassesCount();
        int classesPerDex = count / size;
        while (classesPerDex > maxClassesPerDex) {
            this.createDefault();
            int check = this.size();
            if (check <= size) {
                throw new IllegalArgumentException("Failed to create next dex");
            }
            size = check;
            classesPerDex = count / size;
        }
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result += this.distributeClasses(this.get(i), classesPerDex);
        }
        return result;
    }

    private int distributeClasses(DexFile source, int classesPerDex) {
        int result = 0;
        DexDirectory directory = source.getDexDirectory();
        for (int i = 0; i < directory.size(); ++i) {
            result += this.distributeClasses(source, directory.get(i), classesPerDex);
        }
        return result;
    }

    private int distributeClasses(DexFile source, DexFile destination, int classesPerDex) {
        ClassId classId;
        int result = 0;
        if (source.getDexLayout() == destination.getDexLayout()) {
            return result;
        }
        Section<ClassId> classSection = source.getSection(SectionType.CLASS_ID);
        ClassId previous = null;
        SectionArray<ClassId> array = classSection.getItemArray();
        while (source.getDexClassesCount() > classesPerDex && destination.getDexClassesCount() < classesPerDex && (classId = (ClassId)array.getLast()) != previous) {
            destination.merge(classId);
            previous = classId;
            ++result;
        }
        return result;
    }

    public DexFile get(int i) {
        return this.dexSourceSet.getDexFile(i);
    }

    public int indexOf(DexFile dexFile) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (dexFile != this.get(i)) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.dexSourceSet.size();
    }

    public DexFile getFirst() {
        DexSource<DexFile> source = this.dexSourceSet.getFirst();
        if (source != null) {
            return source.get();
        }
        return null;
    }

    public DexFile getLast() {
        DexSource<DexFile> source = this.dexSourceSet.getLast();
        if (source != null) {
            return source.get();
        }
        return null;
    }

    public DexSource<DexFile> getLastSource() {
        return this.dexSourceSet.getLast();
    }

    @Override
    public void close() throws IOException {
        this.dexSourceSet.close();
    }

    public void writeSmali(SmaliWriter writer, File root) throws IOException {
        for (DexFile dexFile : this) {
            dexFile.writeSmali(writer, root);
        }
    }

    public String toString() {
        return "DexFiles = " + this.size();
    }

    public static DexDirectory fromZip(ZipEntryMap zipEntryMap) throws IOException {
        DexDirectory dexDirectory = new DexDirectory();
        dexDirectory.getDexSourceSet().addAll(zipEntryMap);
        dexDirectory.updateDexFileList();
        return dexDirectory;
    }

    public static DexDirectory fromZip(ZipEntryMap zipEntryMap, String directoryPath) throws IOException {
        DexDirectory dexDirectory = new DexDirectory();
        dexDirectory.getDexSourceSet().addAll(zipEntryMap, directoryPath);
        dexDirectory.updateDexFileList();
        return dexDirectory;
    }

    public static DexDirectory fromDirectory(File dir) throws IOException {
        DexDirectory dexDirectory = new DexDirectory();
        dexDirectory.getDexSourceSet().addAll(dir);
        dexDirectory.updateDexFileList();
        return dexDirectory;
    }

    public static DexDirectory readStrings(ZipEntryMap zipEntryMap) throws IOException {
        return DexDirectory.readStrings(zipEntryMap, null);
    }

    public static DexDirectory readStrings(ZipEntryMap zipEntryMap, String directoryPath) throws IOException {
        DexDirectory dexDirectory = new DexDirectory();
        DexFileSourceSet sourceSet = dexDirectory.getDexSourceSet();
        sourceSet.setReadStringsMode(true);
        sourceSet.addAll(zipEntryMap, directoryPath);
        dexDirectory.updateDexFileList();
        return dexDirectory;
    }
}

